<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEntityClientDataFeedEntityClientDataFeed ArrayType
 * @subpackage Arrays
 */
class ArrayOfEntityClientDataFeedEntityClientDataFeed extends AbstractStructArrayBase
{
    /**
     * The EntityClientDataFeed
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EntityClientDataFeed[]
     */
    public $EntityClientDataFeed;
    /**
     * Constructor method for ArrayOfEntityClientDataFeedEntityClientDataFeed
     * @uses ArrayOfEntityClientDataFeedEntityClientDataFeed::setEntityClientDataFeed()
     * @param \StructType\EntityClientDataFeed[] $entityClientDataFeed
     */
    public function __construct(array $entityClientDataFeed = array())
    {
        $this
            ->setEntityClientDataFeed($entityClientDataFeed);
    }
    /**
     * Get EntityClientDataFeed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EntityClientDataFeed[]|null
     */
    public function getEntityClientDataFeed()
    {
        return isset($this->EntityClientDataFeed) ? $this->EntityClientDataFeed : null;
    }
    /**
     * Set EntityClientDataFeed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EntityClientDataFeed[] $entityClientDataFeed
     * @return \ArrayType\ArrayOfEntityClientDataFeedEntityClientDataFeed
     */
    public function setEntityClientDataFeed(array $entityClientDataFeed = array())
    {
        foreach ($entityClientDataFeed as $arrayOfEntityClientDataFeedEntityClientDataFeedEntityClientDataFeedItem) {
            // validation for constraint: itemType
            if (!$arrayOfEntityClientDataFeedEntityClientDataFeedEntityClientDataFeedItem instanceof \StructType\EntityClientDataFeed) {
                throw new \InvalidArgumentException(sprintf('The EntityClientDataFeed property can only contain items of \StructType\EntityClientDataFeed, "%s" given', is_object($arrayOfEntityClientDataFeedEntityClientDataFeedEntityClientDataFeedItem) ? get_class($arrayOfEntityClientDataFeedEntityClientDataFeedEntityClientDataFeedItem) : gettype($arrayOfEntityClientDataFeedEntityClientDataFeedEntityClientDataFeedItem)), __LINE__);
            }
        }
        if (is_null($entityClientDataFeed) || (is_array($entityClientDataFeed) && empty($entityClientDataFeed))) {
            unset($this->EntityClientDataFeed);
        } else {
            $this->EntityClientDataFeed = $entityClientDataFeed;
        }
        return $this;
    }
    /**
     * Add item to EntityClientDataFeed value
     * @throws \InvalidArgumentException
     * @param \StructType\EntityClientDataFeed $item
     * @return \ArrayType\ArrayOfEntityClientDataFeedEntityClientDataFeed
     */
    public function addToEntityClientDataFeed(\StructType\EntityClientDataFeed $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EntityClientDataFeed) {
            throw new \InvalidArgumentException(sprintf('The EntityClientDataFeed property can only contain items of \StructType\EntityClientDataFeed, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EntityClientDataFeed[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EntityClientDataFeed|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EntityClientDataFeed|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EntityClientDataFeed|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EntityClientDataFeed|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EntityClientDataFeed|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EntityClientDataFeed
     */
    public function getAttributeName()
    {
        return 'EntityClientDataFeed';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEntityClientDataFeedEntityClientDataFeed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
