<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestAuthority StructType
 * @subpackage Structs
 */
class RequestAuthority extends AbstractStructBase
{
    /**
     * The VendorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorCode;
    /**
     * The VendorPassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorPassword;
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntityID;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * The InstitutionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InstitutionID;
    /**
     * The DataFeedTypeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataFeedTypeID;
    /**
     * The authData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AuthorisationRequests
     */
    public $authData;
    /**
     * Constructor method for RequestAuthority
     * @uses RequestAuthority::setVendorCode()
     * @uses RequestAuthority::setVendorPassword()
     * @uses RequestAuthority::setEntityID()
     * @uses RequestAuthority::setClientID()
     * @uses RequestAuthority::setInstitutionID()
     * @uses RequestAuthority::setDataFeedTypeID()
     * @uses RequestAuthority::setAuthData()
     * @param string $vendorCode
     * @param string $vendorPassword
     * @param string $entityID
     * @param string $clientID
     * @param string $institutionID
     * @param string $dataFeedTypeID
     * @param \StructType\AuthorisationRequests $authData
     */
    public function __construct($vendorCode = null, $vendorPassword = null, $entityID = null, $clientID = null, $institutionID = null, $dataFeedTypeID = null, \StructType\AuthorisationRequests $authData = null)
    {
        $this
            ->setVendorCode($vendorCode)
            ->setVendorPassword($vendorPassword)
            ->setEntityID($entityID)
            ->setClientID($clientID)
            ->setInstitutionID($institutionID)
            ->setDataFeedTypeID($dataFeedTypeID)
            ->setAuthData($authData);
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\RequestAuthority
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get VendorPassword value
     * @return string|null
     */
    public function getVendorPassword()
    {
        return $this->VendorPassword;
    }
    /**
     * Set VendorPassword value
     * @param string $vendorPassword
     * @return \StructType\RequestAuthority
     */
    public function setVendorPassword($vendorPassword = null)
    {
        // validation for constraint: string
        if (!is_null($vendorPassword) && !is_string($vendorPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorPassword)), __LINE__);
        }
        $this->VendorPassword = $vendorPassword;
        return $this;
    }
    /**
     * Get EntityID value
     * @return string|null
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param string $entityID
     * @return \StructType\RequestAuthority
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: string
        if (!is_null($entityID) && !is_string($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\RequestAuthority
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get InstitutionID value
     * @return string|null
     */
    public function getInstitutionID()
    {
        return $this->InstitutionID;
    }
    /**
     * Set InstitutionID value
     * @param string $institutionID
     * @return \StructType\RequestAuthority
     */
    public function setInstitutionID($institutionID = null)
    {
        // validation for constraint: string
        if (!is_null($institutionID) && !is_string($institutionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($institutionID)), __LINE__);
        }
        $this->InstitutionID = $institutionID;
        return $this;
    }
    /**
     * Get DataFeedTypeID value
     * @return string|null
     */
    public function getDataFeedTypeID()
    {
        return $this->DataFeedTypeID;
    }
    /**
     * Set DataFeedTypeID value
     * @uses \EnumType\DataFeedTypeID::valueIsValid()
     * @uses \EnumType\DataFeedTypeID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataFeedTypeID
     * @return \StructType\RequestAuthority
     */
    public function setDataFeedTypeID($dataFeedTypeID = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DataFeedTypeID::valueIsValid($dataFeedTypeID)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dataFeedTypeID, implode(', ', \EnumType\DataFeedTypeID::getValidValues())), __LINE__);
        }
        $this->DataFeedTypeID = $dataFeedTypeID;
        return $this;
    }
    /**
     * Get authData value
     * @return \StructType\AuthorisationRequests|null
     */
    public function getAuthData()
    {
        return $this->authData;
    }
    /**
     * Set authData value
     * @param \StructType\AuthorisationRequests $authData
     * @return \StructType\RequestAuthority
     */
    public function setAuthData(\StructType\AuthorisationRequests $authData = null)
    {
        $this->authData = $authData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestAuthority
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
