<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Institution StructType
 * @subpackage Structs
 */
class Institution extends AbstractStructBase
{
    /**
     * The InstitutionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InstitutionID;
    /**
     * The InstitutionTypeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InstitutionTypeID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The AuthorityFormDeliveryMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AuthorityFormDeliveryMethod;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreationDate;
    /**
     * The UpdateDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UpdateDate;
    /**
     * Constructor method for Institution
     * @uses Institution::setInstitutionID()
     * @uses Institution::setInstitutionTypeID()
     * @uses Institution::setName()
     * @uses Institution::setEmail()
     * @uses Institution::setAuthorityFormDeliveryMethod()
     * @uses Institution::setCreationDate()
     * @uses Institution::setUpdateDate()
     * @param string $institutionID
     * @param string $institutionTypeID
     * @param string $name
     * @param string $email
     * @param string $authorityFormDeliveryMethod
     * @param string $creationDate
     * @param string $updateDate
     */
    public function __construct($institutionID = null, $institutionTypeID = null, $name = null, $email = null, $authorityFormDeliveryMethod = null, $creationDate = null, $updateDate = null)
    {
        $this
            ->setInstitutionID($institutionID)
            ->setInstitutionTypeID($institutionTypeID)
            ->setName($name)
            ->setEmail($email)
            ->setAuthorityFormDeliveryMethod($authorityFormDeliveryMethod)
            ->setCreationDate($creationDate)
            ->setUpdateDate($updateDate);
    }
    /**
     * Get InstitutionID value
     * @return string|null
     */
    public function getInstitutionID()
    {
        return $this->InstitutionID;
    }
    /**
     * Set InstitutionID value
     * @param string $institutionID
     * @return \StructType\Institution
     */
    public function setInstitutionID($institutionID = null)
    {
        // validation for constraint: string
        if (!is_null($institutionID) && !is_string($institutionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($institutionID)), __LINE__);
        }
        $this->InstitutionID = $institutionID;
        return $this;
    }
    /**
     * Get InstitutionTypeID value
     * @return string|null
     */
    public function getInstitutionTypeID()
    {
        return $this->InstitutionTypeID;
    }
    /**
     * Set InstitutionTypeID value
     * @param string $institutionTypeID
     * @return \StructType\Institution
     */
    public function setInstitutionTypeID($institutionTypeID = null)
    {
        // validation for constraint: string
        if (!is_null($institutionTypeID) && !is_string($institutionTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($institutionTypeID)), __LINE__);
        }
        $this->InstitutionTypeID = $institutionTypeID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Institution
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Institution
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get AuthorityFormDeliveryMethod value
     * @return string|null
     */
    public function getAuthorityFormDeliveryMethod()
    {
        return $this->AuthorityFormDeliveryMethod;
    }
    /**
     * Set AuthorityFormDeliveryMethod value
     * @param string $authorityFormDeliveryMethod
     * @return \StructType\Institution
     */
    public function setAuthorityFormDeliveryMethod($authorityFormDeliveryMethod = null)
    {
        // validation for constraint: string
        if (!is_null($authorityFormDeliveryMethod) && !is_string($authorityFormDeliveryMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorityFormDeliveryMethod)), __LINE__);
        }
        $this->AuthorityFormDeliveryMethod = $authorityFormDeliveryMethod;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\Institution
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get UpdateDate value
     * @return string|null
     */
    public function getUpdateDate()
    {
        return $this->UpdateDate;
    }
    /**
     * Set UpdateDate value
     * @param string $updateDate
     * @return \StructType\Institution
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateDate) && !is_string($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateDate)), __LINE__);
        }
        $this->UpdateDate = $updateDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Institution
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
