<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityClientSetup StructType
 * @subpackage Structs
 */
class EntityClientSetup extends AbstractStructBase
{
    /**
     * The VendorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorCode;
    /**
     * The VendorPassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorPassword;
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntityID;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * The ClientName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClientName;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * Constructor method for EntityClientSetup
     * @uses EntityClientSetup::setVendorCode()
     * @uses EntityClientSetup::setVendorPassword()
     * @uses EntityClientSetup::setEntityID()
     * @uses EntityClientSetup::setClientID()
     * @uses EntityClientSetup::setClientName()
     * @uses EntityClientSetup::setAction()
     * @param string $vendorCode
     * @param string $vendorPassword
     * @param string $entityID
     * @param string $clientID
     * @param string $clientName
     * @param string $action
     */
    public function __construct($vendorCode = null, $vendorPassword = null, $entityID = null, $clientID = null, $clientName = null, $action = null)
    {
        $this
            ->setVendorCode($vendorCode)
            ->setVendorPassword($vendorPassword)
            ->setEntityID($entityID)
            ->setClientID($clientID)
            ->setClientName($clientName)
            ->setAction($action);
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\EntityClientSetup
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get VendorPassword value
     * @return string|null
     */
    public function getVendorPassword()
    {
        return $this->VendorPassword;
    }
    /**
     * Set VendorPassword value
     * @param string $vendorPassword
     * @return \StructType\EntityClientSetup
     */
    public function setVendorPassword($vendorPassword = null)
    {
        // validation for constraint: string
        if (!is_null($vendorPassword) && !is_string($vendorPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorPassword)), __LINE__);
        }
        $this->VendorPassword = $vendorPassword;
        return $this;
    }
    /**
     * Get EntityID value
     * @return string|null
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param string $entityID
     * @return \StructType\EntityClientSetup
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: string
        if (!is_null($entityID) && !is_string($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\EntityClientSetup
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get ClientName value
     * @return string|null
     */
    public function getClientName()
    {
        return $this->ClientName;
    }
    /**
     * Set ClientName value
     * @param string $clientName
     * @return \StructType\EntityClientSetup
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientName)), __LINE__);
        }
        $this->ClientName = $clientName;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\Action::valueIsValid()
     * @uses \EnumType\Action::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\EntityClientSetup
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Action::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\Action::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntityClientSetup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
