<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityClientDataFeedList StructType
 * @subpackage Structs
 */
class EntityClientDataFeedList extends AbstractStructBase
{
    /**
     * The VendorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorCode;
    /**
     * The VendorPassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorPassword;
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntityID;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * Constructor method for EntityClientDataFeedList
     * @uses EntityClientDataFeedList::setVendorCode()
     * @uses EntityClientDataFeedList::setVendorPassword()
     * @uses EntityClientDataFeedList::setEntityID()
     * @uses EntityClientDataFeedList::setClientID()
     * @param string $vendorCode
     * @param string $vendorPassword
     * @param string $entityID
     * @param string $clientID
     */
    public function __construct($vendorCode = null, $vendorPassword = null, $entityID = null, $clientID = null)
    {
        $this
            ->setVendorCode($vendorCode)
            ->setVendorPassword($vendorPassword)
            ->setEntityID($entityID)
            ->setClientID($clientID);
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\EntityClientDataFeedList
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get VendorPassword value
     * @return string|null
     */
    public function getVendorPassword()
    {
        return $this->VendorPassword;
    }
    /**
     * Set VendorPassword value
     * @param string $vendorPassword
     * @return \StructType\EntityClientDataFeedList
     */
    public function setVendorPassword($vendorPassword = null)
    {
        // validation for constraint: string
        if (!is_null($vendorPassword) && !is_string($vendorPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorPassword)), __LINE__);
        }
        $this->VendorPassword = $vendorPassword;
        return $this;
    }
    /**
     * Get EntityID value
     * @return string|null
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param string $entityID
     * @return \StructType\EntityClientDataFeedList
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: string
        if (!is_null($entityID) && !is_string($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\EntityClientDataFeedList
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntityClientDataFeedList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
