<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityClientDataFeed StructType
 * @subpackage Structs
 */
class EntityClientDataFeed extends AbstractStructBase
{
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntityID;
    /**
     * The SoftwareID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SoftwareID;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * The InstitutionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InstitutionID;
    /**
     * The Institution
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Institution;
    /**
     * The InstitutionTypeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InstitutionTypeID;
    /**
     * The AccountName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * The BankAccountNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountNo;
    /**
     * The BankAccountBSB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountBSB;
    /**
     * The BrokerAFSL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BrokerAFSL;
    /**
     * The BrokerAFSLAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BrokerAFSLAlt;
    /**
     * The BrokerHIN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BrokerHIN;
    /**
     * The BrokerAccountNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BrokerAccountNo;
    /**
     * The BrokerAccountNoAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BrokerAccountNoAlt;
    /**
     * The WrapAccountNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $WrapAccountNo;
    /**
     * Constructor method for EntityClientDataFeed
     * @uses EntityClientDataFeed::setEntityID()
     * @uses EntityClientDataFeed::setSoftwareID()
     * @uses EntityClientDataFeed::setClientID()
     * @uses EntityClientDataFeed::setInstitutionID()
     * @uses EntityClientDataFeed::setInstitution()
     * @uses EntityClientDataFeed::setInstitutionTypeID()
     * @uses EntityClientDataFeed::setAccountName()
     * @uses EntityClientDataFeed::setStatus()
     * @uses EntityClientDataFeed::setReason()
     * @uses EntityClientDataFeed::setBankAccountNo()
     * @uses EntityClientDataFeed::setBankAccountBSB()
     * @uses EntityClientDataFeed::setBrokerAFSL()
     * @uses EntityClientDataFeed::setBrokerAFSLAlt()
     * @uses EntityClientDataFeed::setBrokerHIN()
     * @uses EntityClientDataFeed::setBrokerAccountNo()
     * @uses EntityClientDataFeed::setBrokerAccountNoAlt()
     * @uses EntityClientDataFeed::setWrapAccountNo()
     * @param string $entityID
     * @param string $softwareID
     * @param string $clientID
     * @param string $institutionID
     * @param string $institution
     * @param string $institutionTypeID
     * @param string $accountName
     * @param string $status
     * @param string $reason
     * @param string $bankAccountNo
     * @param string $bankAccountBSB
     * @param string $brokerAFSL
     * @param string $brokerAFSLAlt
     * @param string $brokerHIN
     * @param string $brokerAccountNo
     * @param string $brokerAccountNoAlt
     * @param string $wrapAccountNo
     */
    public function __construct($entityID = null, $softwareID = null, $clientID = null, $institutionID = null, $institution = null, $institutionTypeID = null, $accountName = null, $status = null, $reason = null, $bankAccountNo = null, $bankAccountBSB = null, $brokerAFSL = null, $brokerAFSLAlt = null, $brokerHIN = null, $brokerAccountNo = null, $brokerAccountNoAlt = null, $wrapAccountNo = null)
    {
        $this
            ->setEntityID($entityID)
            ->setSoftwareID($softwareID)
            ->setClientID($clientID)
            ->setInstitutionID($institutionID)
            ->setInstitution($institution)
            ->setInstitutionTypeID($institutionTypeID)
            ->setAccountName($accountName)
            ->setStatus($status)
            ->setReason($reason)
            ->setBankAccountNo($bankAccountNo)
            ->setBankAccountBSB($bankAccountBSB)
            ->setBrokerAFSL($brokerAFSL)
            ->setBrokerAFSLAlt($brokerAFSLAlt)
            ->setBrokerHIN($brokerHIN)
            ->setBrokerAccountNo($brokerAccountNo)
            ->setBrokerAccountNoAlt($brokerAccountNoAlt)
            ->setWrapAccountNo($wrapAccountNo);
    }
    /**
     * Get EntityID value
     * @return string|null
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param string $entityID
     * @return \StructType\EntityClientDataFeed
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: string
        if (!is_null($entityID) && !is_string($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get SoftwareID value
     * @return string|null
     */
    public function getSoftwareID()
    {
        return $this->SoftwareID;
    }
    /**
     * Set SoftwareID value
     * @param string $softwareID
     * @return \StructType\EntityClientDataFeed
     */
    public function setSoftwareID($softwareID = null)
    {
        // validation for constraint: string
        if (!is_null($softwareID) && !is_string($softwareID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($softwareID)), __LINE__);
        }
        $this->SoftwareID = $softwareID;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\EntityClientDataFeed
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get InstitutionID value
     * @return string|null
     */
    public function getInstitutionID()
    {
        return $this->InstitutionID;
    }
    /**
     * Set InstitutionID value
     * @param string $institutionID
     * @return \StructType\EntityClientDataFeed
     */
    public function setInstitutionID($institutionID = null)
    {
        // validation for constraint: string
        if (!is_null($institutionID) && !is_string($institutionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($institutionID)), __LINE__);
        }
        $this->InstitutionID = $institutionID;
        return $this;
    }
    /**
     * Get Institution value
     * @return string|null
     */
    public function getInstitution()
    {
        return $this->Institution;
    }
    /**
     * Set Institution value
     * @param string $institution
     * @return \StructType\EntityClientDataFeed
     */
    public function setInstitution($institution = null)
    {
        // validation for constraint: string
        if (!is_null($institution) && !is_string($institution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($institution)), __LINE__);
        }
        $this->Institution = $institution;
        return $this;
    }
    /**
     * Get InstitutionTypeID value
     * @return string|null
     */
    public function getInstitutionTypeID()
    {
        return $this->InstitutionTypeID;
    }
    /**
     * Set InstitutionTypeID value
     * @param string $institutionTypeID
     * @return \StructType\EntityClientDataFeed
     */
    public function setInstitutionTypeID($institutionTypeID = null)
    {
        // validation for constraint: string
        if (!is_null($institutionTypeID) && !is_string($institutionTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($institutionTypeID)), __LINE__);
        }
        $this->InstitutionTypeID = $institutionTypeID;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \StructType\EntityClientDataFeed
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\EntityClientDataFeed
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\EntityClientDataFeed
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get BankAccountNo value
     * @return string|null
     */
    public function getBankAccountNo()
    {
        return $this->BankAccountNo;
    }
    /**
     * Set BankAccountNo value
     * @param string $bankAccountNo
     * @return \StructType\EntityClientDataFeed
     */
    public function setBankAccountNo($bankAccountNo = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNo) && !is_string($bankAccountNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNo)), __LINE__);
        }
        $this->BankAccountNo = $bankAccountNo;
        return $this;
    }
    /**
     * Get BankAccountBSB value
     * @return string|null
     */
    public function getBankAccountBSB()
    {
        return $this->BankAccountBSB;
    }
    /**
     * Set BankAccountBSB value
     * @param string $bankAccountBSB
     * @return \StructType\EntityClientDataFeed
     */
    public function setBankAccountBSB($bankAccountBSB = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountBSB) && !is_string($bankAccountBSB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountBSB)), __LINE__);
        }
        $this->BankAccountBSB = $bankAccountBSB;
        return $this;
    }
    /**
     * Get BrokerAFSL value
     * @return string|null
     */
    public function getBrokerAFSL()
    {
        return $this->BrokerAFSL;
    }
    /**
     * Set BrokerAFSL value
     * @param string $brokerAFSL
     * @return \StructType\EntityClientDataFeed
     */
    public function setBrokerAFSL($brokerAFSL = null)
    {
        // validation for constraint: string
        if (!is_null($brokerAFSL) && !is_string($brokerAFSL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brokerAFSL)), __LINE__);
        }
        $this->BrokerAFSL = $brokerAFSL;
        return $this;
    }
    /**
     * Get BrokerAFSLAlt value
     * @return string|null
     */
    public function getBrokerAFSLAlt()
    {
        return $this->BrokerAFSLAlt;
    }
    /**
     * Set BrokerAFSLAlt value
     * @param string $brokerAFSLAlt
     * @return \StructType\EntityClientDataFeed
     */
    public function setBrokerAFSLAlt($brokerAFSLAlt = null)
    {
        // validation for constraint: string
        if (!is_null($brokerAFSLAlt) && !is_string($brokerAFSLAlt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brokerAFSLAlt)), __LINE__);
        }
        $this->BrokerAFSLAlt = $brokerAFSLAlt;
        return $this;
    }
    /**
     * Get BrokerHIN value
     * @return string|null
     */
    public function getBrokerHIN()
    {
        return $this->BrokerHIN;
    }
    /**
     * Set BrokerHIN value
     * @param string $brokerHIN
     * @return \StructType\EntityClientDataFeed
     */
    public function setBrokerHIN($brokerHIN = null)
    {
        // validation for constraint: string
        if (!is_null($brokerHIN) && !is_string($brokerHIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brokerHIN)), __LINE__);
        }
        $this->BrokerHIN = $brokerHIN;
        return $this;
    }
    /**
     * Get BrokerAccountNo value
     * @return string|null
     */
    public function getBrokerAccountNo()
    {
        return $this->BrokerAccountNo;
    }
    /**
     * Set BrokerAccountNo value
     * @param string $brokerAccountNo
     * @return \StructType\EntityClientDataFeed
     */
    public function setBrokerAccountNo($brokerAccountNo = null)
    {
        // validation for constraint: string
        if (!is_null($brokerAccountNo) && !is_string($brokerAccountNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brokerAccountNo)), __LINE__);
        }
        $this->BrokerAccountNo = $brokerAccountNo;
        return $this;
    }
    /**
     * Get BrokerAccountNoAlt value
     * @return string|null
     */
    public function getBrokerAccountNoAlt()
    {
        return $this->BrokerAccountNoAlt;
    }
    /**
     * Set BrokerAccountNoAlt value
     * @param string $brokerAccountNoAlt
     * @return \StructType\EntityClientDataFeed
     */
    public function setBrokerAccountNoAlt($brokerAccountNoAlt = null)
    {
        // validation for constraint: string
        if (!is_null($brokerAccountNoAlt) && !is_string($brokerAccountNoAlt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brokerAccountNoAlt)), __LINE__);
        }
        $this->BrokerAccountNoAlt = $brokerAccountNoAlt;
        return $this;
    }
    /**
     * Get WrapAccountNo value
     * @return string|null
     */
    public function getWrapAccountNo()
    {
        return $this->WrapAccountNo;
    }
    /**
     * Set WrapAccountNo value
     * @param string $wrapAccountNo
     * @return \StructType\EntityClientDataFeed
     */
    public function setWrapAccountNo($wrapAccountNo = null)
    {
        // validation for constraint: string
        if (!is_null($wrapAccountNo) && !is_string($wrapAccountNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wrapAccountNo)), __LINE__);
        }
        $this->WrapAccountNo = $wrapAccountNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EntityClientDataFeed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
