<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientDataFeedSetup StructType
 * @subpackage Structs
 */
class ClientDataFeedSetup extends AbstractStructBase
{
    /**
     * The VendorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorCode;
    /**
     * The VendorPassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorPassword;
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntityID;
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * The InstitutionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InstitutionID;
    /**
     * The DataFeedTypeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataFeedTypeID;
    /**
     * The AccountName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * The BSB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BSB;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The FeedCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FeedCode;
    /**
     * Constructor method for ClientDataFeedSetup
     * @uses ClientDataFeedSetup::setVendorCode()
     * @uses ClientDataFeedSetup::setVendorPassword()
     * @uses ClientDataFeedSetup::setEntityID()
     * @uses ClientDataFeedSetup::setClientID()
     * @uses ClientDataFeedSetup::setInstitutionID()
     * @uses ClientDataFeedSetup::setDataFeedTypeID()
     * @uses ClientDataFeedSetup::setAccountName()
     * @uses ClientDataFeedSetup::setBSB()
     * @uses ClientDataFeedSetup::setAccountNumber()
     * @uses ClientDataFeedSetup::setAction()
     * @uses ClientDataFeedSetup::setFeedCode()
     * @param string $vendorCode
     * @param string $vendorPassword
     * @param string $entityID
     * @param string $clientID
     * @param string $institutionID
     * @param string $dataFeedTypeID
     * @param string $accountName
     * @param string $bSB
     * @param string $accountNumber
     * @param string $action
     * @param string $feedCode
     */
    public function __construct($vendorCode = null, $vendorPassword = null, $entityID = null, $clientID = null, $institutionID = null, $dataFeedTypeID = null, $accountName = null, $bSB = null, $accountNumber = null, $action = null, $feedCode = null)
    {
        $this
            ->setVendorCode($vendorCode)
            ->setVendorPassword($vendorPassword)
            ->setEntityID($entityID)
            ->setClientID($clientID)
            ->setInstitutionID($institutionID)
            ->setDataFeedTypeID($dataFeedTypeID)
            ->setAccountName($accountName)
            ->setBSB($bSB)
            ->setAccountNumber($accountNumber)
            ->setAction($action)
            ->setFeedCode($feedCode);
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\ClientDataFeedSetup
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get VendorPassword value
     * @return string|null
     */
    public function getVendorPassword()
    {
        return $this->VendorPassword;
    }
    /**
     * Set VendorPassword value
     * @param string $vendorPassword
     * @return \StructType\ClientDataFeedSetup
     */
    public function setVendorPassword($vendorPassword = null)
    {
        // validation for constraint: string
        if (!is_null($vendorPassword) && !is_string($vendorPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorPassword)), __LINE__);
        }
        $this->VendorPassword = $vendorPassword;
        return $this;
    }
    /**
     * Get EntityID value
     * @return string|null
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param string $entityID
     * @return \StructType\ClientDataFeedSetup
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: string
        if (!is_null($entityID) && !is_string($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\ClientDataFeedSetup
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get InstitutionID value
     * @return string|null
     */
    public function getInstitutionID()
    {
        return $this->InstitutionID;
    }
    /**
     * Set InstitutionID value
     * @param string $institutionID
     * @return \StructType\ClientDataFeedSetup
     */
    public function setInstitutionID($institutionID = null)
    {
        // validation for constraint: string
        if (!is_null($institutionID) && !is_string($institutionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($institutionID)), __LINE__);
        }
        $this->InstitutionID = $institutionID;
        return $this;
    }
    /**
     * Get DataFeedTypeID value
     * @return string|null
     */
    public function getDataFeedTypeID()
    {
        return $this->DataFeedTypeID;
    }
    /**
     * Set DataFeedTypeID value
     * @uses \EnumType\DataFeedTypeID::valueIsValid()
     * @uses \EnumType\DataFeedTypeID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataFeedTypeID
     * @return \StructType\ClientDataFeedSetup
     */
    public function setDataFeedTypeID($dataFeedTypeID = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DataFeedTypeID::valueIsValid($dataFeedTypeID)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dataFeedTypeID, implode(', ', \EnumType\DataFeedTypeID::getValidValues())), __LINE__);
        }
        $this->DataFeedTypeID = $dataFeedTypeID;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \StructType\ClientDataFeedSetup
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get BSB value
     * @return string|null
     */
    public function getBSB()
    {
        return $this->BSB;
    }
    /**
     * Set BSB value
     * @param string $bSB
     * @return \StructType\ClientDataFeedSetup
     */
    public function setBSB($bSB = null)
    {
        // validation for constraint: string
        if (!is_null($bSB) && !is_string($bSB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bSB)), __LINE__);
        }
        $this->BSB = $bSB;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\ClientDataFeedSetup
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \EnumType\Action::valueIsValid()
     * @uses \EnumType\Action::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\ClientDataFeedSetup
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Action::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\Action::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get FeedCode value
     * @return string|null
     */
    public function getFeedCode()
    {
        return $this->FeedCode;
    }
    /**
     * Set FeedCode value
     * @param string $feedCode
     * @return \StructType\ClientDataFeedSetup
     */
    public function setFeedCode($feedCode = null)
    {
        // validation for constraint: string
        if (!is_null($feedCode) && !is_string($feedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feedCode)), __LINE__);
        }
        $this->FeedCode = $feedCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClientDataFeedSetup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
