<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Institution ServiceType
 * @subpackage Services
 */
class Institution extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InstitutionList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InstitutionList $parameters
     * @return \StructType\InstitutionListResponse|bool
     */
    public function InstitutionList(\StructType\InstitutionList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InstitutionList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InstitutionListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
