<?php

namespace EnumType;

/**
 * This class stands for DataFeedTypeID EnumType
 * @subpackage Enumerations
 */
class DataFeedTypeID
{
    /**
     * Constant for value 'BNKA'
     * @return string 'BNKA'
     */
    const VALUE_BNKA = 'BNKA';
    /**
     * Constant for value 'STBA'
     * @return string 'STBA'
     */
    const VALUE_STBA = 'STBA';
    /**
     * Constant for value 'WMFA'
     * @return string 'WMFA'
     */
    const VALUE_WMFA = 'WMFA';
    /**
     * Constant for value 'SDSA'
     * @return string 'SDSA'
     */
    const VALUE_SDSA = 'SDSA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BNKA
     * @uses self::VALUE_STBA
     * @uses self::VALUE_WMFA
     * @uses self::VALUE_SDSA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BNKA,
            self::VALUE_STBA,
            self::VALUE_WMFA,
            self::VALUE_SDSA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
