<?php

namespace EnumType;

/**
 * This class stands for Action EnumType
 * @subpackage Enumerations
 */
class Action
{
    /**
     * Constant for value 'ADD'
     * @return string 'ADD'
     */
    const VALUE_ADD = 'ADD';
    /**
     * Constant for value 'CHANGE'
     * @return string 'CHANGE'
     */
    const VALUE_CHANGE = 'CHANGE';
    /**
     * Constant for value 'DEACTIVATE'
     * @return string 'DEACTIVATE'
     */
    const VALUE_DEACTIVATE = 'DEACTIVATE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD
     * @uses self::VALUE_CHANGE
     * @uses self::VALUE_DEACTIVATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD,
            self::VALUE_CHANGE,
            self::VALUE_DEACTIVATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
