<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEntityClientEntityClient ArrayType
 * @subpackage Arrays
 */
class ArrayOfEntityClientEntityClient extends AbstractStructArrayBase
{
    /**
     * The EntityClient
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EntityClient[]
     */
    public $EntityClient;
    /**
     * Constructor method for ArrayOfEntityClientEntityClient
     * @uses ArrayOfEntityClientEntityClient::setEntityClient()
     * @param \StructType\EntityClient[] $entityClient
     */
    public function __construct(array $entityClient = array())
    {
        $this
            ->setEntityClient($entityClient);
    }
    /**
     * Get EntityClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EntityClient[]|null
     */
    public function getEntityClient()
    {
        return isset($this->EntityClient) ? $this->EntityClient : null;
    }
    /**
     * Set EntityClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EntityClient[] $entityClient
     * @return \ArrayType\ArrayOfEntityClientEntityClient
     */
    public function setEntityClient(array $entityClient = array())
    {
        foreach ($entityClient as $arrayOfEntityClientEntityClientEntityClientItem) {
            // validation for constraint: itemType
            if (!$arrayOfEntityClientEntityClientEntityClientItem instanceof \StructType\EntityClient) {
                throw new \InvalidArgumentException(sprintf('The EntityClient property can only contain items of \StructType\EntityClient, "%s" given', is_object($arrayOfEntityClientEntityClientEntityClientItem) ? get_class($arrayOfEntityClientEntityClientEntityClientItem) : gettype($arrayOfEntityClientEntityClientEntityClientItem)), __LINE__);
            }
        }
        if (is_null($entityClient) || (is_array($entityClient) && empty($entityClient))) {
            unset($this->EntityClient);
        } else {
            $this->EntityClient = $entityClient;
        }
        return $this;
    }
    /**
     * Add item to EntityClient value
     * @throws \InvalidArgumentException
     * @param \StructType\EntityClient $item
     * @return \ArrayType\ArrayOfEntityClientEntityClient
     */
    public function addToEntityClient(\StructType\EntityClient $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EntityClient) {
            throw new \InvalidArgumentException(sprintf('The EntityClient property can only contain items of \StructType\EntityClient, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EntityClient[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EntityClient|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EntityClient|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EntityClient|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EntityClient|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EntityClient|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EntityClient
     */
    public function getAttributeName()
    {
        return 'EntityClient';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEntityClientEntityClient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
