<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthHeader StructType
 * Meta information extracted from the WSDL
 * - type: tns:AuthHeader
 * @subpackage Structs
 */
class AuthHeader extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MerchantID;
    /**
     * The AcquirerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AcquirerID;
    /**
     * Constructor method for AuthHeader
     * @uses AuthHeader::setMerchantID()
     * @uses AuthHeader::setAcquirerID()
     * @param string $merchantID
     * @param string $acquirerID
     */
    public function __construct($merchantID = null, $acquirerID = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setAcquirerID($acquirerID);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\AuthHeader
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get AcquirerID value
     * @return string
     */
    public function getAcquirerID()
    {
        return $this->AcquirerID;
    }
    /**
     * Set AcquirerID value
     * @param string $acquirerID
     * @return \StructType\AuthHeader
     */
    public function setAcquirerID($acquirerID = null)
    {
        // validation for constraint: string
        if (!is_null($acquirerID) && !is_string($acquirerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acquirerID, true), gettype($acquirerID)), __LINE__);
        }
        $this->AcquirerID = $acquirerID;
        return $this;
    }
}
