<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Sets the AuthHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthHeader $authHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthHeader(\StructType\AuthHeader $authHeader, $nameSpace = 'http://www.hps.ma/PowerCARD/PaymentGateway/OnlineServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthHeader', $authHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessAuthorization
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthHeader
     * - SOAPHeaderNamespaces: http://www.hps.ma/PowerCARD/PaymentGateway/OnlineServices
     * - SOAPHeaderTypes: \StructType\AuthHeader
     * - SOAPHeaders: required
     * - documentation: This method is used to process new authorization
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthorizationInfo $parameters
     * @return \StructType\AuthorizationInfoResponse|bool
     */
    public function ProcessAuthorization(\StructType\AuthorizationInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessAuthorization($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AuthorizationInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
