<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizationInfoResponse StructType
 * @subpackage Structs
 */
class AuthorizationInfoResponse extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResponseCode;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonCode;
    /**
     * The ReasonCodeDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonCodeDesc;
    /**
     * The MerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerID;
    /**
     * The AcqID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AcqID;
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderID;
    /**
     * The SignatureMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SignatureMethod;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Signature;
    /**
     * The ReferenceNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNo;
    /**
     * The AuthorizationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardNumber;
    /**
     * The HashValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HashValue;
    /**
     * Constructor method for AuthorizationInfoResponse
     * @uses AuthorizationInfoResponse::setResponseCode()
     * @uses AuthorizationInfoResponse::setReasonCode()
     * @uses AuthorizationInfoResponse::setReasonCodeDesc()
     * @uses AuthorizationInfoResponse::setMerID()
     * @uses AuthorizationInfoResponse::setAcqID()
     * @uses AuthorizationInfoResponse::setOrderID()
     * @uses AuthorizationInfoResponse::setSignatureMethod()
     * @uses AuthorizationInfoResponse::setSignature()
     * @uses AuthorizationInfoResponse::setReferenceNo()
     * @uses AuthorizationInfoResponse::setAuthorizationCode()
     * @uses AuthorizationInfoResponse::setCardNumber()
     * @uses AuthorizationInfoResponse::setHashValue()
     * @param string $responseCode
     * @param string $reasonCode
     * @param string $reasonCodeDesc
     * @param string $merID
     * @param string $acqID
     * @param string $orderID
     * @param string $signatureMethod
     * @param string $signature
     * @param string $referenceNo
     * @param string $authorizationCode
     * @param string $cardNumber
     * @param string $hashValue
     */
    public function __construct($responseCode = null, $reasonCode = null, $reasonCodeDesc = null, $merID = null, $acqID = null, $orderID = null, $signatureMethod = null, $signature = null, $referenceNo = null, $authorizationCode = null, $cardNumber = null, $hashValue = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setReasonCode($reasonCode)
            ->setReasonCodeDesc($reasonCodeDesc)
            ->setMerID($merID)
            ->setAcqID($acqID)
            ->setOrderID($orderID)
            ->setSignatureMethod($signatureMethod)
            ->setSignature($signature)
            ->setReferenceNo($referenceNo)
            ->setAuthorizationCode($authorizationCode)
            ->setCardNumber($cardNumber)
            ->setHashValue($hashValue);
    }
    /**
     * Get ResponseCode value
     * @return string|null
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get ReasonCodeDesc value
     * @return string|null
     */
    public function getReasonCodeDesc()
    {
        return $this->ReasonCodeDesc;
    }
    /**
     * Set ReasonCodeDesc value
     * @param string $reasonCodeDesc
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setReasonCodeDesc($reasonCodeDesc = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCodeDesc) && !is_string($reasonCodeDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCodeDesc, true), gettype($reasonCodeDesc)), __LINE__);
        }
        $this->ReasonCodeDesc = $reasonCodeDesc;
        return $this;
    }
    /**
     * Get MerID value
     * @return string|null
     */
    public function getMerID()
    {
        return $this->MerID;
    }
    /**
     * Set MerID value
     * @param string $merID
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setMerID($merID = null)
    {
        // validation for constraint: string
        if (!is_null($merID) && !is_string($merID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merID, true), gettype($merID)), __LINE__);
        }
        $this->MerID = $merID;
        return $this;
    }
    /**
     * Get AcqID value
     * @return string|null
     */
    public function getAcqID()
    {
        return $this->AcqID;
    }
    /**
     * Set AcqID value
     * @param string $acqID
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setAcqID($acqID = null)
    {
        // validation for constraint: string
        if (!is_null($acqID) && !is_string($acqID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acqID, true), gettype($acqID)), __LINE__);
        }
        $this->AcqID = $acqID;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get SignatureMethod value
     * @return string|null
     */
    public function getSignatureMethod()
    {
        return $this->SignatureMethod;
    }
    /**
     * Set SignatureMethod value
     * @param string $signatureMethod
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setSignatureMethod($signatureMethod = null)
    {
        // validation for constraint: string
        if (!is_null($signatureMethod) && !is_string($signatureMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatureMethod, true), gettype($signatureMethod)), __LINE__);
        }
        $this->SignatureMethod = $signatureMethod;
        return $this;
    }
    /**
     * Get Signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param string $signature
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signature, true), gettype($signature)), __LINE__);
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Get ReferenceNo value
     * @return string|null
     */
    public function getReferenceNo()
    {
        return $this->ReferenceNo;
    }
    /**
     * Set ReferenceNo value
     * @param string $referenceNo
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setReferenceNo($referenceNo = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNo) && !is_string($referenceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNo, true), gettype($referenceNo)), __LINE__);
        }
        $this->ReferenceNo = $referenceNo;
        return $this;
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get HashValue value
     * @return string|null
     */
    public function getHashValue()
    {
        return $this->HashValue;
    }
    /**
     * Set HashValue value
     * @param string $hashValue
     * @return \StructType\AuthorizationInfoResponse
     */
    public function setHashValue($hashValue = null)
    {
        // validation for constraint: string
        if (!is_null($hashValue) && !is_string($hashValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashValue, true), gettype($hashValue)), __LINE__);
        }
        $this->HashValue = $hashValue;
        return $this;
    }
}
