<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TEMPERATURE StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element containing basic message data | Rootovský element obsahující základní údaje o zprávě
 * @subpackage Structs
 */
class TEMPERATURE extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Message identification | Identifikátor zprávy | Typ pro číslo zprávy | Message number type
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The message_code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $message_code;
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Date and time of message | Datum a čas zprávy
     * - use: required
     * @var string
     */
    public $date_time;
    /**
     * The dtd_version
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions. So far a constant '1' | Rezervováno pro příští verze, zatím konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_version;
    /**
     * The dtd_release
     * Meta information extracted from the WSDL
     * - documentation: Reserved for incoming versions. So far a constant '1' | Rezervováno pro příští verze. Zatím konstanta '1'
     * - fixed: 1
     * - use: required
     * @var string
     */
    public $dtd_release;
    /**
     * The answer_required
     * Meta information extracted from the WSDL
     * - documentation: Indication of request for response | Indikace požadavku na odpověď
     * - use: required
     * @var bool
     */
    public $answer_required;
    /**
     * The SenderIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message sender identification | Identifikace odesílatele zprávy
     * @var \StructType\SenderIdentificationType
     */
    public $SenderIdentification;
    /**
     * The ReceiverIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message receiver identification | Identifikace příjemce zprávy
     * @var \StructType\ReceiverIdentificationType
     */
    public $ReceiverIdentification;
    /**
     * The Profile
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Profile[]
     */
    public $Profile;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType
     */
    public $Signature;
    /**
     * Constructor method for TEMPERATURE
     * @uses TEMPERATURE::setId()
     * @uses TEMPERATURE::setMessage_code()
     * @uses TEMPERATURE::setDate_time()
     * @uses TEMPERATURE::setDtd_version()
     * @uses TEMPERATURE::setDtd_release()
     * @uses TEMPERATURE::setAnswer_required()
     * @uses TEMPERATURE::setSenderIdentification()
     * @uses TEMPERATURE::setReceiverIdentification()
     * @uses TEMPERATURE::setProfile()
     * @uses TEMPERATURE::setSignature()
     * @param string $id
     * @param string $message_code
     * @param string $date_time
     * @param string $dtd_version
     * @param string $dtd_release
     * @param bool $answer_required
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @param \StructType\Profile[] $profile
     * @param \StructType\SignatureType $signature
     */
    public function __construct($id = null, $message_code = null, $date_time = null, $dtd_version = null, $dtd_release = null, $answer_required = null, \StructType\SenderIdentificationType $senderIdentification = null, \StructType\ReceiverIdentificationType $receiverIdentification = null, array $profile = array(), \StructType\SignatureType $signature = null)
    {
        $this
            ->setId($id)
            ->setMessage_code($message_code)
            ->setDate_time($date_time)
            ->setDtd_version($dtd_version)
            ->setDtd_release($dtd_release)
            ->setAnswer_required($answer_required)
            ->setSenderIdentification($senderIdentification)
            ->setReceiverIdentification($receiverIdentification)
            ->setProfile($profile)
            ->setSignature($signature);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\TEMPERATURE
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($id) && mb_strlen($id) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get message_code value
     * @return string
     */
    public function getMessage_code()
    {
        return $this->{'message-code'};
    }
    /**
     * Set message_code value
     * @param string $message_code
     * @return \StructType\TEMPERATURE
     */
    public function setMessage_code($message_code = null)
    {
        // validation for constraint: string
        if (!is_null($message_code) && !is_string($message_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message_code, true), gettype($message_code)), __LINE__);
        }
        $this->message_code = $this->{'message-code'} = $message_code;
        return $this;
    }
    /**
     * Get date_time value
     * @return string
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\TEMPERATURE
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
    /**
     * Get dtd_version value
     * @return string
     */
    public function getDtd_version()
    {
        return $this->{'dtd-version'};
    }
    /**
     * Set dtd_version value
     * @param string $dtd_version
     * @return \StructType\TEMPERATURE
     */
    public function setDtd_version($dtd_version = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_version) && !is_string($dtd_version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_version, true), gettype($dtd_version)), __LINE__);
        }
        $this->dtd_version = $this->{'dtd-version'} = $dtd_version;
        return $this;
    }
    /**
     * Get dtd_release value
     * @return string
     */
    public function getDtd_release()
    {
        return $this->{'dtd-release'};
    }
    /**
     * Set dtd_release value
     * @param string $dtd_release
     * @return \StructType\TEMPERATURE
     */
    public function setDtd_release($dtd_release = null)
    {
        // validation for constraint: string
        if (!is_null($dtd_release) && !is_string($dtd_release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dtd_release, true), gettype($dtd_release)), __LINE__);
        }
        $this->dtd_release = $this->{'dtd-release'} = $dtd_release;
        return $this;
    }
    /**
     * Get answer_required value
     * @return bool
     */
    public function getAnswer_required()
    {
        return $this->{'answer-required'};
    }
    /**
     * Set answer_required value
     * @param bool $answer_required
     * @return \StructType\TEMPERATURE
     */
    public function setAnswer_required($answer_required = null)
    {
        // validation for constraint: boolean
        if (!is_null($answer_required) && !is_bool($answer_required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($answer_required, true), gettype($answer_required)), __LINE__);
        }
        $this->answer_required = $this->{'answer-required'} = $answer_required;
        return $this;
    }
    /**
     * Get SenderIdentification value
     * @return \StructType\SenderIdentificationType|null
     */
    public function getSenderIdentification()
    {
        return $this->SenderIdentification;
    }
    /**
     * Set SenderIdentification value
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @return \StructType\TEMPERATURE
     */
    public function setSenderIdentification(\StructType\SenderIdentificationType $senderIdentification = null)
    {
        $this->SenderIdentification = $senderIdentification;
        return $this;
    }
    /**
     * Get ReceiverIdentification value
     * @return \StructType\ReceiverIdentificationType|null
     */
    public function getReceiverIdentification()
    {
        return $this->ReceiverIdentification;
    }
    /**
     * Set ReceiverIdentification value
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @return \StructType\TEMPERATURE
     */
    public function setReceiverIdentification(\StructType\ReceiverIdentificationType $receiverIdentification = null)
    {
        $this->ReceiverIdentification = $receiverIdentification;
        return $this;
    }
    /**
     * Get Profile value
     * @return \StructType\Profile[]|null
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * This method is responsible for validating the values passed to the setProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileForArrayConstraintsFromSetProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tEMPERATUREProfileItem) {
            // validation for constraint: itemType
            if (!$tEMPERATUREProfileItem instanceof \StructType\Profile) {
                $invalidValues[] = is_object($tEMPERATUREProfileItem) ? get_class($tEMPERATUREProfileItem) : sprintf('%s(%s)', gettype($tEMPERATUREProfileItem), var_export($tEMPERATUREProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Profile property can only contain items of type \StructType\Profile, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Profile value
     * @throws \InvalidArgumentException
     * @param \StructType\Profile[] $profile
     * @return \StructType\TEMPERATURE
     */
    public function setProfile(array $profile = array())
    {
        // validation for constraint: array
        if ('' !== ($profileArrayErrorMessage = self::validateProfileForArrayConstraintsFromSetProfile($profile))) {
            throw new \InvalidArgumentException($profileArrayErrorMessage, __LINE__);
        }
        $this->Profile = $profile;
        return $this;
    }
    /**
     * Add item to Profile value
     * @throws \InvalidArgumentException
     * @param \StructType\Profile $item
     * @return \StructType\TEMPERATURE
     */
    public function addToProfile(\StructType\Profile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Profile) {
            throw new \InvalidArgumentException(sprintf('The Profile property can only contain items of type \StructType\Profile, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Profile[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \StructType\SignatureType $signature
     * @return \StructType\TEMPERATURE
     */
    public function setSignature(\StructType\SignatureType $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
}
