<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SumItemPrice StructType
 * Meta information extracted from the WSDL
 * - documentation: Pricing detail | Detail ocenění
 * @subpackage Structs
 */
class SumItemPrice extends AbstractStructBase
{
    /**
     * The NetValue
     * Meta information extracted from the WSDL
     * - documentation: Value without tax | Hodnota bez daně
     * @var \StructType\Price_Type
     */
    public $NetValue;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: Tax | Daň
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_Type[]
     */
    public $Tax;
    /**
     * The GrossValue
     * Meta information extracted from the WSDL
     * - documentation: Value with tax | Hodnota s daní
     * - minOccurs: 0
     * @var \StructType\Price_Type
     */
    public $GrossValue;
    /**
     * Constructor method for SumItemPrice
     * @uses SumItemPrice::setNetValue()
     * @uses SumItemPrice::setTax()
     * @uses SumItemPrice::setGrossValue()
     * @param \StructType\Price_Type $netValue
     * @param \StructType\Tax_Type[] $tax
     * @param \StructType\Price_Type $grossValue
     */
    public function __construct(\StructType\Price_Type $netValue = null, array $tax = array(), \StructType\Price_Type $grossValue = null)
    {
        $this
            ->setNetValue($netValue)
            ->setTax($tax)
            ->setGrossValue($grossValue);
    }
    /**
     * Get NetValue value
     * @return \StructType\Price_Type|null
     */
    public function getNetValue()
    {
        return $this->NetValue;
    }
    /**
     * Set NetValue value
     * @param \StructType\Price_Type $netValue
     * @return \StructType\SumItemPrice
     */
    public function setNetValue(\StructType\Price_Type $netValue = null)
    {
        $this->NetValue = $netValue;
        return $this;
    }
    /**
     * Get Tax value
     * @return \StructType\Tax_Type[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sumItemPriceTaxItem) {
            // validation for constraint: itemType
            if (!$sumItemPriceTaxItem instanceof \StructType\Tax_Type) {
                $invalidValues[] = is_object($sumItemPriceTaxItem) ? get_class($sumItemPriceTaxItem) : sprintf('%s(%s)', gettype($sumItemPriceTaxItem), var_export($sumItemPriceTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type \StructType\Tax_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Type[] $tax
     * @return \StructType\SumItemPrice
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Type $item
     * @return \StructType\SumItemPrice
     */
    public function addToTax(\StructType\Tax_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_Type) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type \StructType\Tax_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get GrossValue value
     * @return \StructType\Price_Type|null
     */
    public function getGrossValue()
    {
        return $this->GrossValue;
    }
    /**
     * Set GrossValue value
     * @param \StructType\Price_Type $grossValue
     * @return \StructType\SumItemPrice
     */
    public function setGrossValue(\StructType\Price_Type $grossValue = null)
    {
        $this->GrossValue = $grossValue;
        return $this;
    }
}
