<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Typ pro referenční zprávu
 * @subpackage Structs
 */
class ReferenceType extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The Transforms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Transforms
     * @var \StructType\TransformsType
     */
    public $Transforms;
    /**
     * The DigestMethod
     * Meta information extracted from the WSDL
     * - ref: ds:DigestMethod
     * @var \StructType\DigestMethodType
     */
    public $DigestMethod;
    /**
     * The DigestValue
     * Meta information extracted from the WSDL
     * - base: base64Binary
     * - ref: ds:DigestValue
     * @var string
     */
    public $DigestValue;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The URI
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $URI;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for ReferenceType
     * @uses ReferenceType::setId()
     * @uses ReferenceType::setTransforms()
     * @uses ReferenceType::setDigestMethod()
     * @uses ReferenceType::setDigestValue()
     * @uses ReferenceType::setId_1()
     * @uses ReferenceType::setURI()
     * @uses ReferenceType::setType()
     * @param string $id
     * @param \StructType\TransformsType $transforms
     * @param \StructType\DigestMethodType $digestMethod
     * @param string $digestValue
     * @param string $id
     * @param string $uRI
     * @param string $type
     */
    public function __construct($id = null, \StructType\TransformsType $transforms = null, \StructType\DigestMethodType $digestMethod = null, $digestValue = null, $id_1 = null, $uRI = null, $type = null)
    {
        $this
            ->setId($id)
            ->setTransforms($transforms)
            ->setDigestMethod($digestMethod)
            ->setDigestValue($digestValue)
            ->setId_1($id_1)
            ->setURI($uRI)
            ->setType($type);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ReferenceType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($id) && mb_strlen($id) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get Transforms value
     * @return \StructType\TransformsType|null
     */
    public function getTransforms()
    {
        return $this->Transforms;
    }
    /**
     * Set Transforms value
     * @param \StructType\TransformsType $transforms
     * @return \StructType\ReferenceType
     */
    public function setTransforms(\StructType\TransformsType $transforms = null)
    {
        $this->Transforms = $transforms;
        return $this;
    }
    /**
     * Get DigestMethod value
     * @return \StructType\DigestMethodType|null
     */
    public function getDigestMethod()
    {
        return $this->DigestMethod;
    }
    /**
     * Set DigestMethod value
     * @param \StructType\DigestMethodType $digestMethod
     * @return \StructType\ReferenceType
     */
    public function setDigestMethod(\StructType\DigestMethodType $digestMethod = null)
    {
        $this->DigestMethod = $digestMethod;
        return $this;
    }
    /**
     * Get DigestValue value
     * @return string|null
     */
    public function getDigestValue()
    {
        return $this->DigestValue;
    }
    /**
     * Set DigestValue value
     * @param string $digestValue
     * @return \StructType\ReferenceType
     */
    public function setDigestValue($digestValue = null)
    {
        // validation for constraint: string
        if (!is_null($digestValue) && !is_string($digestValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestValue, true), gettype($digestValue)), __LINE__);
        }
        $this->DigestValue = $digestValue;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId_1()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ReferenceType
     */
    public function setId_1($id_1 = null)
    {
        // validation for constraint: string
        if (!is_null($id_1) && !is_string($id_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id_1, true), gettype($id_1)), __LINE__);
        }
        $this->Id = $id_1;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\ReferenceType
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ReferenceType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
