<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Price StructType
 * Meta information extracted from the WSDL
 * - documentation: Billing | Zúčtování
 * @subpackage Structs
 */
class Price extends AbstractStructBase
{
    /**
     * The total
     * Meta information extracted from the WSDL
     * - documentation: Total before VAT | Částka faktury bez DPH | Jednotková cena - desetinné číslo na max 2 des. místa
     * - base: xsd:string
     * - maxLength: 31
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: required
     * @var string
     */
    public $total;
    /**
     * The inv_per_from
     * Meta information extracted from the WSDL
     * - documentation: Beginning of period | Počátek období
     * - use: required
     * @var string
     */
    public $inv_per_from;
    /**
     * The inv_per_to
     * Meta information extracted from the WSDL
     * - documentation: End of period | Konec období
     * - use: required
     * @var string
     */
    public $inv_per_to;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - documentation: Billing item | Položka zúčtování
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_type[]
     */
    public $Item;
    /**
     * Constructor method for Price
     * @uses Price::setTotal()
     * @uses Price::setInv_per_from()
     * @uses Price::setInv_per_to()
     * @uses Price::setItem()
     * @param string $total
     * @param string $inv_per_from
     * @param string $inv_per_to
     * @param \StructType\Item_type[] $item
     */
    public function __construct($total = null, $inv_per_from = null, $inv_per_to = null, array $item = array())
    {
        $this
            ->setTotal($total)
            ->setInv_per_from($inv_per_from)
            ->setInv_per_to($inv_per_to)
            ->setItem($item);
    }
    /**
     * Get total value
     * @return string
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param string $total
     * @return \StructType\Price
     */
    public function setTotal($total = null)
    {
        // validation for constraint: string
        if (!is_null($total) && !is_string($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        // validation for constraint: maxLength(31)
        if (!is_null($total) && mb_strlen($total) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 31', mb_strlen($total)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($total) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($total, true)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get inv_per_from value
     * @return string
     */
    public function getInv_per_from()
    {
        return $this->{'inv-per-from'};
    }
    /**
     * Set inv_per_from value
     * @param string $inv_per_from
     * @return \StructType\Price
     */
    public function setInv_per_from($inv_per_from = null)
    {
        // validation for constraint: string
        if (!is_null($inv_per_from) && !is_string($inv_per_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_per_from, true), gettype($inv_per_from)), __LINE__);
        }
        $this->inv_per_from = $this->{'inv-per-from'} = $inv_per_from;
        return $this;
    }
    /**
     * Get inv_per_to value
     * @return string
     */
    public function getInv_per_to()
    {
        return $this->{'inv-per-to'};
    }
    /**
     * Set inv_per_to value
     * @param string $inv_per_to
     * @return \StructType\Price
     */
    public function setInv_per_to($inv_per_to = null)
    {
        // validation for constraint: string
        if (!is_null($inv_per_to) && !is_string($inv_per_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_per_to, true), gettype($inv_per_to)), __LINE__);
        }
        $this->inv_per_to = $this->{'inv-per-to'} = $inv_per_to;
        return $this;
    }
    /**
     * Get Item value
     * @return \StructType\Item_type[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceItemItem) {
            // validation for constraint: itemType
            if (!$priceItemItem instanceof \StructType\Item_type) {
                $invalidValues[] = is_object($priceItemItem) ? get_class($priceItemItem) : sprintf('%s(%s)', gettype($priceItemItem), var_export($priceItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item property can only contain items of type \StructType\Item_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_type[] $item
     * @return \StructType\Price
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_type $item
     * @return \StructType\Price
     */
    public function addToItem(\StructType\Item_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_type) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of type \StructType\Item_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
}
