<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Payment identification info | Identifikace platby
 * @subpackage Structs
 */
class PaymentInfo extends AbstractStructBase
{
    /**
     * The var_symbol
     * @var string
     */
    public $var_symbol;
    /**
     * The const_symbol
     * @var string
     */
    public $const_symbol;
    /**
     * The spec_symbol
     * @var string
     */
    public $spec_symbol;
    /**
     * The payment_method
     * @var string
     */
    public $payment_method;
    /**
     * Constructor method for PaymentInfo
     * @uses PaymentInfo::setVar_symbol()
     * @uses PaymentInfo::setConst_symbol()
     * @uses PaymentInfo::setSpec_symbol()
     * @uses PaymentInfo::setPayment_method()
     * @param string $var_symbol
     * @param string $const_symbol
     * @param string $spec_symbol
     * @param string $payment_method
     */
    public function __construct($var_symbol = null, $const_symbol = null, $spec_symbol = null, $payment_method = null)
    {
        $this
            ->setVar_symbol($var_symbol)
            ->setConst_symbol($const_symbol)
            ->setSpec_symbol($spec_symbol)
            ->setPayment_method($payment_method);
    }
    /**
     * Get var_symbol value
     * @return string|null
     */
    public function getVar_symbol()
    {
        return $this->{'var-symbol'};
    }
    /**
     * Set var_symbol value
     * @param string $var_symbol
     * @return \StructType\PaymentInfo
     */
    public function setVar_symbol($var_symbol = null)
    {
        // validation for constraint: string
        if (!is_null($var_symbol) && !is_string($var_symbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($var_symbol, true), gettype($var_symbol)), __LINE__);
        }
        $this->var_symbol = $this->{'var-symbol'} = $var_symbol;
        return $this;
    }
    /**
     * Get const_symbol value
     * @return string|null
     */
    public function getConst_symbol()
    {
        return $this->{'const-symbol'};
    }
    /**
     * Set const_symbol value
     * @param string $const_symbol
     * @return \StructType\PaymentInfo
     */
    public function setConst_symbol($const_symbol = null)
    {
        // validation for constraint: string
        if (!is_null($const_symbol) && !is_string($const_symbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($const_symbol, true), gettype($const_symbol)), __LINE__);
        }
        $this->const_symbol = $this->{'const-symbol'} = $const_symbol;
        return $this;
    }
    /**
     * Get spec_symbol value
     * @return string|null
     */
    public function getSpec_symbol()
    {
        return $this->{'spec-symbol'};
    }
    /**
     * Set spec_symbol value
     * @param string $spec_symbol
     * @return \StructType\PaymentInfo
     */
    public function setSpec_symbol($spec_symbol = null)
    {
        // validation for constraint: string
        if (!is_null($spec_symbol) && !is_string($spec_symbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spec_symbol, true), gettype($spec_symbol)), __LINE__);
        }
        $this->spec_symbol = $this->{'spec-symbol'} = $spec_symbol;
        return $this;
    }
    /**
     * Get payment_method value
     * @return string|null
     */
    public function getPayment_method()
    {
        return $this->{'payment-method'};
    }
    /**
     * Set payment_method value
     * @param string $payment_method
     * @return \StructType\PaymentInfo
     */
    public function setPayment_method($payment_method = null)
    {
        // validation for constraint: string
        if (!is_null($payment_method) && !is_string($payment_method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_method, true), gettype($payment_method)), __LINE__);
        }
        $this->payment_method = $this->{'payment-method'} = $payment_method;
        return $this;
    }
}
