<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PGPDataType StructType
 * @subpackage Structs
 */
class PGPDataType extends AbstractStructBase
{
    /**
     * The PGPKeyID
     * Meta information extracted from the WSDL
     * - choice: PGPKeyID | PGPKeyPacket | PGPKeyPacket |  |
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $PGPKeyID;
    /**
     * The PGPKeyPacket
     * Meta information extracted from the WSDL
     * - choice: PGPKeyID | PGPKeyPacket | PGPKeyPacket |  |  | PGPKeyID | PGPKeyPacket | PGPKeyPacket |  |
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PGPKeyPacket;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for PGPDataType
     * @uses PGPDataType::setPGPKeyID()
     * @uses PGPDataType::setPGPKeyPacket()
     * @uses PGPDataType::setAny()
     * @param string $pGPKeyID
     * @param string $pGPKeyPacket
     * @param \DOMDocument $any
     */
    public function __construct($pGPKeyID = null, $pGPKeyPacket = null, \DOMDocument $any = null)
    {
        $this
            ->setPGPKeyID($pGPKeyID)
            ->setPGPKeyPacket($pGPKeyPacket)
            ->setAny($any);
    }
    /**
     * Get PGPKeyID value
     * @return string|null
     */
    public function getPGPKeyID()
    {
        return isset($this->PGPKeyID) ? $this->PGPKeyID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPGPKeyID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPGPKeyID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePGPKeyIDForChoiceConstraintsFromSetPGPKeyID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PGPKeyPacket',
            'PGPKeyPacket',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PGPKeyID can\'t be set as the property %s is already set. Only one property must be set among these properties: PGPKeyID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PGPKeyID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pGPKeyID
     * @return \StructType\PGPDataType
     */
    public function setPGPKeyID($pGPKeyID = null)
    {
        // validation for constraint: string
        if (!is_null($pGPKeyID) && !is_string($pGPKeyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pGPKeyID, true), gettype($pGPKeyID)), __LINE__);
        }
        // validation for constraint: choice(PGPKeyID, PGPKeyPacket, PGPKeyPacket, , )
        if ('' !== ($pGPKeyIDChoiceErrorMessage = self::validatePGPKeyIDForChoiceConstraintsFromSetPGPKeyID($pGPKeyID))) {
            throw new \InvalidArgumentException($pGPKeyIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($pGPKeyID) || (is_array($pGPKeyID) && empty($pGPKeyID))) {
            unset($this->PGPKeyID);
        } else {
            $this->PGPKeyID = $pGPKeyID;
        }
        return $this;
    }
    /**
     * Get PGPKeyPacket value
     * @return string|null
     */
    public function getPGPKeyPacket()
    {
        return isset($this->PGPKeyPacket) ? $this->PGPKeyPacket : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPGPKeyPacket method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPGPKeyPacket method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePGPKeyPacketForChoiceConstraintsFromSetPGPKeyPacket($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PGPKeyID',
            'PGPKeyID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PGPKeyPacket can\'t be set as the property %s is already set. Only one property must be set among these properties: PGPKeyPacket, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PGPKeyPacket value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $pGPKeyPacket
     * @return \StructType\PGPDataType
     */
    public function setPGPKeyPacket($pGPKeyPacket = null)
    {
        // validation for constraint: string
        if (!is_null($pGPKeyPacket) && !is_string($pGPKeyPacket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pGPKeyPacket, true), gettype($pGPKeyPacket)), __LINE__);
        }
        // validation for constraint: choice(PGPKeyID, PGPKeyPacket, PGPKeyPacket, , , PGPKeyID, PGPKeyPacket, PGPKeyPacket, , )
        if ('' !== ($pGPKeyPacketChoiceErrorMessage = self::validatePGPKeyPacketForChoiceConstraintsFromSetPGPKeyPacket($pGPKeyPacket))) {
            throw new \InvalidArgumentException($pGPKeyPacketChoiceErrorMessage, __LINE__);
        }
        if (is_null($pGPKeyPacket) || (is_array($pGPKeyPacket) && empty($pGPKeyPacket))) {
            unset($this->PGPKeyPacket);
        } else {
            $this->PGPKeyPacket = $pGPKeyPacket;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\PGPDataType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
