<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NameAddress StructType
 * Meta information extracted from the WSDL
 * - documentation: Name and address | Jméno a adresa
 * @subpackage Structs
 */
class NameAddress extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Party name | Jméno partnera
     * - use: required
     * @var string
     */
    public $name;
    /**
     * The country
     * @var string
     */
    public $country;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The city_subentity
     * @var string
     */
    public $city_subentity;
    /**
     * The street
     * @var string
     */
    public $street;
    /**
     * The house_num
     * @var string
     */
    public $house_num;
    /**
     * The house_num2
     * @var string
     */
    public $house_num2;
    /**
     * The postal_code
     * @var string
     */
    public $postal_code;
    /**
     * The po_box
     * @var string
     */
    public $po_box;
    /**
     * Constructor method for NameAddress
     * @uses NameAddress::setName()
     * @uses NameAddress::setCountry()
     * @uses NameAddress::setCity()
     * @uses NameAddress::setCity_subentity()
     * @uses NameAddress::setStreet()
     * @uses NameAddress::setHouse_num()
     * @uses NameAddress::setHouse_num2()
     * @uses NameAddress::setPostal_code()
     * @uses NameAddress::setPo_box()
     * @param string $name
     * @param string $country
     * @param string $city
     * @param string $city_subentity
     * @param string $street
     * @param string $house_num
     * @param string $house_num2
     * @param string $postal_code
     * @param string $po_box
     */
    public function __construct($name = null, $country = null, $city = null, $city_subentity = null, $street = null, $house_num = null, $house_num2 = null, $postal_code = null, $po_box = null)
    {
        $this
            ->setName($name)
            ->setCountry($country)
            ->setCity($city)
            ->setCity_subentity($city_subentity)
            ->setStreet($street)
            ->setHouse_num($house_num)
            ->setHouse_num2($house_num2)
            ->setPostal_code($postal_code)
            ->setPo_box($po_box);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\NameAddress
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\NameAddress
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\NameAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get city_subentity value
     * @return string|null
     */
    public function getCity_subentity()
    {
        return $this->{'city-subentity'};
    }
    /**
     * Set city_subentity value
     * @param string $city_subentity
     * @return \StructType\NameAddress
     */
    public function setCity_subentity($city_subentity = null)
    {
        // validation for constraint: string
        if (!is_null($city_subentity) && !is_string($city_subentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city_subentity, true), gettype($city_subentity)), __LINE__);
        }
        $this->city_subentity = $this->{'city-subentity'} = $city_subentity;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\NameAddress
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get house_num value
     * @return string|null
     */
    public function getHouse_num()
    {
        return $this->{'house-num'};
    }
    /**
     * Set house_num value
     * @param string $house_num
     * @return \StructType\NameAddress
     */
    public function setHouse_num($house_num = null)
    {
        // validation for constraint: string
        if (!is_null($house_num) && !is_string($house_num)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($house_num, true), gettype($house_num)), __LINE__);
        }
        $this->house_num = $this->{'house-num'} = $house_num;
        return $this;
    }
    /**
     * Get house_num2 value
     * @return string|null
     */
    public function getHouse_num2()
    {
        return $this->{'house-num2'};
    }
    /**
     * Set house_num2 value
     * @param string $house_num2
     * @return \StructType\NameAddress
     */
    public function setHouse_num2($house_num2 = null)
    {
        // validation for constraint: string
        if (!is_null($house_num2) && !is_string($house_num2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($house_num2, true), gettype($house_num2)), __LINE__);
        }
        $this->house_num2 = $this->{'house-num2'} = $house_num2;
        return $this;
    }
    /**
     * Get postal_code value
     * @return string|null
     */
    public function getPostal_code()
    {
        return $this->{'postal-code'};
    }
    /**
     * Set postal_code value
     * @param string $postal_code
     * @return \StructType\NameAddress
     */
    public function setPostal_code($postal_code = null)
    {
        // validation for constraint: string
        if (!is_null($postal_code) && !is_string($postal_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postal_code, true), gettype($postal_code)), __LINE__);
        }
        $this->postal_code = $this->{'postal-code'} = $postal_code;
        return $this;
    }
    /**
     * Get po_box value
     * @return string|null
     */
    public function getPo_box()
    {
        return $this->{'po-box'};
    }
    /**
     * Set po_box value
     * @param string $po_box
     * @return \StructType\NameAddress
     */
    public function setPo_box($po_box = null)
    {
        // validation for constraint: string
        if (!is_null($po_box) && !is_string($po_box)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($po_box, true), gettype($po_box)), __LINE__);
        }
        $this->po_box = $this->{'po-box'} = $po_box;
        return $this;
    }
}
