<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MP StructType
 * Meta information extracted from the WSDL
 * - documentation: Segment Connection point within DGI ICS | Blok místo připojení v rámci DUF VO
 * @subpackage Structs
 */
class MP extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Number of metering point | Číslo měřicího místa
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The Pmax
     * Meta information extracted from the WSDL
     * - documentation: Pmax
     * @var \StructType\Pmax_type
     */
    public $Pmax;
    /**
     * The Ereact
     * Meta information extracted from the WSDL
     * - documentation: Reactive energy | Nevyžádaná dodávka jalové energie
     * - minOccurs: 0
     * @var \StructType\Ereact_type
     */
    public $Ereact;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 12
     * - use: optional
     * @var string
     */
    public $name;
    /**
     * The qty
     * Meta information extracted from the WSDL
     * - documentation: Consumption (-) / generation (+) | Odběr (-) / dodávka(+) | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $qty;
    /**
     * The tg_fi
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 5
     * - use: optional
     * @var float
     */
    public $tg_fi;
    /**
     * Constructor method for MP
     * @uses MP::setId()
     * @uses MP::setPmax()
     * @uses MP::setEreact()
     * @uses MP::setName()
     * @uses MP::setQty()
     * @uses MP::setTg_fi()
     * @param string $id
     * @param \StructType\Pmax_type $pmax
     * @param \StructType\Ereact_type $ereact
     * @param string $name
     * @param string $qty
     * @param float $tg_fi
     */
    public function __construct($id = null, \StructType\Pmax_type $pmax = null, \StructType\Ereact_type $ereact = null, $name = null, $qty = null, $tg_fi = null)
    {
        $this
            ->setId($id)
            ->setPmax($pmax)
            ->setEreact($ereact)
            ->setName($name)
            ->setQty($qty)
            ->setTg_fi($tg_fi);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\MP
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get Pmax value
     * @return \StructType\Pmax_type|null
     */
    public function getPmax()
    {
        return $this->Pmax;
    }
    /**
     * Set Pmax value
     * @param \StructType\Pmax_type $pmax
     * @return \StructType\MP
     */
    public function setPmax(\StructType\Pmax_type $pmax = null)
    {
        $this->Pmax = $pmax;
        return $this;
    }
    /**
     * Get Ereact value
     * @return \StructType\Ereact_type|null
     */
    public function getEreact()
    {
        return $this->Ereact;
    }
    /**
     * Set Ereact value
     * @param \StructType\Ereact_type $ereact
     * @return \StructType\MP
     */
    public function setEreact(\StructType\Ereact_type $ereact = null)
    {
        $this->Ereact = $ereact;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\MP
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($name) && mb_strlen($name) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get qty value
     * @return string|null
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param string $qty
     * @return \StructType\MP
     */
    public function setQty($qty = null)
    {
        // validation for constraint: string
        if (!is_null($qty) && !is_string($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qty) && mb_strlen($qty) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qty)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($qty) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($qty, true)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
    /**
     * Get tg_fi value
     * @return float|null
     */
    public function getTg_fi()
    {
        return $this->{'tg-fi'};
    }
    /**
     * Set tg_fi value
     * @param float $tg_fi
     * @return \StructType\MP
     */
    public function setTg_fi($tg_fi = null)
    {
        // validation for constraint: float
        if (!is_null($tg_fi) && !(is_float($tg_fi) || is_numeric($tg_fi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tg_fi, true), gettype($tg_fi)), __LINE__);
        }
        // validation for constraint: fractionDigits(5)
        if (!is_null($tg_fi) && mb_strlen(mb_substr($tg_fi, false !== mb_strpos($tg_fi, '.') ? mb_strpos($tg_fi, '.') + 1 : mb_strlen($tg_fi))) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 5 fraction digits, %d given', var_export($tg_fi, true), mb_strlen(mb_substr($tg_fi, mb_strpos($tg_fi, '.') + 1))), __LINE__);
        }
        $this->tg_fi = $this->{'tg-fi'} = $tg_fi;
        return $this;
    }
}
