<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOfPDTBlocks StructType
 * Meta information extracted from the WSDL
 * - documentation: List of PDT blocks | Seznam bloků OPM
 * @subpackage Structs
 */
class ListOfPDTBlocks extends AbstractStructBase
{
    /**
     * The PDTblock
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PDTblock[]
     */
    public $PDTblock;
    /**
     * Constructor method for ListOfPDTBlocks
     * @uses ListOfPDTBlocks::setPDTblock()
     * @param \StructType\PDTblock[] $pDTblock
     */
    public function __construct(array $pDTblock = array())
    {
        $this
            ->setPDTblock($pDTblock);
    }
    /**
     * Get PDTblock value
     * @return \StructType\PDTblock[]|null
     */
    public function getPDTblock()
    {
        return $this->PDTblock;
    }
    /**
     * This method is responsible for validating the values passed to the setPDTblock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPDTblock method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePDTblockForArrayConstraintsFromSetPDTblock(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listOfPDTBlocksPDTblockItem) {
            // validation for constraint: itemType
            if (!$listOfPDTBlocksPDTblockItem instanceof \StructType\PDTblock) {
                $invalidValues[] = is_object($listOfPDTBlocksPDTblockItem) ? get_class($listOfPDTBlocksPDTblockItem) : sprintf('%s(%s)', gettype($listOfPDTBlocksPDTblockItem), var_export($listOfPDTBlocksPDTblockItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PDTblock property can only contain items of type \StructType\PDTblock, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PDTblock value
     * @throws \InvalidArgumentException
     * @param \StructType\PDTblock[] $pDTblock
     * @return \StructType\ListOfPDTBlocks
     */
    public function setPDTblock(array $pDTblock = array())
    {
        // validation for constraint: array
        if ('' !== ($pDTblockArrayErrorMessage = self::validatePDTblockForArrayConstraintsFromSetPDTblock($pDTblock))) {
            throw new \InvalidArgumentException($pDTblockArrayErrorMessage, __LINE__);
        }
        $this->PDTblock = $pDTblock;
        return $this;
    }
    /**
     * Add item to PDTblock value
     * @throws \InvalidArgumentException
     * @param \StructType\PDTblock $item
     * @return \StructType\ListOfPDTBlocks
     */
    public function addToPDTblock(\StructType\PDTblock $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PDTblock) {
            throw new \InvalidArgumentException(sprintf('The PDTblock property can only contain items of type \StructType\PDTblock, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PDTblock[] = $item;
        return $this;
    }
}
