<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListOfBillingItems StructType
 * Meta information extracted from the WSDL
 * - documentation: List of PDT billing items | Seznam položek zúčtování OPM
 * @subpackage Structs
 */
class ListOfBillingItems extends AbstractStructBase
{
    /**
     * The items_category
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $items_category;
    /**
     * The BillingItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\BillingItem[]
     */
    public $BillingItem;
    /**
     * The ListOfBillingItemsSubTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ListOfBillingItemsSubTotal
     */
    public $ListOfBillingItemsSubTotal;
    /**
     * Constructor method for ListOfBillingItems
     * @uses ListOfBillingItems::setItems_category()
     * @uses ListOfBillingItems::setBillingItem()
     * @uses ListOfBillingItems::setListOfBillingItemsSubTotal()
     * @param string $items_category
     * @param \StructType\BillingItem[] $billingItem
     * @param \StructType\ListOfBillingItemsSubTotal $listOfBillingItemsSubTotal
     */
    public function __construct($items_category = null, array $billingItem = array(), \StructType\ListOfBillingItemsSubTotal $listOfBillingItemsSubTotal = null)
    {
        $this
            ->setItems_category($items_category)
            ->setBillingItem($billingItem)
            ->setListOfBillingItemsSubTotal($listOfBillingItemsSubTotal);
    }
    /**
     * Get items_category value
     * @return string
     */
    public function getItems_category()
    {
        return $this->{'items-category'};
    }
    /**
     * Set items_category value
     * @param string $items_category
     * @return \StructType\ListOfBillingItems
     */
    public function setItems_category($items_category = null)
    {
        // validation for constraint: string
        if (!is_null($items_category) && !is_string($items_category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($items_category, true), gettype($items_category)), __LINE__);
        }
        $this->items_category = $this->{'items-category'} = $items_category;
        return $this;
    }
    /**
     * Get BillingItem value
     * @return \StructType\BillingItem[]|null
     */
    public function getBillingItem()
    {
        return $this->BillingItem;
    }
    /**
     * This method is responsible for validating the values passed to the setBillingItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBillingItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBillingItemForArrayConstraintsFromSetBillingItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listOfBillingItemsBillingItemItem) {
            // validation for constraint: itemType
            if (!$listOfBillingItemsBillingItemItem instanceof \StructType\BillingItem) {
                $invalidValues[] = is_object($listOfBillingItemsBillingItemItem) ? get_class($listOfBillingItemsBillingItemItem) : sprintf('%s(%s)', gettype($listOfBillingItemsBillingItemItem), var_export($listOfBillingItemsBillingItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BillingItem property can only contain items of type \StructType\BillingItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BillingItem value
     * @throws \InvalidArgumentException
     * @param \StructType\BillingItem[] $billingItem
     * @return \StructType\ListOfBillingItems
     */
    public function setBillingItem(array $billingItem = array())
    {
        // validation for constraint: array
        if ('' !== ($billingItemArrayErrorMessage = self::validateBillingItemForArrayConstraintsFromSetBillingItem($billingItem))) {
            throw new \InvalidArgumentException($billingItemArrayErrorMessage, __LINE__);
        }
        $this->BillingItem = $billingItem;
        return $this;
    }
    /**
     * Add item to BillingItem value
     * @throws \InvalidArgumentException
     * @param \StructType\BillingItem $item
     * @return \StructType\ListOfBillingItems
     */
    public function addToBillingItem(\StructType\BillingItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BillingItem) {
            throw new \InvalidArgumentException(sprintf('The BillingItem property can only contain items of type \StructType\BillingItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BillingItem[] = $item;
        return $this;
    }
    /**
     * Get ListOfBillingItemsSubTotal value
     * @return \StructType\ListOfBillingItemsSubTotal|null
     */
    public function getListOfBillingItemsSubTotal()
    {
        return $this->ListOfBillingItemsSubTotal;
    }
    /**
     * Set ListOfBillingItemsSubTotal value
     * @param \StructType\ListOfBillingItemsSubTotal $listOfBillingItemsSubTotal
     * @return \StructType\ListOfBillingItems
     */
    public function setListOfBillingItemsSubTotal(\StructType\ListOfBillingItemsSubTotal $listOfBillingItemsSubTotal = null)
    {
        $this->ListOfBillingItemsSubTotal = $listOfBillingItemsSubTotal;
        return $this;
    }
}
