<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document StructType
 * Meta information extracted from the WSDL
 * - documentation: Document | Doklad | Information about requested documentation.If the tag is not present, single-shot answer is expected. If it's present, attribute periodic determine the periodic or non-periodic data sending. | Informace o
 * požadovaném dokumentu.Pokud není tento tag přítomen, očekává se jednorázová odpověď. Pokud je přítomen, atribut periodic určuje, jestli se nastavuje nebo ruší periodické zasílání dat.
 * @subpackage Structs
 */
class Document extends AbstractStructBase
{
    /**
     * The doc_type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $doc_type;
    /**
     * The tax_relevancy
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $tax_relevancy;
    /**
     * The doc_level
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $doc_level;
    /**
     * The doc_id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 12
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $doc_id;
    /**
     * The periodic
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $periodic;
    /**
     * The DocHeader
     * @var \StructType\DocHeader
     */
    public $DocHeader;
    /**
     * The DocDetail
     * @var \StructType\DocDetail
     */
    public $DocDetail;
    /**
     * The DocSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocSummary
     */
    public $DocSummary;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Attachment
     */
    public $Attachment;
    /**
     * The doc_atn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \d{1,10}
     * @var string
     */
    public $doc_atn;
    /**
     * The doc_ver
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * @var string
     */
    public $doc_ver;
    /**
     * Constructor method for Document
     * @uses Document::setDoc_type()
     * @uses Document::setTax_relevancy()
     * @uses Document::setDoc_level()
     * @uses Document::setDoc_id()
     * @uses Document::setPeriodic()
     * @uses Document::setDocHeader()
     * @uses Document::setDocDetail()
     * @uses Document::setDocSummary()
     * @uses Document::setAttachment()
     * @uses Document::setDoc_atn()
     * @uses Document::setDoc_ver()
     * @param string $doc_type
     * @param string $tax_relevancy
     * @param string $doc_level
     * @param string $doc_id
     * @param string $periodic
     * @param \StructType\DocHeader $docHeader
     * @param \StructType\DocDetail $docDetail
     * @param \StructType\DocSummary $docSummary
     * @param \StructType\Attachment $attachment
     * @param string $doc_atn
     * @param string $doc_ver
     */
    public function __construct($doc_type = null, $tax_relevancy = null, $doc_level = null, $doc_id = null, $periodic = null, \StructType\DocHeader $docHeader = null, \StructType\DocDetail $docDetail = null, \StructType\DocSummary $docSummary = null, \StructType\Attachment $attachment = null, $doc_atn = null, $doc_ver = null)
    {
        $this
            ->setDoc_type($doc_type)
            ->setTax_relevancy($tax_relevancy)
            ->setDoc_level($doc_level)
            ->setDoc_id($doc_id)
            ->setPeriodic($periodic)
            ->setDocHeader($docHeader)
            ->setDocDetail($docDetail)
            ->setDocSummary($docSummary)
            ->setAttachment($attachment)
            ->setDoc_atn($doc_atn)
            ->setDoc_ver($doc_ver);
    }
    /**
     * Get doc_type value
     * @return string
     */
    public function getDoc_type()
    {
        return $this->{'doc-type'};
    }
    /**
     * Set doc_type value
     * @param string $doc_type
     * @return \StructType\Document
     */
    public function setDoc_type($doc_type = null)
    {
        // validation for constraint: string
        if (!is_null($doc_type) && !is_string($doc_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_type, true), gettype($doc_type)), __LINE__);
        }
        $this->doc_type = $this->{'doc-type'} = $doc_type;
        return $this;
    }
    /**
     * Get tax_relevancy value
     * @return string
     */
    public function getTax_relevancy()
    {
        return $this->{'tax-relevancy'};
    }
    /**
     * Set tax_relevancy value
     * @param string $tax_relevancy
     * @return \StructType\Document
     */
    public function setTax_relevancy($tax_relevancy = null)
    {
        // validation for constraint: string
        if (!is_null($tax_relevancy) && !is_string($tax_relevancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax_relevancy, true), gettype($tax_relevancy)), __LINE__);
        }
        $this->tax_relevancy = $this->{'tax-relevancy'} = $tax_relevancy;
        return $this;
    }
    /**
     * Get doc_level value
     * @return string
     */
    public function getDoc_level()
    {
        return $this->{'doc-level'};
    }
    /**
     * Set doc_level value
     * @param string $doc_level
     * @return \StructType\Document
     */
    public function setDoc_level($doc_level = null)
    {
        // validation for constraint: string
        if (!is_null($doc_level) && !is_string($doc_level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_level, true), gettype($doc_level)), __LINE__);
        }
        $this->doc_level = $this->{'doc-level'} = $doc_level;
        return $this;
    }
    /**
     * Get doc_id value
     * @return string
     */
    public function getDoc_id()
    {
        return $this->{'doc-id'};
    }
    /**
     * Set doc_id value
     * @param string $doc_id
     * @return \StructType\Document
     */
    public function setDoc_id($doc_id = null)
    {
        // validation for constraint: string
        if (!is_null($doc_id) && !is_string($doc_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_id, true), gettype($doc_id)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($doc_id) && mb_strlen($doc_id) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($doc_id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($doc_id) && mb_strlen($doc_id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($doc_id)), __LINE__);
        }
        $this->doc_id = $this->{'doc-id'} = $doc_id;
        return $this;
    }
    /**
     * Get periodic value
     * @return string|null
     */
    public function getPeriodic()
    {
        return $this->periodic;
    }
    /**
     * Set periodic value
     * @param string $periodic
     * @return \StructType\Document
     */
    public function setPeriodic($periodic = null)
    {
        // validation for constraint: string
        if (!is_null($periodic) && !is_string($periodic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodic, true), gettype($periodic)), __LINE__);
        }
        $this->periodic = $periodic;
        return $this;
    }
    /**
     * Get DocHeader value
     * @return \StructType\DocHeader|null
     */
    public function getDocHeader()
    {
        return $this->DocHeader;
    }
    /**
     * Set DocHeader value
     * @param \StructType\DocHeader $docHeader
     * @return \StructType\Document
     */
    public function setDocHeader(\StructType\DocHeader $docHeader = null)
    {
        $this->DocHeader = $docHeader;
        return $this;
    }
    /**
     * Get DocDetail value
     * @return \StructType\DocDetail|null
     */
    public function getDocDetail()
    {
        return $this->DocDetail;
    }
    /**
     * Set DocDetail value
     * @param \StructType\DocDetail $docDetail
     * @return \StructType\Document
     */
    public function setDocDetail(\StructType\DocDetail $docDetail = null)
    {
        $this->DocDetail = $docDetail;
        return $this;
    }
    /**
     * Get DocSummary value
     * @return \StructType\DocSummary|null
     */
    public function getDocSummary()
    {
        return $this->DocSummary;
    }
    /**
     * Set DocSummary value
     * @param \StructType\DocSummary $docSummary
     * @return \StructType\Document
     */
    public function setDocSummary(\StructType\DocSummary $docSummary = null)
    {
        $this->DocSummary = $docSummary;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \StructType\Attachment|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @param \StructType\Attachment $attachment
     * @return \StructType\Document
     */
    public function setAttachment(\StructType\Attachment $attachment = null)
    {
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Get doc_atn value
     * @return string|null
     */
    public function getDoc_atn()
    {
        return $this->{'doc-atn'};
    }
    /**
     * Set doc_atn value
     * @param string $doc_atn
     * @return \StructType\Document
     */
    public function setDoc_atn($doc_atn = null)
    {
        // validation for constraint: string
        if (!is_null($doc_atn) && !is_string($doc_atn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_atn, true), gettype($doc_atn)), __LINE__);
        }
        // validation for constraint: pattern(\d{1,10})
        if (!is_null($doc_atn) && !preg_match('/\\d{1,10}/', $doc_atn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{1,10}', var_export($doc_atn, true)), __LINE__);
        }
        $this->doc_atn = $this->{'doc-atn'} = $doc_atn;
        return $this;
    }
    /**
     * Get doc_ver value
     * @return string|null
     */
    public function getDoc_ver()
    {
        return $this->{'doc-ver'};
    }
    /**
     * Set doc_ver value
     * @param string $doc_ver
     * @return \StructType\Document
     */
    public function setDoc_ver($doc_ver = null)
    {
        // validation for constraint: string
        if (!is_null($doc_ver) && !is_string($doc_ver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_ver, true), gettype($doc_ver)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($doc_ver) && mb_strlen($doc_ver) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($doc_ver)), __LINE__);
        }
        $this->doc_ver = $this->{'doc-ver'} = $doc_ver;
        return $this;
    }
}
