<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CLAIM StructType
 * Meta information extracted from the WSDL
 * - documentation: Claim | Reklamace
 * @subpackage Structs
 */
class CLAIM extends AbstractStructBase
{
    /**
     * The activity
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $activity;
    /**
     * The Claim_text
     * Meta information extracted from the WSDL
     * - documentation: Claim text | Text reklamace
     * @var string
     */
    public $Claim_text;
    /**
     * The Claim_reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Claim_reference[]
     */
    public $Claim_reference;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $Attachment;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Action[]
     */
    public $Action;
    /**
     * The claim_id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $claim_id;
    /**
     * The claim_type
     * @var string
     */
    public $claim_type;
    /**
     * The priority
     * @var string
     */
    public $priority;
    /**
     * The processor
     * Meta information extracted from the WSDL
     * - documentation: Claim processor | Zpracovatel reklamace | EAN type | Typ pro EAN | Typ pro EAN 13 znaků | EAN 13 type
     * - base: ean
     * - length: 13
     * - pattern: \d+
     * @var string
     */
    public $processor;
    /**
     * The submitter
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * @var string
     */
    public $submitter;
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Date and time of the claim entry | Datum a čas podání reklamace
     * @var string
     */
    public $date_time;
    /**
     * The public
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - pattern: 0
     * @var bool
     */
    public $public;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The claim_subject
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $claim_subject;
    /**
     * The claim_data_cat
     * @var string
     */
    public $claim_data_cat;
    /**
     * The valid_from
     * Meta information extracted from the WSDL
     * - documentation: Valid from (only for OTE messages - noticeboard) | Platnost od (pouze pro zprávy OTE)
     * @var string
     */
    public $valid_from;
    /**
     * The valid_to
     * Meta information extracted from the WSDL
     * - documentation: Valid to (only for OTE messages) | Platnost do (pouze pro zprávy OTE)
     * @var string
     */
    public $valid_to;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - documentation: Internal version of OTE report | Interní verze zprávy OTE
     * - use: optional
     * @var int
     */
    public $version;
    /**
     * The template_id
     * Meta information extracted from the WSDL
     * - documentation: Internal message template identifier | Interní identifikátor šablony zprávy
     * - use: optional
     * @var int
     */
    public $template_id;
    /**
     * Constructor method for CLAIM
     * @uses CLAIM::setActivity()
     * @uses CLAIM::setClaim_text()
     * @uses CLAIM::setClaim_reference()
     * @uses CLAIM::setAttachment()
     * @uses CLAIM::setAction()
     * @uses CLAIM::setClaim_id()
     * @uses CLAIM::setClaim_type()
     * @uses CLAIM::setPriority()
     * @uses CLAIM::setProcessor()
     * @uses CLAIM::setSubmitter()
     * @uses CLAIM::setDate_time()
     * @uses CLAIM::setPublic()
     * @uses CLAIM::setStatus()
     * @uses CLAIM::setClaim_subject()
     * @uses CLAIM::setClaim_data_cat()
     * @uses CLAIM::setValid_from()
     * @uses CLAIM::setValid_to()
     * @uses CLAIM::setVersion()
     * @uses CLAIM::setTemplate_id()
     * @param string $activity
     * @param string $claim_text
     * @param \StructType\Claim_reference[] $claim_reference
     * @param \StructType\Attachment[] $attachment
     * @param \StructType\Action[] $action
     * @param string $claim_id
     * @param string $claim_type
     * @param string $priority
     * @param string $processor
     * @param string $submitter
     * @param string $date_time
     * @param bool $public
     * @param string $status
     * @param string $claim_subject
     * @param string $claim_data_cat
     * @param string $valid_from
     * @param string $valid_to
     * @param int $version
     * @param int $template_id
     */
    public function __construct($activity = null, $claim_text = null, array $claim_reference = array(), array $attachment = array(), array $action = array(), $claim_id = null, $claim_type = null, $priority = null, $processor = null, $submitter = null, $date_time = null, $public = null, $status = null, $claim_subject = null, $claim_data_cat = null, $valid_from = null, $valid_to = null, $version = null, $template_id = null)
    {
        $this
            ->setActivity($activity)
            ->setClaim_text($claim_text)
            ->setClaim_reference($claim_reference)
            ->setAttachment($attachment)
            ->setAction($action)
            ->setClaim_id($claim_id)
            ->setClaim_type($claim_type)
            ->setPriority($priority)
            ->setProcessor($processor)
            ->setSubmitter($submitter)
            ->setDate_time($date_time)
            ->setPublic($public)
            ->setStatus($status)
            ->setClaim_subject($claim_subject)
            ->setClaim_data_cat($claim_data_cat)
            ->setValid_from($valid_from)
            ->setValid_to($valid_to)
            ->setVersion($version)
            ->setTemplate_id($template_id);
    }
    /**
     * Get activity value
     * @return string
     */
    public function getActivity()
    {
        return $this->activity;
    }
    /**
     * Set activity value
     * @param string $activity
     * @return \StructType\CLAIM
     */
    public function setActivity($activity = null)
    {
        // validation for constraint: string
        if (!is_null($activity) && !is_string($activity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activity, true), gettype($activity)), __LINE__);
        }
        $this->activity = $activity;
        return $this;
    }
    /**
     * Get Claim_text value
     * @return string|null
     */
    public function getClaim_text()
    {
        return $this->{'Claim-text'};
    }
    /**
     * Set Claim_text value
     * @param string $claim_text
     * @return \StructType\CLAIM
     */
    public function setClaim_text($claim_text = null)
    {
        // validation for constraint: string
        if (!is_null($claim_text) && !is_string($claim_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claim_text, true), gettype($claim_text)), __LINE__);
        }
        $this->Claim_text = $this->{'Claim-text'} = $claim_text;
        return $this;
    }
    /**
     * Get Claim_reference value
     * @return \StructType\Claim_reference[]|null
     */
    public function getClaim_reference()
    {
        return $this->{'Claim-reference'};
    }
    /**
     * This method is responsible for validating the values passed to the setClaim_reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaim_reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClaim_referenceForArrayConstraintsFromSetClaim_reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cLAIMClaim_referenceItem) {
            // validation for constraint: itemType
            if (!$cLAIMClaim_referenceItem instanceof \StructType\Claim_reference) {
                $invalidValues[] = is_object($cLAIMClaim_referenceItem) ? get_class($cLAIMClaim_referenceItem) : sprintf('%s(%s)', gettype($cLAIMClaim_referenceItem), var_export($cLAIMClaim_referenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Claim_reference property can only contain items of type \StructType\Claim_reference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Claim_reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Claim_reference[] $claim_reference
     * @return \StructType\CLAIM
     */
    public function setClaim_reference(array $claim_reference = array())
    {
        // validation for constraint: array
        if ('' !== ($claim_referenceArrayErrorMessage = self::validateClaim_referenceForArrayConstraintsFromSetClaim_reference($claim_reference))) {
            throw new \InvalidArgumentException($claim_referenceArrayErrorMessage, __LINE__);
        }
        $this->Claim_reference = $this->{'Claim-reference'} = $claim_reference;
        return $this;
    }
    /**
     * Add item to Claim_reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Claim_reference $item
     * @return \StructType\CLAIM
     */
    public function addToClaim_reference(\StructType\Claim_reference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Claim_reference) {
            throw new \InvalidArgumentException(sprintf('The Claim_reference property can only contain items of type \StructType\Claim_reference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Claim_reference[] = $this->{'Claim-reference'}[] = $item;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cLAIMAttachmentItem) {
            // validation for constraint: itemType
            if (!$cLAIMAttachmentItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($cLAIMAttachmentItem) ? get_class($cLAIMAttachmentItem) : sprintf('%s(%s)', gettype($cLAIMAttachmentItem), var_export($cLAIMAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\CLAIM
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Add item to Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\CLAIM
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment[] = $item;
        return $this;
    }
    /**
     * Get Action value
     * @return \StructType\Action[]|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * This method is responsible for validating the values passed to the setAction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActionForArrayConstraintsFromSetAction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cLAIMActionItem) {
            // validation for constraint: itemType
            if (!$cLAIMActionItem instanceof \StructType\Action) {
                $invalidValues[] = is_object($cLAIMActionItem) ? get_class($cLAIMActionItem) : sprintf('%s(%s)', gettype($cLAIMActionItem), var_export($cLAIMActionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Action property can only contain items of type \StructType\Action, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Action value
     * @throws \InvalidArgumentException
     * @param \StructType\Action[] $action
     * @return \StructType\CLAIM
     */
    public function setAction(array $action = array())
    {
        // validation for constraint: array
        if ('' !== ($actionArrayErrorMessage = self::validateActionForArrayConstraintsFromSetAction($action))) {
            throw new \InvalidArgumentException($actionArrayErrorMessage, __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Add item to Action value
     * @throws \InvalidArgumentException
     * @param \StructType\Action $item
     * @return \StructType\CLAIM
     */
    public function addToAction(\StructType\Action $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Action) {
            throw new \InvalidArgumentException(sprintf('The Action property can only contain items of type \StructType\Action, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Action[] = $item;
        return $this;
    }
    /**
     * Get claim_id value
     * @return string|null
     */
    public function getClaim_id()
    {
        return $this->{'claim-id'};
    }
    /**
     * Set claim_id value
     * @param string $claim_id
     * @return \StructType\CLAIM
     */
    public function setClaim_id($claim_id = null)
    {
        // validation for constraint: string
        if (!is_null($claim_id) && !is_string($claim_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claim_id, true), gettype($claim_id)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($claim_id) && mb_strlen($claim_id) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($claim_id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($claim_id) && mb_strlen($claim_id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($claim_id)), __LINE__);
        }
        $this->claim_id = $this->{'claim-id'} = $claim_id;
        return $this;
    }
    /**
     * Get claim_type value
     * @return string|null
     */
    public function getClaim_type()
    {
        return $this->{'claim-type'};
    }
    /**
     * Set claim_type value
     * @param string $claim_type
     * @return \StructType\CLAIM
     */
    public function setClaim_type($claim_type = null)
    {
        // validation for constraint: string
        if (!is_null($claim_type) && !is_string($claim_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claim_type, true), gettype($claim_type)), __LINE__);
        }
        $this->claim_type = $this->{'claim-type'} = $claim_type;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param string $priority
     * @return \StructType\CLAIM
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get processor value
     * @return string|null
     */
    public function getProcessor()
    {
        return $this->processor;
    }
    /**
     * Set processor value
     * @param string $processor
     * @return \StructType\CLAIM
     */
    public function setProcessor($processor = null)
    {
        // validation for constraint: string
        if (!is_null($processor) && !is_string($processor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processor, true), gettype($processor)), __LINE__);
        }
        // validation for constraint: length(13)
        if (!is_null($processor) && mb_strlen($processor) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 13', mb_strlen($processor)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($processor) && !preg_match('/\\d+/', $processor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($processor, true)), __LINE__);
        }
        $this->processor = $processor;
        return $this;
    }
    /**
     * Get submitter value
     * @return string|null
     */
    public function getSubmitter()
    {
        return $this->submitter;
    }
    /**
     * Set submitter value
     * @param string $submitter
     * @return \StructType\CLAIM
     */
    public function setSubmitter($submitter = null)
    {
        // validation for constraint: string
        if (!is_null($submitter) && !is_string($submitter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submitter, true), gettype($submitter)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($submitter) && mb_strlen($submitter) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($submitter)), __LINE__);
        }
        $this->submitter = $submitter;
        return $this;
    }
    /**
     * Get date_time value
     * @return string|null
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\CLAIM
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
    /**
     * Get public value
     * @return bool|null
     */
    public function getPublic()
    {
        return $this->public;
    }
    /**
     * Set public value
     * @param bool $public
     * @return \StructType\CLAIM
     */
    public function setPublic($public = null)
    {
        // validation for constraint: boolean
        if (!is_null($public) && !is_bool($public)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($public, true), gettype($public)), __LINE__);
        }
        // validation for constraint: pattern
        if (!is_null($public) && !preg_match('/0/', $public)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression 0', var_export($public, true)), __LINE__);
        }
        $this->public = $public;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\CLAIM
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get claim_subject value
     * @return string|null
     */
    public function getClaim_subject()
    {
        return $this->{'claim-subject'};
    }
    /**
     * Set claim_subject value
     * @param string $claim_subject
     * @return \StructType\CLAIM
     */
    public function setClaim_subject($claim_subject = null)
    {
        // validation for constraint: string
        if (!is_null($claim_subject) && !is_string($claim_subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claim_subject, true), gettype($claim_subject)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($claim_subject) && mb_strlen($claim_subject) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($claim_subject)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($claim_subject) && mb_strlen($claim_subject) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($claim_subject)), __LINE__);
        }
        $this->claim_subject = $this->{'claim-subject'} = $claim_subject;
        return $this;
    }
    /**
     * Get claim_data_cat value
     * @return string|null
     */
    public function getClaim_data_cat()
    {
        return $this->{'claim-data-cat'};
    }
    /**
     * Set claim_data_cat value
     * @param string $claim_data_cat
     * @return \StructType\CLAIM
     */
    public function setClaim_data_cat($claim_data_cat = null)
    {
        // validation for constraint: string
        if (!is_null($claim_data_cat) && !is_string($claim_data_cat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claim_data_cat, true), gettype($claim_data_cat)), __LINE__);
        }
        $this->claim_data_cat = $this->{'claim-data-cat'} = $claim_data_cat;
        return $this;
    }
    /**
     * Get valid_from value
     * @return string|null
     */
    public function getValid_from()
    {
        return $this->{'valid-from'};
    }
    /**
     * Set valid_from value
     * @param string $valid_from
     * @return \StructType\CLAIM
     */
    public function setValid_from($valid_from = null)
    {
        // validation for constraint: string
        if (!is_null($valid_from) && !is_string($valid_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valid_from, true), gettype($valid_from)), __LINE__);
        }
        $this->valid_from = $this->{'valid-from'} = $valid_from;
        return $this;
    }
    /**
     * Get valid_to value
     * @return string|null
     */
    public function getValid_to()
    {
        return $this->{'valid-to'};
    }
    /**
     * Set valid_to value
     * @param string $valid_to
     * @return \StructType\CLAIM
     */
    public function setValid_to($valid_to = null)
    {
        // validation for constraint: string
        if (!is_null($valid_to) && !is_string($valid_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valid_to, true), gettype($valid_to)), __LINE__);
        }
        $this->valid_to = $this->{'valid-to'} = $valid_to;
        return $this;
    }
    /**
     * Get version value
     * @return int|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param int $version
     * @return \StructType\CLAIM
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get template_id value
     * @return int|null
     */
    public function getTemplate_id()
    {
        return $this->{'template-id'};
    }
    /**
     * Set template_id value
     * @param int $template_id
     * @return \StructType\CLAIM
     */
    public function setTemplate_id($template_id = null)
    {
        // validation for constraint: int
        if (!is_null($template_id) && !(is_int($template_id) || ctype_digit($template_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($template_id, true), gettype($template_id)), __LINE__);
        }
        $this->template_id = $this->{'template-id'} = $template_id;
        return $this;
    }
}
