<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Workflow StructType
 * Meta information extracted from the WSDL
 * - documentation: Workflow identification (unique ID, state of change of supplier can be traced by it) | Identifikace workflow (jednoznačné ID, podle kterého se lze dotázat na stav změny dodavatele)
 * @subpackage Structs
 */
class Workflow extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Message number type | Typ pro číslo zprávy
     * - base: ote:msg-id
     * - maxLength: 12
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Datum a čas zahájení ZD (doplňuje OTE)
     * @var string
     */
    public $date_time;
    /**
     * Constructor method for Workflow
     * @uses Workflow::setId()
     * @uses Workflow::setDate_time()
     * @param string $id
     * @param string $date_time
     */
    public function __construct($id = null, $date_time = null)
    {
        $this
            ->setId($id)
            ->setDate_time($date_time);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Workflow
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($id) && mb_strlen($id) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get date_time value
     * @return string|null
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\Workflow
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
}
