<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for row_type StructType
 * @subpackage Structs
 */
class Row_type extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - documentation: Quantity | Množství | Desetinné číslo na max. tři des. místa (ne exponenciální tvar) | Decimal number - max. 3 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,3})?
     * - use: optional
     * @var string
     */
    public $value;
    /**
     * The PDT_count
     * Meta information extracted from the WSDL
     * - documentation: PDT count to end of month | Počet OPM k poslednímu dni v měsíci | Desetinné číslo na max. tři des. místa (ne exponenciální tvar) | Decimal number - max. 3 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,3})?
     * - use: optional
     * @var string
     */
    public $PDT_count;
    /**
     * Constructor method for row_type
     * @uses Row_type::setId()
     * @uses Row_type::setValue()
     * @uses Row_type::setPDT_count()
     * @param string $id
     * @param string $value
     * @param string $pDT_count
     */
    public function __construct($id = null, $value = null, $pDT_count = null)
    {
        $this
            ->setId($id)
            ->setValue($value)
            ->setPDT_count($pDT_count);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Row_type
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($id) && mb_strlen($id) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\Row_type
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($value) && mb_strlen($value) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($value)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,3})?)
        if (!is_null($value) && !preg_match('/-?\\d+(\\.\\d{1,3})?/', $value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,3})?', var_export($value, true)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get PDT_count value
     * @return string|null
     */
    public function getPDT_count()
    {
        return $this->{'PDT-count'};
    }
    /**
     * Set PDT_count value
     * @param string $pDT_count
     * @return \StructType\Row_type
     */
    public function setPDT_count($pDT_count = null)
    {
        // validation for constraint: string
        if (!is_null($pDT_count) && !is_string($pDT_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDT_count, true), gettype($pDT_count)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pDT_count) && mb_strlen($pDT_count) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pDT_count)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,3})?)
        if (!is_null($pDT_count) && !preg_match('/-?\\d+(\\.\\d{1,3})?/', $pDT_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,3})?', var_export($pDT_count, true)), __LINE__);
        }
        $this->PDT_count = $this->{'PDT-count'} = $pDT_count;
        return $this;
    }
}
