<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceMO StructType
 * Meta information extracted from the WSDL
 * - documentation: Billing | Zúčtování
 * @subpackage Structs
 */
class PriceMO extends AbstractStructBase
{
    /**
     * The dist_rate_type
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 8
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $dist_rate_type;
    /**
     * The cir_breaker
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - minInclusive: 0
     * - totalDigits: 6
     * - use: required
     * @var float
     */
    public $cir_breaker;
    /**
     * The num_phase
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $num_phase;
    /**
     * The inv_per_from
     * Meta information extracted from the WSDL
     * - documentation: Beginning of period | Počátek období
     * - use: required
     * @var string
     */
    public $inv_per_from;
    /**
     * The inv_per_to
     * Meta information extracted from the WSDL
     * - documentation: End of period | Konec období
     * - use: required
     * @var string
     */
    public $inv_per_to;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - documentation: Billing item | Položka zúčtování
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_type[]
     */
    public $Item;
    /**
     * Constructor method for PriceMO
     * @uses PriceMO::setDist_rate_type()
     * @uses PriceMO::setCir_breaker()
     * @uses PriceMO::setNum_phase()
     * @uses PriceMO::setInv_per_from()
     * @uses PriceMO::setInv_per_to()
     * @uses PriceMO::setItem()
     * @param string $dist_rate_type
     * @param float $cir_breaker
     * @param string $num_phase
     * @param string $inv_per_from
     * @param string $inv_per_to
     * @param \StructType\Item_type[] $item
     */
    public function __construct($dist_rate_type = null, $cir_breaker = null, $num_phase = null, $inv_per_from = null, $inv_per_to = null, array $item = array())
    {
        $this
            ->setDist_rate_type($dist_rate_type)
            ->setCir_breaker($cir_breaker)
            ->setNum_phase($num_phase)
            ->setInv_per_from($inv_per_from)
            ->setInv_per_to($inv_per_to)
            ->setItem($item);
    }
    /**
     * Get dist_rate_type value
     * @return string
     */
    public function getDist_rate_type()
    {
        return $this->{'dist-rate-type'};
    }
    /**
     * Set dist_rate_type value
     * @param string $dist_rate_type
     * @return \StructType\PriceMO
     */
    public function setDist_rate_type($dist_rate_type = null)
    {
        // validation for constraint: string
        if (!is_null($dist_rate_type) && !is_string($dist_rate_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dist_rate_type, true), gettype($dist_rate_type)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($dist_rate_type) && mb_strlen($dist_rate_type) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($dist_rate_type)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($dist_rate_type) && mb_strlen($dist_rate_type) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($dist_rate_type)), __LINE__);
        }
        $this->dist_rate_type = $this->{'dist-rate-type'} = $dist_rate_type;
        return $this;
    }
    /**
     * Get cir_breaker value
     * @return float
     */
    public function getCir_breaker()
    {
        return $this->{'cir-breaker'};
    }
    /**
     * Set cir_breaker value
     * @param float $cir_breaker
     * @return \StructType\PriceMO
     */
    public function setCir_breaker($cir_breaker = null)
    {
        // validation for constraint: float
        if (!is_null($cir_breaker) && !(is_float($cir_breaker) || is_numeric($cir_breaker))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cir_breaker, true), gettype($cir_breaker)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($cir_breaker) && mb_strlen(mb_substr($cir_breaker, false !== mb_strpos($cir_breaker, '.') ? mb_strpos($cir_breaker, '.') + 1 : mb_strlen($cir_breaker))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($cir_breaker, true), mb_strlen(mb_substr($cir_breaker, mb_strpos($cir_breaker, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cir_breaker) && $cir_breaker < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cir_breaker, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($cir_breaker) && mb_strlen(preg_replace('/(\D)/', '', $cir_breaker)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($cir_breaker, true), mb_strlen(preg_replace('/(\D)/', '', $cir_breaker))), __LINE__);
        }
        $this->cir_breaker = $this->{'cir-breaker'} = $cir_breaker;
        return $this;
    }
    /**
     * Get num_phase value
     * @return string
     */
    public function getNum_phase()
    {
        return $this->{'num-phase'};
    }
    /**
     * Set num_phase value
     * @param string $num_phase
     * @return \StructType\PriceMO
     */
    public function setNum_phase($num_phase = null)
    {
        // validation for constraint: string
        if (!is_null($num_phase) && !is_string($num_phase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($num_phase, true), gettype($num_phase)), __LINE__);
        }
        $this->num_phase = $this->{'num-phase'} = $num_phase;
        return $this;
    }
    /**
     * Get inv_per_from value
     * @return string
     */
    public function getInv_per_from()
    {
        return $this->{'inv-per-from'};
    }
    /**
     * Set inv_per_from value
     * @param string $inv_per_from
     * @return \StructType\PriceMO
     */
    public function setInv_per_from($inv_per_from = null)
    {
        // validation for constraint: string
        if (!is_null($inv_per_from) && !is_string($inv_per_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_per_from, true), gettype($inv_per_from)), __LINE__);
        }
        $this->inv_per_from = $this->{'inv-per-from'} = $inv_per_from;
        return $this;
    }
    /**
     * Get inv_per_to value
     * @return string
     */
    public function getInv_per_to()
    {
        return $this->{'inv-per-to'};
    }
    /**
     * Set inv_per_to value
     * @param string $inv_per_to
     * @return \StructType\PriceMO
     */
    public function setInv_per_to($inv_per_to = null)
    {
        // validation for constraint: string
        if (!is_null($inv_per_to) && !is_string($inv_per_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_per_to, true), gettype($inv_per_to)), __LINE__);
        }
        $this->inv_per_to = $this->{'inv-per-to'} = $inv_per_to;
        return $this;
    }
    /**
     * Get Item value
     * @return \StructType\Item_type[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $priceMOItemItem) {
            // validation for constraint: itemType
            if (!$priceMOItemItem instanceof \StructType\Item_type) {
                $invalidValues[] = is_object($priceMOItemItem) ? get_class($priceMOItemItem) : sprintf('%s(%s)', gettype($priceMOItemItem), var_export($priceMOItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item property can only contain items of type \StructType\Item_type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_type[] $item
     * @return \StructType\PriceMO
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_type $item
     * @return \StructType\PriceMO
     */
    public function addToItem(\StructType\Item_type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_type) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of type \StructType\Item_type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
}
