<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocSummary StructType
 * Meta information extracted from the WSDL
 * - documentation: Document summary | Shrnutí dokladu
 * @subpackage Structs
 */
class DocSummary extends AbstractStructBase
{
    /**
     * The ListOfSumItems
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ListOfSumItems[]
     */
    public $ListOfSumItems;
    /**
     * The DocumentTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * @var \StructType\DocumentTotal[]
     */
    public $DocumentTotal;
    /**
     * The PaymentSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\PaymentSummary[]
     */
    public $PaymentSummary;
    /**
     * The DocSummaryNote
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $DocSummaryNote;
    /**
     * Constructor method for DocSummary
     * @uses DocSummary::setListOfSumItems()
     * @uses DocSummary::setDocumentTotal()
     * @uses DocSummary::setPaymentSummary()
     * @uses DocSummary::setDocSummaryNote()
     * @param \StructType\ListOfSumItems[] $listOfSumItems
     * @param \StructType\DocumentTotal[] $documentTotal
     * @param \StructType\PaymentSummary[] $paymentSummary
     * @param mixed[] $docSummaryNote
     */
    public function __construct(array $listOfSumItems = array(), array $documentTotal = array(), array $paymentSummary = array(), array $docSummaryNote = array())
    {
        $this
            ->setListOfSumItems($listOfSumItems)
            ->setDocumentTotal($documentTotal)
            ->setPaymentSummary($paymentSummary)
            ->setDocSummaryNote($docSummaryNote);
    }
    /**
     * Get ListOfSumItems value
     * @return \StructType\ListOfSumItems[]|null
     */
    public function getListOfSumItems()
    {
        return $this->ListOfSumItems;
    }
    /**
     * This method is responsible for validating the values passed to the setListOfSumItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListOfSumItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListOfSumItemsForArrayConstraintsFromSetListOfSumItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docSummaryListOfSumItemsItem) {
            // validation for constraint: itemType
            if (!$docSummaryListOfSumItemsItem instanceof \StructType\ListOfSumItems) {
                $invalidValues[] = is_object($docSummaryListOfSumItemsItem) ? get_class($docSummaryListOfSumItemsItem) : sprintf('%s(%s)', gettype($docSummaryListOfSumItemsItem), var_export($docSummaryListOfSumItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListOfSumItems property can only contain items of type \StructType\ListOfSumItems, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ListOfSumItems value
     * @throws \InvalidArgumentException
     * @param \StructType\ListOfSumItems[] $listOfSumItems
     * @return \StructType\DocSummary
     */
    public function setListOfSumItems(array $listOfSumItems = array())
    {
        // validation for constraint: array
        if ('' !== ($listOfSumItemsArrayErrorMessage = self::validateListOfSumItemsForArrayConstraintsFromSetListOfSumItems($listOfSumItems))) {
            throw new \InvalidArgumentException($listOfSumItemsArrayErrorMessage, __LINE__);
        }
        $this->ListOfSumItems = $listOfSumItems;
        return $this;
    }
    /**
     * Add item to ListOfSumItems value
     * @throws \InvalidArgumentException
     * @param \StructType\ListOfSumItems $item
     * @return \StructType\DocSummary
     */
    public function addToListOfSumItems(\StructType\ListOfSumItems $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ListOfSumItems) {
            throw new \InvalidArgumentException(sprintf('The ListOfSumItems property can only contain items of type \StructType\ListOfSumItems, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ListOfSumItems[] = $item;
        return $this;
    }
    /**
     * Get DocumentTotal value
     * @return \StructType\DocumentTotal[]|null
     */
    public function getDocumentTotal()
    {
        return $this->DocumentTotal;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentTotalForArrayConstraintsFromSetDocumentTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docSummaryDocumentTotalItem) {
            // validation for constraint: itemType
            if (!$docSummaryDocumentTotalItem instanceof \StructType\DocumentTotal) {
                $invalidValues[] = is_object($docSummaryDocumentTotalItem) ? get_class($docSummaryDocumentTotalItem) : sprintf('%s(%s)', gettype($docSummaryDocumentTotalItem), var_export($docSummaryDocumentTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentTotal property can only contain items of type \StructType\DocumentTotal, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentTotal value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentTotal[] $documentTotal
     * @return \StructType\DocSummary
     */
    public function setDocumentTotal(array $documentTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($documentTotalArrayErrorMessage = self::validateDocumentTotalForArrayConstraintsFromSetDocumentTotal($documentTotal))) {
            throw new \InvalidArgumentException($documentTotalArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($documentTotal) && count($documentTotal) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($documentTotal)), __LINE__);
        }
        $this->DocumentTotal = $documentTotal;
        return $this;
    }
    /**
     * Add item to DocumentTotal value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentTotal $item
     * @return \StructType\DocSummary
     */
    public function addToDocumentTotal(\StructType\DocumentTotal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentTotal) {
            throw new \InvalidArgumentException(sprintf('The DocumentTotal property can only contain items of type \StructType\DocumentTotal, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->DocumentTotal) && count($this->DocumentTotal) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->DocumentTotal)), __LINE__);
        }
        $this->DocumentTotal[] = $item;
        return $this;
    }
    /**
     * Get PaymentSummary value
     * @return \StructType\PaymentSummary[]|null
     */
    public function getPaymentSummary()
    {
        return $this->PaymentSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentSummaryForArrayConstraintsFromSetPaymentSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docSummaryPaymentSummaryItem) {
            // validation for constraint: itemType
            if (!$docSummaryPaymentSummaryItem instanceof \StructType\PaymentSummary) {
                $invalidValues[] = is_object($docSummaryPaymentSummaryItem) ? get_class($docSummaryPaymentSummaryItem) : sprintf('%s(%s)', gettype($docSummaryPaymentSummaryItem), var_export($docSummaryPaymentSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentSummary property can only contain items of type \StructType\PaymentSummary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentSummary[] $paymentSummary
     * @return \StructType\DocSummary
     */
    public function setPaymentSummary(array $paymentSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentSummaryArrayErrorMessage = self::validatePaymentSummaryForArrayConstraintsFromSetPaymentSummary($paymentSummary))) {
            throw new \InvalidArgumentException($paymentSummaryArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($paymentSummary) && count($paymentSummary) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($paymentSummary)), __LINE__);
        }
        $this->PaymentSummary = $paymentSummary;
        return $this;
    }
    /**
     * Add item to PaymentSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentSummary $item
     * @return \StructType\DocSummary
     */
    public function addToPaymentSummary(\StructType\PaymentSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentSummary) {
            throw new \InvalidArgumentException(sprintf('The PaymentSummary property can only contain items of type \StructType\PaymentSummary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->PaymentSummary) && count($this->PaymentSummary) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->PaymentSummary)), __LINE__);
        }
        $this->PaymentSummary[] = $item;
        return $this;
    }
    /**
     * Get DocSummaryNote value
     * @return mixed[]|null
     */
    public function getDocSummaryNote()
    {
        return $this->DocSummaryNote;
    }
    /**
     * This method is responsible for validating the values passed to the setDocSummaryNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocSummaryNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocSummaryNoteForArrayConstraintsFromSetDocSummaryNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docSummaryDocSummaryNoteItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($docSummaryDocSummaryNoteItem) ? get_class($docSummaryDocSummaryNoteItem) : sprintf('%s(%s)', gettype($docSummaryDocSummaryNoteItem), var_export($docSummaryDocSummaryNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocSummaryNote property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocSummaryNote value
     * @throws \InvalidArgumentException
     * @param mixed[] $docSummaryNote
     * @return \StructType\DocSummary
     */
    public function setDocSummaryNote(array $docSummaryNote = array())
    {
        // validation for constraint: array
        if ('' !== ($docSummaryNoteArrayErrorMessage = self::validateDocSummaryNoteForArrayConstraintsFromSetDocSummaryNote($docSummaryNote))) {
            throw new \InvalidArgumentException($docSummaryNoteArrayErrorMessage, __LINE__);
        }
        $this->DocSummaryNote = $docSummaryNote;
        return $this;
    }
    /**
     * Add item to DocSummaryNote value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\DocSummary
     */
    public function addToDocSummaryNote($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The DocSummaryNote property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocSummaryNote[] = $item;
        return $this;
    }
}
