<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocHeader StructType
 * Meta information extracted from the WSDL
 * - documentation: Document header | Hlavička dokladu
 * @subpackage Structs
 */
class DocHeader extends AbstractStructBase
{
    /**
     * The Party
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * @var \StructType\Party[]
     */
    public $Party;
    /**
     * The DocDates
     * @var \StructType\DocDates
     */
    public $DocDates;
    /**
     * The PaymentInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentInfo
     */
    public $PaymentInfo;
    /**
     * The RefDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RefDocument[]
     */
    public $RefDocument;
    /**
     * The DocHeaderNote
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $DocHeaderNote;
    /**
     * Constructor method for DocHeader
     * @uses DocHeader::setParty()
     * @uses DocHeader::setDocDates()
     * @uses DocHeader::setPaymentInfo()
     * @uses DocHeader::setRefDocument()
     * @uses DocHeader::setDocHeaderNote()
     * @param \StructType\Party[] $party
     * @param \StructType\DocDates $docDates
     * @param \StructType\PaymentInfo $paymentInfo
     * @param \StructType\RefDocument[] $refDocument
     * @param mixed[] $docHeaderNote
     */
    public function __construct(array $party = array(), \StructType\DocDates $docDates = null, \StructType\PaymentInfo $paymentInfo = null, array $refDocument = array(), array $docHeaderNote = array())
    {
        $this
            ->setParty($party)
            ->setDocDates($docDates)
            ->setPaymentInfo($paymentInfo)
            ->setRefDocument($refDocument)
            ->setDocHeaderNote($docHeaderNote);
    }
    /**
     * Get Party value
     * @return \StructType\Party[]
     */
    public function getParty()
    {
        return $this->Party;
    }
    /**
     * This method is responsible for validating the values passed to the setParty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyForArrayConstraintsFromSetParty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docHeaderPartyItem) {
            // validation for constraint: itemType
            if (!$docHeaderPartyItem instanceof \StructType\Party) {
                $invalidValues[] = is_object($docHeaderPartyItem) ? get_class($docHeaderPartyItem) : sprintf('%s(%s)', gettype($docHeaderPartyItem), var_export($docHeaderPartyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Party property can only contain items of type \StructType\Party, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Party value
     * @throws \InvalidArgumentException
     * @param \StructType\Party[] $party
     * @return \StructType\DocHeader
     */
    public function setParty(array $party = array())
    {
        // validation for constraint: array
        if ('' !== ($partyArrayErrorMessage = self::validatePartyForArrayConstraintsFromSetParty($party))) {
            throw new \InvalidArgumentException($partyArrayErrorMessage, __LINE__);
        }
        $this->Party = $party;
        return $this;
    }
    /**
     * Add item to Party value
     * @throws \InvalidArgumentException
     * @param \StructType\Party $item
     * @return \StructType\DocHeader
     */
    public function addToParty(\StructType\Party $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Party) {
            throw new \InvalidArgumentException(sprintf('The Party property can only contain items of type \StructType\Party, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Party[] = $item;
        return $this;
    }
    /**
     * Get DocDates value
     * @return \StructType\DocDates|null
     */
    public function getDocDates()
    {
        return $this->DocDates;
    }
    /**
     * Set DocDates value
     * @param \StructType\DocDates $docDates
     * @return \StructType\DocHeader
     */
    public function setDocDates(\StructType\DocDates $docDates = null)
    {
        $this->DocDates = $docDates;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \StructType\PaymentInfo|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @param \StructType\PaymentInfo $paymentInfo
     * @return \StructType\DocHeader
     */
    public function setPaymentInfo(\StructType\PaymentInfo $paymentInfo = null)
    {
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get RefDocument value
     * @return \StructType\RefDocument[]|null
     */
    public function getRefDocument()
    {
        return $this->RefDocument;
    }
    /**
     * This method is responsible for validating the values passed to the setRefDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRefDocumentForArrayConstraintsFromSetRefDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docHeaderRefDocumentItem) {
            // validation for constraint: itemType
            if (!$docHeaderRefDocumentItem instanceof \StructType\RefDocument) {
                $invalidValues[] = is_object($docHeaderRefDocumentItem) ? get_class($docHeaderRefDocumentItem) : sprintf('%s(%s)', gettype($docHeaderRefDocumentItem), var_export($docHeaderRefDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RefDocument property can only contain items of type \StructType\RefDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RefDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\RefDocument[] $refDocument
     * @return \StructType\DocHeader
     */
    public function setRefDocument(array $refDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($refDocumentArrayErrorMessage = self::validateRefDocumentForArrayConstraintsFromSetRefDocument($refDocument))) {
            throw new \InvalidArgumentException($refDocumentArrayErrorMessage, __LINE__);
        }
        $this->RefDocument = $refDocument;
        return $this;
    }
    /**
     * Add item to RefDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\RefDocument $item
     * @return \StructType\DocHeader
     */
    public function addToRefDocument(\StructType\RefDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RefDocument) {
            throw new \InvalidArgumentException(sprintf('The RefDocument property can only contain items of type \StructType\RefDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RefDocument[] = $item;
        return $this;
    }
    /**
     * Get DocHeaderNote value
     * @return mixed[]|null
     */
    public function getDocHeaderNote()
    {
        return $this->DocHeaderNote;
    }
    /**
     * This method is responsible for validating the values passed to the setDocHeaderNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocHeaderNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocHeaderNoteForArrayConstraintsFromSetDocHeaderNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docHeaderDocHeaderNoteItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($docHeaderDocHeaderNoteItem) ? get_class($docHeaderDocHeaderNoteItem) : sprintf('%s(%s)', gettype($docHeaderDocHeaderNoteItem), var_export($docHeaderDocHeaderNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocHeaderNote property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocHeaderNote value
     * @throws \InvalidArgumentException
     * @param mixed[] $docHeaderNote
     * @return \StructType\DocHeader
     */
    public function setDocHeaderNote(array $docHeaderNote = array())
    {
        // validation for constraint: array
        if ('' !== ($docHeaderNoteArrayErrorMessage = self::validateDocHeaderNoteForArrayConstraintsFromSetDocHeaderNote($docHeaderNote))) {
            throw new \InvalidArgumentException($docHeaderNoteArrayErrorMessage, __LINE__);
        }
        $this->DocHeaderNote = $docHeaderNote;
        return $this;
    }
    /**
     * Add item to DocHeaderNote value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\DocHeader
     */
    public function addToDocHeaderNote($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The DocHeaderNote property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocHeaderNote[] = $item;
        return $this;
    }
}
