<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SysServices StructType
 * Meta information extracted from the WSDL
 * - documentation: System services | Systémové služby
 * @subpackage Structs
 */
class SysServices extends AbstractStructBase
{
    /**
     * The cons_PSDS
     * Meta information extracted from the WSDL
     * - documentation: Consumed energy SP/DS - non-billable | Odebraná energie PS/DS nepodléhající platbě | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $cons_PSDS;
    /**
     * The cons_own
     * Meta information extracted from the WSDL
     * - documentation: Energy consumption of own generation | Spotřeba z vlastní výroby | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $cons_own;
    /**
     * Constructor method for SysServices
     * @uses SysServices::setCons_PSDS()
     * @uses SysServices::setCons_own()
     * @param string $cons_PSDS
     * @param string $cons_own
     */
    public function __construct($cons_PSDS = null, $cons_own = null)
    {
        $this
            ->setCons_PSDS($cons_PSDS)
            ->setCons_own($cons_own);
    }
    /**
     * Get cons_PSDS value
     * @return string|null
     */
    public function getCons_PSDS()
    {
        return $this->{'cons-PSDS'};
    }
    /**
     * Set cons_PSDS value
     * @param string $cons_PSDS
     * @return \StructType\SysServices
     */
    public function setCons_PSDS($cons_PSDS = null)
    {
        // validation for constraint: string
        if (!is_null($cons_PSDS) && !is_string($cons_PSDS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cons_PSDS, true), gettype($cons_PSDS)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($cons_PSDS) && mb_strlen($cons_PSDS) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($cons_PSDS)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($cons_PSDS) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $cons_PSDS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($cons_PSDS, true)), __LINE__);
        }
        $this->cons_PSDS = $this->{'cons-PSDS'} = $cons_PSDS;
        return $this;
    }
    /**
     * Get cons_own value
     * @return string|null
     */
    public function getCons_own()
    {
        return $this->{'cons-own'};
    }
    /**
     * Set cons_own value
     * @param string $cons_own
     * @return \StructType\SysServices
     */
    public function setCons_own($cons_own = null)
    {
        // validation for constraint: string
        if (!is_null($cons_own) && !is_string($cons_own)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cons_own, true), gettype($cons_own)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($cons_own) && mb_strlen($cons_own) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($cons_own)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($cons_own) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $cons_own)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($cons_own, true)), __LINE__);
        }
        $this->cons_own = $this->{'cons-own'} = $cons_own;
        return $this;
    }
}
