<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendRequest StructType
 * @subpackage Structs
 */
class SendRequest extends AbstractStructBase
{
    /**
     * The CDSREQ
     * Meta information extracted from the WSDL
     * - choice: CDSREQ | CDSCLAIM | CDSINVOICE | CDSDATA | CDSIDIS | MASTERDATA | TDD | TEMPERATURE | CDSLDSREPORT
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: request:CDSREQ
     * @var \StructType\CDSREQ
     */
    public $CDSREQ;
    /**
     * The CDSCLAIM
     * Meta information extracted from the WSDL
     * - choice: CDSREQ | CDSCLAIM | CDSINVOICE | CDSDATA | CDSIDIS | MASTERDATA | TDD | TEMPERATURE | CDSLDSREPORT
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: claim:CDSCLAIM
     * @var \StructType\CDSCLAIM
     */
    public $CDSCLAIM;
    /**
     * The CDSINVOICE
     * Meta information extracted from the WSDL
     * - choice: CDSREQ | CDSCLAIM | CDSINVOICE | CDSDATA | CDSIDIS | MASTERDATA | TDD | TEMPERATURE | CDSLDSREPORT
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: invoice:CDSINVOICE
     * @var \StructType\CDSINVOICE
     */
    public $CDSINVOICE;
    /**
     * The CDSDATA
     * Meta information extracted from the WSDL
     * - choice: CDSREQ | CDSCLAIM | CDSINVOICE | CDSDATA | CDSIDIS | MASTERDATA | TDD | TEMPERATURE | CDSLDSREPORT
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: data:CDSDATA
     * @var \StructType\CDSDATA
     */
    public $CDSDATA;
    /**
     * The CDSIDIS
     * Meta information extracted from the WSDL
     * - choice: CDSREQ | CDSCLAIM | CDSINVOICE | CDSDATA | CDSIDIS | MASTERDATA | TDD | TEMPERATURE | CDSLDSREPORT
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: idis:CDSIDIS
     * @var \StructType\CDSIDIS
     */
    public $CDSIDIS;
    /**
     * The MASTERDATA
     * Meta information extracted from the WSDL
     * - choice: CDSREQ | CDSCLAIM | CDSINVOICE | CDSDATA | CDSIDIS | MASTERDATA | TDD | TEMPERATURE | CDSLDSREPORT
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: masterdata:MASTERDATA
     * @var \StructType\MASTERDATA
     */
    public $MASTERDATA;
    /**
     * The TDD
     * Meta information extracted from the WSDL
     * - choice: CDSREQ | CDSCLAIM | CDSINVOICE | CDSDATA | CDSIDIS | MASTERDATA | TDD | TEMPERATURE | CDSLDSREPORT
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: tdd:TDD
     * @var \StructType\TDD
     */
    public $TDD;
    /**
     * The TEMPERATURE
     * Meta information extracted from the WSDL
     * - choice: CDSREQ | CDSCLAIM | CDSINVOICE | CDSDATA | CDSIDIS | MASTERDATA | TDD | TEMPERATURE | CDSLDSREPORT
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: temperature:TEMPERATURE
     * @var \StructType\TEMPERATURE
     */
    public $TEMPERATURE;
    /**
     * The CDSLDSREPORT
     * Meta information extracted from the WSDL
     * - choice: CDSREQ | CDSCLAIM | CDSINVOICE | CDSDATA | CDSIDIS | MASTERDATA | TDD | TEMPERATURE | CDSLDSREPORT
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: lds:CDSLDSREPORT
     * @var \StructType\CDSLDSREPORT
     */
    public $CDSLDSREPORT;
    /**
     * Constructor method for SendRequest
     * @uses SendRequest::setCDSREQ()
     * @uses SendRequest::setCDSCLAIM()
     * @uses SendRequest::setCDSINVOICE()
     * @uses SendRequest::setCDSDATA()
     * @uses SendRequest::setCDSIDIS()
     * @uses SendRequest::setMASTERDATA()
     * @uses SendRequest::setTDD()
     * @uses SendRequest::setTEMPERATURE()
     * @uses SendRequest::setCDSLDSREPORT()
     * @param \StructType\CDSREQ $cDSREQ
     * @param \StructType\CDSCLAIM $cDSCLAIM
     * @param \StructType\CDSINVOICE $cDSINVOICE
     * @param \StructType\CDSDATA $cDSDATA
     * @param \StructType\CDSIDIS $cDSIDIS
     * @param \StructType\MASTERDATA $mASTERDATA
     * @param \StructType\TDD $tDD
     * @param \StructType\TEMPERATURE $tEMPERATURE
     * @param \StructType\CDSLDSREPORT $cDSLDSREPORT
     */
    public function __construct(\StructType\CDSREQ $cDSREQ = null, \StructType\CDSCLAIM $cDSCLAIM = null, \StructType\CDSINVOICE $cDSINVOICE = null, \StructType\CDSDATA $cDSDATA = null, \StructType\CDSIDIS $cDSIDIS = null, \StructType\MASTERDATA $mASTERDATA = null, \StructType\TDD $tDD = null, \StructType\TEMPERATURE $tEMPERATURE = null, \StructType\CDSLDSREPORT $cDSLDSREPORT = null)
    {
        $this
            ->setCDSREQ($cDSREQ)
            ->setCDSCLAIM($cDSCLAIM)
            ->setCDSINVOICE($cDSINVOICE)
            ->setCDSDATA($cDSDATA)
            ->setCDSIDIS($cDSIDIS)
            ->setMASTERDATA($mASTERDATA)
            ->setTDD($tDD)
            ->setTEMPERATURE($tEMPERATURE)
            ->setCDSLDSREPORT($cDSLDSREPORT);
    }
    /**
     * Get CDSREQ value
     * @return \StructType\CDSREQ|null
     */
    public function getCDSREQ()
    {
        return isset($this->CDSREQ) ? $this->CDSREQ : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCDSREQ method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCDSREQ method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCDSREQForChoiceConstraintsFromSetCDSREQ($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CDSCLAIM',
            'CDSINVOICE',
            'CDSDATA',
            'CDSIDIS',
            'MASTERDATA',
            'TDD',
            'TEMPERATURE',
            'CDSLDSREPORT',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CDSREQ can\'t be set as the property %s is already set. Only one property must be set among these properties: CDSREQ, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CDSREQ value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CDSREQ $cDSREQ
     * @return \StructType\SendRequest
     */
    public function setCDSREQ(\StructType\CDSREQ $cDSREQ = null)
    {
        // validation for constraint: choice(CDSREQ, CDSCLAIM, CDSINVOICE, CDSDATA, CDSIDIS, MASTERDATA, TDD, TEMPERATURE, CDSLDSREPORT)
        if ('' !== ($cDSREQChoiceErrorMessage = self::validateCDSREQForChoiceConstraintsFromSetCDSREQ($cDSREQ))) {
            throw new \InvalidArgumentException($cDSREQChoiceErrorMessage, __LINE__);
        }
        if (is_null($cDSREQ) || (is_array($cDSREQ) && empty($cDSREQ))) {
            unset($this->CDSREQ);
        } else {
            $this->CDSREQ = $cDSREQ;
        }
        return $this;
    }
    /**
     * Get CDSCLAIM value
     * @return \StructType\CDSCLAIM|null
     */
    public function getCDSCLAIM()
    {
        return isset($this->CDSCLAIM) ? $this->CDSCLAIM : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCDSCLAIM method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCDSCLAIM method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCDSCLAIMForChoiceConstraintsFromSetCDSCLAIM($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CDSREQ',
            'CDSINVOICE',
            'CDSDATA',
            'CDSIDIS',
            'MASTERDATA',
            'TDD',
            'TEMPERATURE',
            'CDSLDSREPORT',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CDSCLAIM can\'t be set as the property %s is already set. Only one property must be set among these properties: CDSCLAIM, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CDSCLAIM value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CDSCLAIM $cDSCLAIM
     * @return \StructType\SendRequest
     */
    public function setCDSCLAIM(\StructType\CDSCLAIM $cDSCLAIM = null)
    {
        // validation for constraint: choice(CDSREQ, CDSCLAIM, CDSINVOICE, CDSDATA, CDSIDIS, MASTERDATA, TDD, TEMPERATURE, CDSLDSREPORT)
        if ('' !== ($cDSCLAIMChoiceErrorMessage = self::validateCDSCLAIMForChoiceConstraintsFromSetCDSCLAIM($cDSCLAIM))) {
            throw new \InvalidArgumentException($cDSCLAIMChoiceErrorMessage, __LINE__);
        }
        if (is_null($cDSCLAIM) || (is_array($cDSCLAIM) && empty($cDSCLAIM))) {
            unset($this->CDSCLAIM);
        } else {
            $this->CDSCLAIM = $cDSCLAIM;
        }
        return $this;
    }
    /**
     * Get CDSINVOICE value
     * @return \StructType\CDSINVOICE|null
     */
    public function getCDSINVOICE()
    {
        return isset($this->CDSINVOICE) ? $this->CDSINVOICE : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCDSINVOICE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCDSINVOICE method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCDSINVOICEForChoiceConstraintsFromSetCDSINVOICE($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CDSREQ',
            'CDSCLAIM',
            'CDSDATA',
            'CDSIDIS',
            'MASTERDATA',
            'TDD',
            'TEMPERATURE',
            'CDSLDSREPORT',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CDSINVOICE can\'t be set as the property %s is already set. Only one property must be set among these properties: CDSINVOICE, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CDSINVOICE value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CDSINVOICE $cDSINVOICE
     * @return \StructType\SendRequest
     */
    public function setCDSINVOICE(\StructType\CDSINVOICE $cDSINVOICE = null)
    {
        // validation for constraint: choice(CDSREQ, CDSCLAIM, CDSINVOICE, CDSDATA, CDSIDIS, MASTERDATA, TDD, TEMPERATURE, CDSLDSREPORT)
        if ('' !== ($cDSINVOICEChoiceErrorMessage = self::validateCDSINVOICEForChoiceConstraintsFromSetCDSINVOICE($cDSINVOICE))) {
            throw new \InvalidArgumentException($cDSINVOICEChoiceErrorMessage, __LINE__);
        }
        if (is_null($cDSINVOICE) || (is_array($cDSINVOICE) && empty($cDSINVOICE))) {
            unset($this->CDSINVOICE);
        } else {
            $this->CDSINVOICE = $cDSINVOICE;
        }
        return $this;
    }
    /**
     * Get CDSDATA value
     * @return \StructType\CDSDATA|null
     */
    public function getCDSDATA()
    {
        return isset($this->CDSDATA) ? $this->CDSDATA : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCDSDATA method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCDSDATA method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCDSDATAForChoiceConstraintsFromSetCDSDATA($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CDSREQ',
            'CDSCLAIM',
            'CDSINVOICE',
            'CDSIDIS',
            'MASTERDATA',
            'TDD',
            'TEMPERATURE',
            'CDSLDSREPORT',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CDSDATA can\'t be set as the property %s is already set. Only one property must be set among these properties: CDSDATA, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CDSDATA value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CDSDATA $cDSDATA
     * @return \StructType\SendRequest
     */
    public function setCDSDATA(\StructType\CDSDATA $cDSDATA = null)
    {
        // validation for constraint: choice(CDSREQ, CDSCLAIM, CDSINVOICE, CDSDATA, CDSIDIS, MASTERDATA, TDD, TEMPERATURE, CDSLDSREPORT)
        if ('' !== ($cDSDATAChoiceErrorMessage = self::validateCDSDATAForChoiceConstraintsFromSetCDSDATA($cDSDATA))) {
            throw new \InvalidArgumentException($cDSDATAChoiceErrorMessage, __LINE__);
        }
        if (is_null($cDSDATA) || (is_array($cDSDATA) && empty($cDSDATA))) {
            unset($this->CDSDATA);
        } else {
            $this->CDSDATA = $cDSDATA;
        }
        return $this;
    }
    /**
     * Get CDSIDIS value
     * @return \StructType\CDSIDIS|null
     */
    public function getCDSIDIS()
    {
        return isset($this->CDSIDIS) ? $this->CDSIDIS : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCDSIDIS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCDSIDIS method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCDSIDISForChoiceConstraintsFromSetCDSIDIS($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CDSREQ',
            'CDSCLAIM',
            'CDSINVOICE',
            'CDSDATA',
            'MASTERDATA',
            'TDD',
            'TEMPERATURE',
            'CDSLDSREPORT',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CDSIDIS can\'t be set as the property %s is already set. Only one property must be set among these properties: CDSIDIS, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CDSIDIS value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CDSIDIS $cDSIDIS
     * @return \StructType\SendRequest
     */
    public function setCDSIDIS(\StructType\CDSIDIS $cDSIDIS = null)
    {
        // validation for constraint: choice(CDSREQ, CDSCLAIM, CDSINVOICE, CDSDATA, CDSIDIS, MASTERDATA, TDD, TEMPERATURE, CDSLDSREPORT)
        if ('' !== ($cDSIDISChoiceErrorMessage = self::validateCDSIDISForChoiceConstraintsFromSetCDSIDIS($cDSIDIS))) {
            throw new \InvalidArgumentException($cDSIDISChoiceErrorMessage, __LINE__);
        }
        if (is_null($cDSIDIS) || (is_array($cDSIDIS) && empty($cDSIDIS))) {
            unset($this->CDSIDIS);
        } else {
            $this->CDSIDIS = $cDSIDIS;
        }
        return $this;
    }
    /**
     * Get MASTERDATA value
     * @return \StructType\MASTERDATA|null
     */
    public function getMASTERDATA()
    {
        return isset($this->MASTERDATA) ? $this->MASTERDATA : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMASTERDATA method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMASTERDATA method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMASTERDATAForChoiceConstraintsFromSetMASTERDATA($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CDSREQ',
            'CDSCLAIM',
            'CDSINVOICE',
            'CDSDATA',
            'CDSIDIS',
            'TDD',
            'TEMPERATURE',
            'CDSLDSREPORT',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MASTERDATA can\'t be set as the property %s is already set. Only one property must be set among these properties: MASTERDATA, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MASTERDATA value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MASTERDATA $mASTERDATA
     * @return \StructType\SendRequest
     */
    public function setMASTERDATA(\StructType\MASTERDATA $mASTERDATA = null)
    {
        // validation for constraint: choice(CDSREQ, CDSCLAIM, CDSINVOICE, CDSDATA, CDSIDIS, MASTERDATA, TDD, TEMPERATURE, CDSLDSREPORT)
        if ('' !== ($mASTERDATAChoiceErrorMessage = self::validateMASTERDATAForChoiceConstraintsFromSetMASTERDATA($mASTERDATA))) {
            throw new \InvalidArgumentException($mASTERDATAChoiceErrorMessage, __LINE__);
        }
        if (is_null($mASTERDATA) || (is_array($mASTERDATA) && empty($mASTERDATA))) {
            unset($this->MASTERDATA);
        } else {
            $this->MASTERDATA = $mASTERDATA;
        }
        return $this;
    }
    /**
     * Get TDD value
     * @return \StructType\TDD|null
     */
    public function getTDD()
    {
        return isset($this->TDD) ? $this->TDD : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTDD method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTDD method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTDDForChoiceConstraintsFromSetTDD($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CDSREQ',
            'CDSCLAIM',
            'CDSINVOICE',
            'CDSDATA',
            'CDSIDIS',
            'MASTERDATA',
            'TEMPERATURE',
            'CDSLDSREPORT',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TDD can\'t be set as the property %s is already set. Only one property must be set among these properties: TDD, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TDD value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TDD $tDD
     * @return \StructType\SendRequest
     */
    public function setTDD(\StructType\TDD $tDD = null)
    {
        // validation for constraint: choice(CDSREQ, CDSCLAIM, CDSINVOICE, CDSDATA, CDSIDIS, MASTERDATA, TDD, TEMPERATURE, CDSLDSREPORT)
        if ('' !== ($tDDChoiceErrorMessage = self::validateTDDForChoiceConstraintsFromSetTDD($tDD))) {
            throw new \InvalidArgumentException($tDDChoiceErrorMessage, __LINE__);
        }
        if (is_null($tDD) || (is_array($tDD) && empty($tDD))) {
            unset($this->TDD);
        } else {
            $this->TDD = $tDD;
        }
        return $this;
    }
    /**
     * Get TEMPERATURE value
     * @return \StructType\TEMPERATURE|null
     */
    public function getTEMPERATURE()
    {
        return isset($this->TEMPERATURE) ? $this->TEMPERATURE : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTEMPERATURE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTEMPERATURE method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTEMPERATUREForChoiceConstraintsFromSetTEMPERATURE($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CDSREQ',
            'CDSCLAIM',
            'CDSINVOICE',
            'CDSDATA',
            'CDSIDIS',
            'MASTERDATA',
            'TDD',
            'CDSLDSREPORT',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TEMPERATURE can\'t be set as the property %s is already set. Only one property must be set among these properties: TEMPERATURE, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TEMPERATURE value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TEMPERATURE $tEMPERATURE
     * @return \StructType\SendRequest
     */
    public function setTEMPERATURE(\StructType\TEMPERATURE $tEMPERATURE = null)
    {
        // validation for constraint: choice(CDSREQ, CDSCLAIM, CDSINVOICE, CDSDATA, CDSIDIS, MASTERDATA, TDD, TEMPERATURE, CDSLDSREPORT)
        if ('' !== ($tEMPERATUREChoiceErrorMessage = self::validateTEMPERATUREForChoiceConstraintsFromSetTEMPERATURE($tEMPERATURE))) {
            throw new \InvalidArgumentException($tEMPERATUREChoiceErrorMessage, __LINE__);
        }
        if (is_null($tEMPERATURE) || (is_array($tEMPERATURE) && empty($tEMPERATURE))) {
            unset($this->TEMPERATURE);
        } else {
            $this->TEMPERATURE = $tEMPERATURE;
        }
        return $this;
    }
    /**
     * Get CDSLDSREPORT value
     * @return \StructType\CDSLDSREPORT|null
     */
    public function getCDSLDSREPORT()
    {
        return isset($this->CDSLDSREPORT) ? $this->CDSLDSREPORT : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCDSLDSREPORT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCDSLDSREPORT method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCDSLDSREPORTForChoiceConstraintsFromSetCDSLDSREPORT($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CDSREQ',
            'CDSCLAIM',
            'CDSINVOICE',
            'CDSDATA',
            'CDSIDIS',
            'MASTERDATA',
            'TDD',
            'TEMPERATURE',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CDSLDSREPORT can\'t be set as the property %s is already set. Only one property must be set among these properties: CDSLDSREPORT, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CDSLDSREPORT value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CDSLDSREPORT $cDSLDSREPORT
     * @return \StructType\SendRequest
     */
    public function setCDSLDSREPORT(\StructType\CDSLDSREPORT $cDSLDSREPORT = null)
    {
        // validation for constraint: choice(CDSREQ, CDSCLAIM, CDSINVOICE, CDSDATA, CDSIDIS, MASTERDATA, TDD, TEMPERATURE, CDSLDSREPORT)
        if ('' !== ($cDSLDSREPORTChoiceErrorMessage = self::validateCDSLDSREPORTForChoiceConstraintsFromSetCDSLDSREPORT($cDSLDSREPORT))) {
            throw new \InvalidArgumentException($cDSLDSREPORTChoiceErrorMessage, __LINE__);
        }
        if (is_null($cDSLDSREPORT) || (is_array($cDSLDSREPORT) && empty($cDSLDSREPORT))) {
            unset($this->CDSLDSREPORT);
        } else {
            $this->CDSLDSREPORT = $cDSLDSREPORT;
        }
        return $this;
    }
}
