<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SPKIDataType StructType
 * @subpackage Structs
 */
class SPKIDataType extends AbstractStructBase
{
    /**
     * The SPKISexp
     * @var string
     */
    public $SPKISexp;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for SPKIDataType
     * @uses SPKIDataType::setSPKISexp()
     * @uses SPKIDataType::setAny()
     * @param string $sPKISexp
     * @param \DOMDocument $any
     */
    public function __construct($sPKISexp = null, \DOMDocument $any = null)
    {
        $this
            ->setSPKISexp($sPKISexp)
            ->setAny($any);
    }
    /**
     * Get SPKISexp value
     * @return string|null
     */
    public function getSPKISexp()
    {
        return $this->SPKISexp;
    }
    /**
     * Set SPKISexp value
     * @param string $sPKISexp
     * @return \StructType\SPKIDataType
     */
    public function setSPKISexp($sPKISexp = null)
    {
        // validation for constraint: string
        if (!is_null($sPKISexp) && !is_string($sPKISexp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sPKISexp, true), gettype($sPKISexp)), __LINE__);
        }
        $this->SPKISexp = $sPKISexp;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\SPKIDataType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
