<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResSenderIdentificationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Typ pro identifikaci odesílatele zprávy
 * @subpackage Structs
 */
class ResSenderIdentificationType extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: EIC code type | Typ pro pseudo-EIC kód
     * - base: mp_id
     * - maxLength: 16
     * - minLength: 13
     * - pattern: \c{16}
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The coding_scheme
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $coding_scheme;
    /**
     * The role
     * @var string
     */
    public $role;
    /**
     * Constructor method for ResSenderIdentificationType
     * @uses ResSenderIdentificationType::setId()
     * @uses ResSenderIdentificationType::setCoding_scheme()
     * @uses ResSenderIdentificationType::setRole()
     * @param string $id
     * @param string $coding_scheme
     * @param string $role
     */
    public function __construct($id = null, $coding_scheme = null, $role = null)
    {
        $this
            ->setId($id)
            ->setCoding_scheme($coding_scheme)
            ->setRole($role);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ResSenderIdentificationType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($id) && mb_strlen($id) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(13)
        if (!is_null($id) && mb_strlen($id) < 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 13', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: pattern(\c{16})
        if (!is_null($id) && !preg_match('/\\c{16}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \c{16}', var_export($id, true)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get coding_scheme value
     * @return string
     */
    public function getCoding_scheme()
    {
        return $this->{'coding-scheme'};
    }
    /**
     * Set coding_scheme value
     * @param string $coding_scheme
     * @return \StructType\ResSenderIdentificationType
     */
    public function setCoding_scheme($coding_scheme = null)
    {
        // validation for constraint: string
        if (!is_null($coding_scheme) && !is_string($coding_scheme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coding_scheme, true), gettype($coding_scheme)), __LINE__);
        }
        $this->coding_scheme = $this->{'coding-scheme'} = $coding_scheme;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \StructType\ResSenderIdentificationType
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
}
