<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reason StructType
 * Meta information extracted from the WSDL
 * - documentation: Response (text description in text element, numerical codes in attributes) | Odpověď (v textu elementu je textový popis, v atributech číselné kódy)
 * @subpackage Structs
 */
class Reason extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 8
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $code;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The trade_id
     * Meta information extracted from the WSDL
     * - documentation: Trade id | Číslo obchodu | Typ pro číslo obchodu | Trade number type
     * - base: xsd:string
     * - pattern: [123456789]\d{0,17}
     * - use: optional
     * @var string
     */
    public $trade_id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \d{1,10}
     * - use: optional
     * @var string
     */
    public $version;
    /**
     * The OPM_id
     * Meta information extracted from the WSDL
     * - documentation: PDT id for which the message is relevant | ID OPM, kterého se zpráva týká | Typ pro OPM (EAN, EIC) | POD type (EAN, EIC)
     * - base: xsd:string
     * - maxLength: 18
     * - minLength: 16
     * - pattern: \d{18}
     * @var string
     */
    public $OPM_id;
    /**
     * The block_id
     * Meta information extracted from the WSDL
     * - documentation: Id of fault logical block | Id chybného logického bloku zprávy
     * @var int
     */
    public $block_id;
    /**
     * The result_code
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 6
     * - use: optional
     * @var string
     */
    public $result_code;
    /**
     * Constructor method for Reason
     * @uses Reason::setCode()
     * @uses Reason::setType()
     * @uses Reason::set_()
     * @uses Reason::setTrade_id()
     * @uses Reason::setVersion()
     * @uses Reason::setOPM_id()
     * @uses Reason::setBlock_id()
     * @uses Reason::setResult_code()
     * @param string $code
     * @param string $type
     * @param string $_
     * @param string $trade_id
     * @param string $version
     * @param string $oPM_id
     * @param int $block_id
     * @param string $result_code
     */
    public function __construct($code = null, $type = null, $_ = null, $trade_id = null, $version = null, $oPM_id = null, $block_id = null, $result_code = null)
    {
        $this
            ->setCode($code)
            ->setType($type)
            ->set_($_)
            ->setTrade_id($trade_id)
            ->setVersion($version)
            ->setOPM_id($oPM_id)
            ->setBlock_id($block_id)
            ->setResult_code($result_code);
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Reason
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($code) && mb_strlen($code) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Reason
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\Reason
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get trade_id value
     * @return string|null
     */
    public function getTrade_id()
    {
        return $this->{'trade-id'};
    }
    /**
     * Set trade_id value
     * @param string $trade_id
     * @return \StructType\Reason
     */
    public function setTrade_id($trade_id = null)
    {
        // validation for constraint: string
        if (!is_null($trade_id) && !is_string($trade_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trade_id, true), gettype($trade_id)), __LINE__);
        }
        // validation for constraint: pattern([123456789]\d{0,17})
        if (!is_null($trade_id) && !preg_match('/[123456789]\\d{0,17}/', $trade_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [123456789]\d{0,17}', var_export($trade_id, true)), __LINE__);
        }
        $this->trade_id = $this->{'trade-id'} = $trade_id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Reason
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: pattern(\d{1,10})
        if (!is_null($version) && !preg_match('/\\d{1,10}/', $version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{1,10}', var_export($version, true)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get OPM_id value
     * @return string|null
     */
    public function getOPM_id()
    {
        return $this->{'OPM-id'};
    }
    /**
     * Set OPM_id value
     * @param string $oPM_id
     * @return \StructType\Reason
     */
    public function setOPM_id($oPM_id = null)
    {
        // validation for constraint: string
        if (!is_null($oPM_id) && !is_string($oPM_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oPM_id, true), gettype($oPM_id)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($oPM_id) && mb_strlen($oPM_id) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($oPM_id)), __LINE__);
        }
        // validation for constraint: minLength(16)
        if (!is_null($oPM_id) && mb_strlen($oPM_id) < 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 16', mb_strlen($oPM_id)), __LINE__);
        }
        // validation for constraint: pattern(\d{18})
        if (!is_null($oPM_id) && !preg_match('/\\d{18}/', $oPM_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{18}', var_export($oPM_id, true)), __LINE__);
        }
        $this->OPM_id = $this->{'OPM-id'} = $oPM_id;
        return $this;
    }
    /**
     * Get block_id value
     * @return int|null
     */
    public function getBlock_id()
    {
        return $this->{'block-id'};
    }
    /**
     * Set block_id value
     * @param int $block_id
     * @return \StructType\Reason
     */
    public function setBlock_id($block_id = null)
    {
        // validation for constraint: int
        if (!is_null($block_id) && !(is_int($block_id) || ctype_digit($block_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($block_id, true), gettype($block_id)), __LINE__);
        }
        $this->block_id = $this->{'block-id'} = $block_id;
        return $this;
    }
    /**
     * Get result_code value
     * @return string|null
     */
    public function getResult_code()
    {
        return $this->{'result-code'};
    }
    /**
     * Set result_code value
     * @param string $result_code
     * @return \StructType\Reason
     */
    public function setResult_code($result_code = null)
    {
        // validation for constraint: string
        if (!is_null($result_code) && !is_string($result_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result_code, true), gettype($result_code)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($result_code) && mb_strlen($result_code) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($result_code)), __LINE__);
        }
        $this->result_code = $this->{'result-code'} = $result_code;
        return $this;
    }
}
