<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Profile StructType
 * Meta information extracted from the WSDL
 * - documentation: Temperature profile | Teplotní profil
 * @subpackage Structs
 */
class Profile extends AbstractStructBase
{
    /**
     * The temp_area
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - use: required
     * @var string
     */
    public $temp_area;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Data[]
     */
    public $Data;
    /**
     * The value_type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $value_type;
    /**
     * The profile_version
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $profile_version;
    /**
     * Constructor method for Profile
     * @uses Profile::setTemp_area()
     * @uses Profile::setData()
     * @uses Profile::setValue_type()
     * @uses Profile::setProfile_version()
     * @param string $temp_area
     * @param \StructType\Data[] $data
     * @param string $value_type
     * @param string $profile_version
     */
    public function __construct($temp_area = null, array $data = array(), $value_type = null, $profile_version = null)
    {
        $this
            ->setTemp_area($temp_area)
            ->setData($data)
            ->setValue_type($value_type)
            ->setProfile_version($profile_version);
    }
    /**
     * Get temp_area value
     * @return string
     */
    public function getTemp_area()
    {
        return $this->{'temp-area'};
    }
    /**
     * Set temp_area value
     * @param string $temp_area
     * @return \StructType\Profile
     */
    public function setTemp_area($temp_area = null)
    {
        // validation for constraint: string
        if (!is_null($temp_area) && !is_string($temp_area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temp_area, true), gettype($temp_area)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($temp_area) && mb_strlen($temp_area) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($temp_area)), __LINE__);
        }
        $this->temp_area = $this->{'temp-area'} = $temp_area;
        return $this;
    }
    /**
     * Get Data value
     * @return \StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * This method is responsible for validating the values passed to the setData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDataForArrayConstraintsFromSetData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $profileDataItem) {
            // validation for constraint: itemType
            if (!$profileDataItem instanceof \StructType\Data) {
                $invalidValues[] = is_object($profileDataItem) ? get_class($profileDataItem) : sprintf('%s(%s)', gettype($profileDataItem), var_export($profileDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Data property can only contain items of type \StructType\Data, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data[] $data
     * @return \StructType\Profile
     */
    public function setData(array $data = array())
    {
        // validation for constraint: array
        if ('' !== ($dataArrayErrorMessage = self::validateDataForArrayConstraintsFromSetData($data))) {
            throw new \InvalidArgumentException($dataArrayErrorMessage, __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Data $item
     * @return \StructType\Profile
     */
    public function addToData(\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of type \StructType\Data, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get value_type value
     * @return string|null
     */
    public function getValue_type()
    {
        return $this->{'value-type'};
    }
    /**
     * Set value_type value
     * @param string $value_type
     * @return \StructType\Profile
     */
    public function setValue_type($value_type = null)
    {
        // validation for constraint: string
        if (!is_null($value_type) && !is_string($value_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value_type, true), gettype($value_type)), __LINE__);
        }
        $this->value_type = $this->{'value-type'} = $value_type;
        return $this;
    }
    /**
     * Get profile_version value
     * @return string|null
     */
    public function getProfile_version()
    {
        return $this->{'profile-version'};
    }
    /**
     * Set profile_version value
     * @param string $profile_version
     * @return \StructType\Profile
     */
    public function setProfile_version($profile_version = null)
    {
        // validation for constraint: string
        if (!is_null($profile_version) && !is_string($profile_version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profile_version, true), gettype($profile_version)), __LINE__);
        }
        $this->profile_version = $this->{'profile-version'} = $profile_version;
        return $this;
    }
}
