<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pmax_type StructType
 * Meta information extracted from the WSDL
 * - documentation: Type of Pmax element | Typ pro element Pmax
 * @subpackage Structs
 */
class Pmax_type extends AbstractStructBase
{
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Date and time of period | Datum a čas periody | Datum a čas s nepovinnými sekundami (formát YYYY-MM-DDThh:mm nebo YYYY-MM-DDThh:mm:ss) | Date and time - seconds are optional (format YYYY-MM-DDThh:mm or YYYY-MM-DDThh:mm:ss)
     * - base: xsd:string
     * - pattern: \d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?
     * - use: required
     * @var string
     */
    public $date_time;
    /**
     * The qty
     * Meta information extracted from the WSDL
     * - documentation: Max. power input (Pmax) / return delivery (Preact) | Max. příkon (Pmax) / zpětná dodávka (Preact) | Celé číslo | Integer
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{0})?
     * - use: required
     * @var string
     */
    public $qty;
    /**
     * Constructor method for pmax_type
     * @uses Pmax_type::setDate_time()
     * @uses Pmax_type::setQty()
     * @param string $date_time
     * @param string $qty
     */
    public function __construct($date_time = null, $qty = null)
    {
        $this
            ->setDate_time($date_time)
            ->setQty($qty);
    }
    /**
     * Get date_time value
     * @return string
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\Pmax_type
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?)
        if (!is_null($date_time) && !preg_match('/\\d{4}-\\d\\d-\\d\\dT\\d\\d:\\d\\d(:\\d\\d)?/', $date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}-\d\d-\d\dT\d\d:\d\d(:\d\d)?', var_export($date_time, true)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
    /**
     * Get qty value
     * @return string
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param string $qty
     * @return \StructType\Pmax_type
     */
    public function setQty($qty = null)
    {
        // validation for constraint: string
        if (!is_null($qty) && !is_string($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qty) && mb_strlen($qty) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qty)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{0})?)
        if (!is_null($qty) && !preg_match('/-?\\d+(\\.\\d{0})?/', $qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{0})?', var_export($qty, true)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
}
