<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OPM StructType
 * Meta information extracted from the WSDL
 * - documentation: Name of PDT (max 60 characters) | Název OPM (max 60 znaků) | PDT | OPM
 * @subpackage Structs
 */
class OPM extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: EAN18 - Locality (PDT) identification | EAN18 identifikující lokalitu (OPM) | EAN type | Typ pro EAN | Typ pro EAN 18 znaků | EAN 18 type
     * - base: ean
     * - length: 18
     * - pattern: \d+
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The inv_per_from
     * Meta information extracted from the WSDL
     * - documentation: Beginning of invoicing period (for status NEF in DGI RCS interval from) | Počátek fakturačního období (pro status NEF u DUF MO interval od)
     * - use: required
     * @var string
     */
    public $inv_per_from;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $status;
    /**
     * The ext_ui
     * Meta information extracted from the WSDL
     * - documentation: ID PDT (EAN 18) | ID OPM (EAN 18) | EAN type | Typ pro EAN | Typ pro EAN 18 znaků | EAN 18 type
     * - base: ean
     * - length: 18
     * - pattern: \d+
     * - use: required
     * @var string
     */
    public $ext_ui;
    /**
     * The Pmax
     * Meta information extracted from the WSDL
     * - documentation: Max. power input | Max. příkon
     * - choice: Pmax | PmaxNT | ResCap | SysServices | Ereact | MP | Price | DataMO | PmaxMO | METER | PriceMO
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Pmax_type
     */
    public $Pmax;
    /**
     * The PmaxNT
     * Meta information extracted from the WSDL
     * - documentation: Max. power input in LT | Max. příkon v NT
     * - choice: Pmax | PmaxNT | ResCap | SysServices | Ereact | MP | Price | DataMO | PmaxMO | METER | PriceMO
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Pmax_type
     */
    public $PmaxNT;
    /**
     * The ResCap
     * Meta information extracted from the WSDL
     * - choice: Pmax | PmaxNT | ResCap | SysServices | Ereact | MP | Price | DataMO | PmaxMO | METER | PriceMO
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResCap
     */
    public $ResCap;
    /**
     * The SysServices
     * Meta information extracted from the WSDL
     * - choice: Pmax | PmaxNT | ResCap | SysServices | Ereact | MP | Price | DataMO | PmaxMO | METER | PriceMO
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SysServices
     */
    public $SysServices;
    /**
     * The Ereact
     * Meta information extracted from the WSDL
     * - documentation: Reactive energy | Jalová energie
     * - choice: Pmax | PmaxNT | ResCap | SysServices | Ereact | MP | Price | DataMO | PmaxMO | METER | PriceMO
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Ereact_type
     */
    public $Ereact;
    /**
     * The MP
     * Meta information extracted from the WSDL
     * - choice: Pmax | PmaxNT | ResCap | SysServices | Ereact | MP | Price | DataMO | PmaxMO | METER | PriceMO
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MP[]
     */
    public $MP;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - choice: Pmax | PmaxNT | ResCap | SysServices | Ereact | MP | Price | DataMO | PmaxMO | METER | PriceMO
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Price[]
     */
    public $Price;
    /**
     * The DataMO
     * Meta information extracted from the WSDL
     * - choice: Pmax | PmaxNT | ResCap | SysServices | Ereact | MP | Price | DataMO | PmaxMO | METER | PriceMO
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DataMO
     */
    public $DataMO;
    /**
     * The PmaxMO
     * Meta information extracted from the WSDL
     * - documentation: Max. power input, since 2016 not used | Max. příkon, od 2016 nepoužívané
     * - choice: Pmax | PmaxNT | ResCap | SysServices | Ereact | MP | Price | DataMO | PmaxMO | METER | PriceMO
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Pmax_type
     */
    public $PmaxMO;
    /**
     * The METER
     * Meta information extracted from the WSDL
     * - choice: Pmax | PmaxNT | ResCap | SysServices | Ereact | MP | Price | DataMO | PmaxMO | METER | PriceMO
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\METER[]
     */
    public $METER;
    /**
     * The PriceMO
     * Meta information extracted from the WSDL
     * - choice: Pmax | PmaxNT | ResCap | SysServices | Ereact | MP | Price | DataMO | PmaxMO | METER | PriceMO
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PriceMO[]
     */
    public $PriceMO;
    /**
     * The inv_id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - use: optional
     * @var string
     */
    public $inv_id;
    /**
     * The qty
     * Meta information extracted from the WSDL
     * - documentation: Množství | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $qty;
    /**
     * The qty_VT
     * Meta information extracted from the WSDL
     * - documentation: Sum of energy in HT [kWh] (use from 1.1.2016) | Suma práce ve VT [kWh] (používané od 1.1.2016) | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential
     * form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $qty_VT;
    /**
     * The qty_NT
     * Meta information extracted from the WSDL
     * - documentation: Sum of energy in LT [kWh], since 2016 required (use from 1.1.2016) | Suma práce ve NT [kWh], od 2016 povinný (používané od 1.1.2016) | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2
     * decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $qty_NT;
    /**
     * The inv_per_to
     * Meta information extracted from the WSDL
     * - documentation: End of invoicing period (for status NEF in DGI RCS interval to) | Konec fakturačního období (pro status NEF u DUF MO interval do)
     * - use: optional
     * @var string
     */
    public $inv_per_to;
    /**
     * The contract_type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $contract_type;
    /**
     * The supplyDS_qty
     * Meta information extracted from the WSDL
     * - documentation: DS supply - quantity | Dodávka do DS - množství | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $supplyDS_qty;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $version;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The opm_main
     * Meta information extracted from the WSDL
     * - documentation: Main PDT | Hlavní OPM | EAN type | Typ pro EAN | Typ pro EAN 18 znaků | EAN 18 type
     * - base: ean
     * - length: 18
     * - pattern: \d+
     * - use: optional
     * @var string
     */
    public $opm_main;
    /**
     * The date_from
     * Meta information extracted from the WSDL
     * - documentation: Valid from | Platnost od
     * - use: optional
     * @var string
     */
    public $date_from;
    /**
     * The date_to
     * Meta information extracted from the WSDL
     * - documentation: Valid to | Platnost do
     * - use: optional
     * @var string
     */
    public $date_to;
    /**
     * The anlart
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $anlart;
    /**
     * The spebene
     * Meta information extracted from the WSDL
     * - documentation: Voltage level 1 | Napěťová úroveň 1
     * - use: optional
     * @var string
     */
    public $spebene;
    /**
     * The island
     * Meta information extracted from the WSDL
     * - default: CIR
     * - use: optional
     * @var string
     */
    public $island;
    /**
     * The pps
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $pps;
    /**
     * The typm
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $typm;
    /**
     * The typ_pm
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $typ_pm;
    /**
     * The typsrc
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $typsrc;
    /**
     * The power
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \d+(\.\d{1,7})?
     * - use: optional
     * @var string
     */
    public $power;
    /**
     * The grid_id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \d{1,10}
     * - use: optional
     * @var string
     */
    public $grid_id;
    /**
     * The partner
     * Meta information extracted from the WSDL
     * - documentation: PDT owner (EAN 13 or EAN 18) | Majitel OPM (EAN 13 nebo EAN 18) | Typ pro EAN 13 - 18 znaků | EAN 13 - 18 type
     * - base: xsd:string
     * - pattern: \d{13}(\d{5})?
     * - use: optional
     * @var string
     */
    public $partner;
    /**
     * The next_grid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \d{1,10}
     * - use: optional
     * @var string
     */
    public $next_grid;
    /**
     * The ps_pmd
     * Meta information extracted from the WSDL
     * - documentation: Metered data provider | Poskytovatel měřených dat | EAN type | Typ pro EAN | Typ pro EAN 13 znaků | EAN 13 type
     * - base: ean
     * - length: 13
     * - pattern: \d+
     * - use: optional
     * @var string
     */
    public $ps_pmd;
    /**
     * The ps_dod
     * Meta information extracted from the WSDL
     * - documentation: Supplier | Dodavatel | EAN type | Typ pro EAN | Typ pro EAN 13 znaků | EAN 13 type
     * - base: ean
     * - length: 13
     * - pattern: \d+
     * - use: optional
     * @var string
     */
    public $ps_dod;
    /**
     * The ps_pps
     * Meta information extracted from the WSDL
     * - documentation: Ancillary services provider | Poskytovatel podpůrných služeb | EAN type | Typ pro EAN | Typ pro EAN 13 znaků | EAN 13 type
     * - base: ean
     * - length: 13
     * - pattern: \d+
     * - use: optional
     * @var string
     */
    public $ps_pps;
    /**
     * The ps_sz
     * Meta information extracted from the WSDL
     * - documentation: Subject of settlement | Subjekt zúčtování | EAN type | Typ pro EAN | Typ pro EAN 13 znaků | EAN 13 type
     * - base: ean
     * - length: 13
     * - pattern: \d+
     * - use: optional
     * @var string
     */
    public $ps_sz;
    /**
     * The ps_poz
     * Meta information extracted from the WSDL
     * - documentation: Observer | Pozorovatel | EAN type | Typ pro EAN | Typ pro EAN 13 znaků | EAN 13 type
     * - base: ean
     * - length: 13
     * - pattern: \d+
     * - use: optional
     * @var string
     */
    public $ps_poz;
    /**
     * The sopm
     * Meta information extracted from the WSDL
     * - documentation: Adjacent OPM EAN (case of transfer point) | EAN sousedního OPM (u předávacího místa mezi soustavami) | EAN type | Typ pro EAN | Typ pro EAN 18 znaků | EAN 18 type
     * - base: ean
     * - length: 18
     * - pattern: \d+
     * - use: optional
     * @var string
     */
    public $sopm;
    /**
     * The uob
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $uob;
    /**
     * The est_cons
     * Meta information extracted from the WSDL
     * - documentation: Annual consumption estimation | Odhad roční spotřeby
     * - use: optional
     * @var string
     */
    public $est_cons;
    /**
     * The temp_area
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - use: optional
     * @var string
     */
    public $temp_area;
    /**
     * The tdd_class
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - use: optional
     * @var string
     */
    public $tdd_class;
    /**
     * The foreign
     * Meta information extracted from the WSDL
     * - documentation: Flag - PDT is import/export | Příznak, jestli OPM je import/export
     * - use: optional
     * @var bool
     */
    public $foreign;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 40
     * - use: optional
     * @var string
     */
    public $city;
    /**
     * The post_code
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 5
     * - use: optional
     * @var string
     */
    public $post_code;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - use: optional
     * @var string
     */
    public $street;
    /**
     * The house_num
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - use: optional
     * @var string
     */
    public $house_num;
    /**
     * The renew_share
     * Meta information extracted from the WSDL
     * - documentation: Portion of renewable energy in total generation | Podíl obnovitelné energie na celkové výrobě
     * - use: optional
     * @var string
     */
    public $renew_share;
    /**
     * The combs_share
     * Meta information extracted from the WSDL
     * - documentation: Portion of energy in cogeneration | Procento vyrobené v kogeneraci
     * - use: optional
     * @var string
     */
    public $combs_share;
    /**
     * The mrsend_susp
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $mrsend_susp;
    /**
     * The dpi_active
     * Meta information extracted from the WSDL
     * - documentation: Attribute SLR active/inactive - only for messages going out of CDS | Atribut DPI aktivní/neaktivní - pouze pro výstupní zprávy z CDS
     * - use: optional
     * @var bool
     */
    public $dpi_active;
    /**
     * The info_text
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 512
     * - use: optional
     * @var string
     */
    public $info_text;
    /**
     * The duf_type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $duf_type;
    /**
     * The duf_freq
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $duf_freq;
    /**
     * The mr_first
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $mr_first;
    /**
     * The disc_reason
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $disc_reason;
    /**
     * The Qty_VT
     * Meta information extracted from the WSDL
     * - documentation: Meter reading HT | Odečet VT
     * - use: optional
     * @var string
     */
    public $Qty_VT;
    /**
     * The Qty_NT
     * Meta information extracted from the WSDL
     * - documentation: Meter reading LT | Odečet NT
     * - use: optional
     * @var string
     */
    public $Qty_NT;
    /**
     * The opm_sum
     * Meta information extracted from the WSDL
     * - documentation: Summary PDT identification - in case of PDT registration singled out of summary PDT in given grid. | Identifikace sumárního OPM pokud jde o registraci OPM, které se vyčleňuje ze sumárního OPM dané síťě. | EAN type | Typ
     * pro EAN | Typ pro EAN 18 znaků | EAN 18 type
     * - base: ean
     * - length: 18
     * - pattern: \d+
     * - use: optional
     * @var string
     */
    public $opm_sum;
    /**
     * The change_to_past
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $change_to_past;
    /**
     * The comp_serv
     * @var string
     */
    public $comp_serv;
    /**
     * The aggr_inv
     * @var string
     */
    public $aggr_inv;
    /**
     * The sz_implicit
     * Meta information extracted from the WSDL
     * - documentation: SofS assigned implicitly | Implicitně přiřazený SZ
     * - use: optional
     * @var bool
     */
    public $sz_implicit;
    /**
     * The res_power
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - totalDigits: 15
     * - use: optional
     * @var float
     */
    public $res_power;
    /**
     * The supp_block_power
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \d+(\.\d{1,7})?
     * - use: optional
     * @var string
     */
    public $supp_block_power;
    /**
     * The supp_blocks
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - pattern: \d+
     * - use: optional
     * @var string
     */
    public $supp_blocks;
    /**
     * The num_phase
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $num_phase;
    /**
     * The cir_breaker
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - minInclusive: 0
     * - totalDigits: 6
     * - use: optional
     * @var float
     */
    public $cir_breaker;
    /**
     * The monitor_code
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - use: optional
     * @var string
     */
    public $monitor_code;
    /**
     * The monitor_to
     * Meta information extracted from the WSDL
     * - documentation: Valid to | Datum do
     * - use: optional
     * @var string
     */
    public $monitor_to;
    /**
     * The monitor_from
     * Meta information extracted from the WSDL
     * - documentation: Valid from | Datum od
     * - use: optional
     * @var string
     */
    public $monitor_from;
    /**
     * The dist_rate_type
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $dist_rate_type;
    /**
     * The micro_source
     * Meta information extracted from the WSDL
     * - documentation: Micro source/Production under 10 kW | Mikrozdroj/Výroba do 10 kW
     * - use: optional
     * @var bool
     */
    public $micro_source;
    /**
     * The planned
     * Meta information extracted from the WSDL
     * - documentation: Planned disconnection | Plánované odpojení
     * - use: optional
     * @var bool
     */
    public $planned;
    /**
     * The cons_categ
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $cons_categ;
    /**
     * Constructor method for OPM
     * @uses OPM::setId()
     * @uses OPM::setInv_per_from()
     * @uses OPM::setStatus()
     * @uses OPM::setExt_ui()
     * @uses OPM::setPmax()
     * @uses OPM::setPmaxNT()
     * @uses OPM::setResCap()
     * @uses OPM::setSysServices()
     * @uses OPM::setEreact()
     * @uses OPM::setMP()
     * @uses OPM::setPrice()
     * @uses OPM::setDataMO()
     * @uses OPM::setPmaxMO()
     * @uses OPM::setMETER()
     * @uses OPM::setPriceMO()
     * @uses OPM::setInv_id()
     * @uses OPM::setQty()
     * @uses OPM::setQty_VT()
     * @uses OPM::setQty_NT()
     * @uses OPM::setInv_per_to()
     * @uses OPM::setContract_type()
     * @uses OPM::setSupplyDS_qty()
     * @uses OPM::setVersion()
     * @uses OPM::set_()
     * @uses OPM::setOpm_main()
     * @uses OPM::setDate_from()
     * @uses OPM::setDate_to()
     * @uses OPM::setAnlart()
     * @uses OPM::setSpebene()
     * @uses OPM::setIsland()
     * @uses OPM::setPps()
     * @uses OPM::setTypm()
     * @uses OPM::setTyp_pm()
     * @uses OPM::setTypsrc()
     * @uses OPM::setPower()
     * @uses OPM::setGrid_id()
     * @uses OPM::setPartner()
     * @uses OPM::setNext_grid()
     * @uses OPM::setPs_pmd()
     * @uses OPM::setPs_dod()
     * @uses OPM::setPs_pps()
     * @uses OPM::setPs_sz()
     * @uses OPM::setPs_poz()
     * @uses OPM::setSopm()
     * @uses OPM::setUob()
     * @uses OPM::setEst_cons()
     * @uses OPM::setTemp_area()
     * @uses OPM::setTdd_class()
     * @uses OPM::setForeign()
     * @uses OPM::setCity()
     * @uses OPM::setPost_code()
     * @uses OPM::setStreet()
     * @uses OPM::setHouse_num()
     * @uses OPM::setRenew_share()
     * @uses OPM::setCombs_share()
     * @uses OPM::setMrsend_susp()
     * @uses OPM::setDpi_active()
     * @uses OPM::setInfo_text()
     * @uses OPM::setDuf_type()
     * @uses OPM::setDuf_freq()
     * @uses OPM::setMr_first()
     * @uses OPM::setDisc_reason()
     * @uses OPM::setQty_VT_1()
     * @uses OPM::setQty_NT_1()
     * @uses OPM::setOpm_sum()
     * @uses OPM::setChange_to_past()
     * @uses OPM::setComp_serv()
     * @uses OPM::setAggr_inv()
     * @uses OPM::setSz_implicit()
     * @uses OPM::setRes_power()
     * @uses OPM::setSupp_block_power()
     * @uses OPM::setSupp_blocks()
     * @uses OPM::setNum_phase()
     * @uses OPM::setCir_breaker()
     * @uses OPM::setMonitor_code()
     * @uses OPM::setMonitor_to()
     * @uses OPM::setMonitor_from()
     * @uses OPM::setDist_rate_type()
     * @uses OPM::setMicro_source()
     * @uses OPM::setPlanned()
     * @uses OPM::setCons_categ()
     * @param string $id
     * @param string $inv_per_from
     * @param string $status
     * @param string $ext_ui
     * @param \StructType\Pmax_type $pmax
     * @param \StructType\Pmax_type $pmaxNT
     * @param \StructType\ResCap $resCap
     * @param \StructType\SysServices $sysServices
     * @param \StructType\Ereact_type $ereact
     * @param \StructType\MP[] $mP
     * @param \StructType\Price[] $price
     * @param \StructType\DataMO $dataMO
     * @param \StructType\Pmax_type $pmaxMO
     * @param \StructType\METER[] $mETER
     * @param \StructType\PriceMO[] $priceMO
     * @param string $inv_id
     * @param string $qty
     * @param string $qty_VT
     * @param string $qty_NT
     * @param string $inv_per_to
     * @param string $contract_type
     * @param string $supplyDS_qty
     * @param string $version
     * @param string $_
     * @param string $opm_main
     * @param string $date_from
     * @param string $date_to
     * @param string $anlart
     * @param string $spebene
     * @param string $island
     * @param string $pps
     * @param string $typm
     * @param string $typ_pm
     * @param string $typsrc
     * @param string $power
     * @param string $grid_id
     * @param string $partner
     * @param string $next_grid
     * @param string $ps_pmd
     * @param string $ps_dod
     * @param string $ps_pps
     * @param string $ps_sz
     * @param string $ps_poz
     * @param string $sopm
     * @param string $uob
     * @param string $est_cons
     * @param string $temp_area
     * @param string $tdd_class
     * @param bool $foreign
     * @param string $city
     * @param string $post_code
     * @param string $street
     * @param string $house_num
     * @param string $renew_share
     * @param string $combs_share
     * @param string $mrsend_susp
     * @param bool $dpi_active
     * @param string $info_text
     * @param string $duf_type
     * @param string $duf_freq
     * @param string $mr_first
     * @param string $disc_reason
     * @param string $qty_VT
     * @param string $qty_NT
     * @param string $opm_sum
     * @param string $change_to_past
     * @param string $comp_serv
     * @param string $aggr_inv
     * @param bool $sz_implicit
     * @param float $res_power
     * @param string $supp_block_power
     * @param string $supp_blocks
     * @param string $num_phase
     * @param float $cir_breaker
     * @param string $monitor_code
     * @param string $monitor_to
     * @param string $monitor_from
     * @param string $dist_rate_type
     * @param bool $micro_source
     * @param bool $planned
     * @param string $cons_categ
     */
    public function __construct($id = null, $inv_per_from = null, $status = null, $ext_ui = null, \StructType\Pmax_type $pmax = null, \StructType\Pmax_type $pmaxNT = null, \StructType\ResCap $resCap = null, \StructType\SysServices $sysServices = null, \StructType\Ereact_type $ereact = null, array $mP = array(), array $price = array(), \StructType\DataMO $dataMO = null, \StructType\Pmax_type $pmaxMO = null, array $mETER = array(), array $priceMO = array(), $inv_id = null, $qty = null, $qty_VT = null, $qty_NT = null, $inv_per_to = null, $contract_type = null, $supplyDS_qty = null, $version = null, $_ = null, $opm_main = null, $date_from = null, $date_to = null, $anlart = null, $spebene = null, $island = 'CIR', $pps = null, $typm = null, $typ_pm = null, $typsrc = null, $power = null, $grid_id = null, $partner = null, $next_grid = null, $ps_pmd = null, $ps_dod = null, $ps_pps = null, $ps_sz = null, $ps_poz = null, $sopm = null, $uob = null, $est_cons = null, $temp_area = null, $tdd_class = null, $foreign = null, $city = null, $post_code = null, $street = null, $house_num = null, $renew_share = null, $combs_share = null, $mrsend_susp = null, $dpi_active = null, $info_text = null, $duf_type = null, $duf_freq = null, $mr_first = null, $disc_reason = null, $qty_VT_1 = null, $qty_NT_1 = null, $opm_sum = null, $change_to_past = null, $comp_serv = null, $aggr_inv = null, $sz_implicit = null, $res_power = null, $supp_block_power = null, $supp_blocks = null, $num_phase = null, $cir_breaker = null, $monitor_code = null, $monitor_to = null, $monitor_from = null, $dist_rate_type = null, $micro_source = null, $planned = null, $cons_categ = null)
    {
        $this
            ->setId($id)
            ->setInv_per_from($inv_per_from)
            ->setStatus($status)
            ->setExt_ui($ext_ui)
            ->setPmax($pmax)
            ->setPmaxNT($pmaxNT)
            ->setResCap($resCap)
            ->setSysServices($sysServices)
            ->setEreact($ereact)
            ->setMP($mP)
            ->setPrice($price)
            ->setDataMO($dataMO)
            ->setPmaxMO($pmaxMO)
            ->setMETER($mETER)
            ->setPriceMO($priceMO)
            ->setInv_id($inv_id)
            ->setQty($qty)
            ->setQty_VT($qty_VT)
            ->setQty_NT($qty_NT)
            ->setInv_per_to($inv_per_to)
            ->setContract_type($contract_type)
            ->setSupplyDS_qty($supplyDS_qty)
            ->setVersion($version)
            ->set_($_)
            ->setOpm_main($opm_main)
            ->setDate_from($date_from)
            ->setDate_to($date_to)
            ->setAnlart($anlart)
            ->setSpebene($spebene)
            ->setIsland($island)
            ->setPps($pps)
            ->setTypm($typm)
            ->setTyp_pm($typ_pm)
            ->setTypsrc($typsrc)
            ->setPower($power)
            ->setGrid_id($grid_id)
            ->setPartner($partner)
            ->setNext_grid($next_grid)
            ->setPs_pmd($ps_pmd)
            ->setPs_dod($ps_dod)
            ->setPs_pps($ps_pps)
            ->setPs_sz($ps_sz)
            ->setPs_poz($ps_poz)
            ->setSopm($sopm)
            ->setUob($uob)
            ->setEst_cons($est_cons)
            ->setTemp_area($temp_area)
            ->setTdd_class($tdd_class)
            ->setForeign($foreign)
            ->setCity($city)
            ->setPost_code($post_code)
            ->setStreet($street)
            ->setHouse_num($house_num)
            ->setRenew_share($renew_share)
            ->setCombs_share($combs_share)
            ->setMrsend_susp($mrsend_susp)
            ->setDpi_active($dpi_active)
            ->setInfo_text($info_text)
            ->setDuf_type($duf_type)
            ->setDuf_freq($duf_freq)
            ->setMr_first($mr_first)
            ->setDisc_reason($disc_reason)
            ->setQty_VT_1($qty_VT_1)
            ->setQty_NT_1($qty_NT_1)
            ->setOpm_sum($opm_sum)
            ->setChange_to_past($change_to_past)
            ->setComp_serv($comp_serv)
            ->setAggr_inv($aggr_inv)
            ->setSz_implicit($sz_implicit)
            ->setRes_power($res_power)
            ->setSupp_block_power($supp_block_power)
            ->setSupp_blocks($supp_blocks)
            ->setNum_phase($num_phase)
            ->setCir_breaker($cir_breaker)
            ->setMonitor_code($monitor_code)
            ->setMonitor_to($monitor_to)
            ->setMonitor_from($monitor_from)
            ->setDist_rate_type($dist_rate_type)
            ->setMicro_source($micro_source)
            ->setPlanned($planned)
            ->setCons_categ($cons_categ);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\OPM
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($id) && mb_strlen($id) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($id) && !preg_match('/\\d+/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($id, true)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get inv_per_from value
     * @return string
     */
    public function getInv_per_from()
    {
        return $this->{'inv-per-from'};
    }
    /**
     * Set inv_per_from value
     * @param string $inv_per_from
     * @return \StructType\OPM
     */
    public function setInv_per_from($inv_per_from = null)
    {
        // validation for constraint: string
        if (!is_null($inv_per_from) && !is_string($inv_per_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_per_from, true), gettype($inv_per_from)), __LINE__);
        }
        $this->inv_per_from = $this->{'inv-per-from'} = $inv_per_from;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\OPM
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get ext_ui value
     * @return string
     */
    public function getExt_ui()
    {
        return $this->{'ext-ui'};
    }
    /**
     * Set ext_ui value
     * @param string $ext_ui
     * @return \StructType\OPM
     */
    public function setExt_ui($ext_ui = null)
    {
        // validation for constraint: string
        if (!is_null($ext_ui) && !is_string($ext_ui)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ext_ui, true), gettype($ext_ui)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ext_ui) && mb_strlen($ext_ui) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ext_ui)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($ext_ui) && !preg_match('/\\d+/', $ext_ui)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($ext_ui, true)), __LINE__);
        }
        $this->ext_ui = $this->{'ext-ui'} = $ext_ui;
        return $this;
    }
    /**
     * Get Pmax value
     * @return \StructType\Pmax_type|null
     */
    public function getPmax()
    {
        return isset($this->Pmax) ? $this->Pmax : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPmax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPmax method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePmaxForChoiceConstraintsFromSetPmax($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PmaxNT',
            'ResCap',
            'SysServices',
            'Ereact',
            'MP',
            'Price',
            'DataMO',
            'PmaxMO',
            'METER',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Pmax can\'t be set as the property %s is already set. Only one property must be set among these properties: Pmax, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Pmax value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Pmax_type $pmax
     * @return \StructType\OPM
     */
    public function setPmax(\StructType\Pmax_type $pmax = null)
    {
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($pmaxChoiceErrorMessage = self::validatePmaxForChoiceConstraintsFromSetPmax($pmax))) {
            throw new \InvalidArgumentException($pmaxChoiceErrorMessage, __LINE__);
        }
        if (is_null($pmax) || (is_array($pmax) && empty($pmax))) {
            unset($this->Pmax);
        } else {
            $this->Pmax = $pmax;
        }
        return $this;
    }
    /**
     * Get PmaxNT value
     * @return \StructType\Pmax_type|null
     */
    public function getPmaxNT()
    {
        return isset($this->PmaxNT) ? $this->PmaxNT : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPmaxNT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPmaxNT method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePmaxNTForChoiceConstraintsFromSetPmaxNT($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'ResCap',
            'SysServices',
            'Ereact',
            'MP',
            'Price',
            'DataMO',
            'PmaxMO',
            'METER',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PmaxNT can\'t be set as the property %s is already set. Only one property must be set among these properties: PmaxNT, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PmaxNT value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Pmax_type $pmaxNT
     * @return \StructType\OPM
     */
    public function setPmaxNT(\StructType\Pmax_type $pmaxNT = null)
    {
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($pmaxNTChoiceErrorMessage = self::validatePmaxNTForChoiceConstraintsFromSetPmaxNT($pmaxNT))) {
            throw new \InvalidArgumentException($pmaxNTChoiceErrorMessage, __LINE__);
        }
        if (is_null($pmaxNT) || (is_array($pmaxNT) && empty($pmaxNT))) {
            unset($this->PmaxNT);
        } else {
            $this->PmaxNT = $pmaxNT;
        }
        return $this;
    }
    /**
     * Get ResCap value
     * @return \StructType\ResCap|null
     */
    public function getResCap()
    {
        return isset($this->ResCap) ? $this->ResCap : null;
    }
    /**
     * This method is responsible for validating the value passed to the setResCap method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResCap method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateResCapForChoiceConstraintsFromSetResCap($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'SysServices',
            'Ereact',
            'MP',
            'Price',
            'DataMO',
            'PmaxMO',
            'METER',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ResCap can\'t be set as the property %s is already set. Only one property must be set among these properties: ResCap, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ResCap value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ResCap $resCap
     * @return \StructType\OPM
     */
    public function setResCap(\StructType\ResCap $resCap = null)
    {
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($resCapChoiceErrorMessage = self::validateResCapForChoiceConstraintsFromSetResCap($resCap))) {
            throw new \InvalidArgumentException($resCapChoiceErrorMessage, __LINE__);
        }
        if (is_null($resCap) || (is_array($resCap) && empty($resCap))) {
            unset($this->ResCap);
        } else {
            $this->ResCap = $resCap;
        }
        return $this;
    }
    /**
     * Get SysServices value
     * @return \StructType\SysServices|null
     */
    public function getSysServices()
    {
        return isset($this->SysServices) ? $this->SysServices : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSysServices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSysServices method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSysServicesForChoiceConstraintsFromSetSysServices($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'Ereact',
            'MP',
            'Price',
            'DataMO',
            'PmaxMO',
            'METER',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SysServices can\'t be set as the property %s is already set. Only one property must be set among these properties: SysServices, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SysServices value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SysServices $sysServices
     * @return \StructType\OPM
     */
    public function setSysServices(\StructType\SysServices $sysServices = null)
    {
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($sysServicesChoiceErrorMessage = self::validateSysServicesForChoiceConstraintsFromSetSysServices($sysServices))) {
            throw new \InvalidArgumentException($sysServicesChoiceErrorMessage, __LINE__);
        }
        if (is_null($sysServices) || (is_array($sysServices) && empty($sysServices))) {
            unset($this->SysServices);
        } else {
            $this->SysServices = $sysServices;
        }
        return $this;
    }
    /**
     * Get Ereact value
     * @return \StructType\Ereact_type|null
     */
    public function getEreact()
    {
        return isset($this->Ereact) ? $this->Ereact : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEreact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEreact method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEreactForChoiceConstraintsFromSetEreact($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'SysServices',
            'MP',
            'Price',
            'DataMO',
            'PmaxMO',
            'METER',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Ereact can\'t be set as the property %s is already set. Only one property must be set among these properties: Ereact, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Ereact value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Ereact_type $ereact
     * @return \StructType\OPM
     */
    public function setEreact(\StructType\Ereact_type $ereact = null)
    {
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($ereactChoiceErrorMessage = self::validateEreactForChoiceConstraintsFromSetEreact($ereact))) {
            throw new \InvalidArgumentException($ereactChoiceErrorMessage, __LINE__);
        }
        if (is_null($ereact) || (is_array($ereact) && empty($ereact))) {
            unset($this->Ereact);
        } else {
            $this->Ereact = $ereact;
        }
        return $this;
    }
    /**
     * Get MP value
     * @return \StructType\MP[]|null
     */
    public function getMP()
    {
        return isset($this->MP) ? $this->MP : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMP method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMP method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMPForArrayConstraintsFromSetMP(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oPMMPItem) {
            // validation for constraint: itemType
            if (!$oPMMPItem instanceof \StructType\MP) {
                $invalidValues[] = is_object($oPMMPItem) ? get_class($oPMMPItem) : sprintf('%s(%s)', gettype($oPMMPItem), var_export($oPMMPItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MP property can only contain items of type \StructType\MP, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMP method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMP method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMPForChoiceConstraintsFromSetMP($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'SysServices',
            'Ereact',
            'Price',
            'DataMO',
            'PmaxMO',
            'METER',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MP can\'t be set as the property %s is already set. Only one property must be set among these properties: MP, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MP value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\MP[] $mP
     * @return \StructType\OPM
     */
    public function setMP(array $mP = array())
    {
        // validation for constraint: array
        if ('' !== ($mPArrayErrorMessage = self::validateMPForArrayConstraintsFromSetMP($mP))) {
            throw new \InvalidArgumentException($mPArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($mPChoiceErrorMessage = self::validateMPForChoiceConstraintsFromSetMP($mP))) {
            throw new \InvalidArgumentException($mPChoiceErrorMessage, __LINE__);
        }
        if (is_null($mP) || (is_array($mP) && empty($mP))) {
            unset($this->MP);
        } else {
            $this->MP = $mP;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToMP method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToMP method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToMP($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'SysServices',
            'Ereact',
            'Price',
            'DataMO',
            'PmaxMO',
            'METER',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MP can\'t be set as the property %s is already set. Only one property must be set among these properties: MP, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to MP value
     * @throws \InvalidArgumentException
     * @param \StructType\MP $item
     * @return \StructType\OPM
     */
    public function addToMP(\StructType\MP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MP) {
            throw new \InvalidArgumentException(sprintf('The MP property can only contain items of type \StructType\MP, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToMP($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->MP[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\Price[]|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oPMPriceItem) {
            // validation for constraint: itemType
            if (!$oPMPriceItem instanceof \StructType\Price) {
                $invalidValues[] = is_object($oPMPriceItem) ? get_class($oPMPriceItem) : sprintf('%s(%s)', gettype($oPMPriceItem), var_export($oPMPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Price property can only contain items of type \StructType\Price, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePriceForChoiceConstraintsFromSetPrice($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'SysServices',
            'Ereact',
            'MP',
            'DataMO',
            'PmaxMO',
            'METER',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Price can\'t be set as the property %s is already set. Only one property must be set among these properties: Price, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Price value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Price[] $price
     * @return \StructType\OPM
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($priceChoiceErrorMessage = self::validatePriceForChoiceConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceChoiceErrorMessage, __LINE__);
        }
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPrice method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPrice($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'SysServices',
            'Ereact',
            'MP',
            'DataMO',
            'PmaxMO',
            'METER',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Price can\'t be set as the property %s is already set. Only one property must be set among these properties: Price, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \StructType\Price $item
     * @return \StructType\OPM
     */
    public function addToPrice(\StructType\Price $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Price) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of type \StructType\Price, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPrice($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get DataMO value
     * @return \StructType\DataMO|null
     */
    public function getDataMO()
    {
        return isset($this->DataMO) ? $this->DataMO : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDataMO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDataMO method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDataMOForChoiceConstraintsFromSetDataMO($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'SysServices',
            'Ereact',
            'MP',
            'Price',
            'PmaxMO',
            'METER',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DataMO can\'t be set as the property %s is already set. Only one property must be set among these properties: DataMO, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DataMO value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DataMO $dataMO
     * @return \StructType\OPM
     */
    public function setDataMO(\StructType\DataMO $dataMO = null)
    {
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($dataMOChoiceErrorMessage = self::validateDataMOForChoiceConstraintsFromSetDataMO($dataMO))) {
            throw new \InvalidArgumentException($dataMOChoiceErrorMessage, __LINE__);
        }
        if (is_null($dataMO) || (is_array($dataMO) && empty($dataMO))) {
            unset($this->DataMO);
        } else {
            $this->DataMO = $dataMO;
        }
        return $this;
    }
    /**
     * Get PmaxMO value
     * @return \StructType\Pmax_type|null
     */
    public function getPmaxMO()
    {
        return isset($this->PmaxMO) ? $this->PmaxMO : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPmaxMO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPmaxMO method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePmaxMOForChoiceConstraintsFromSetPmaxMO($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'SysServices',
            'Ereact',
            'MP',
            'Price',
            'DataMO',
            'METER',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PmaxMO can\'t be set as the property %s is already set. Only one property must be set among these properties: PmaxMO, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PmaxMO value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Pmax_type $pmaxMO
     * @return \StructType\OPM
     */
    public function setPmaxMO(\StructType\Pmax_type $pmaxMO = null)
    {
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($pmaxMOChoiceErrorMessage = self::validatePmaxMOForChoiceConstraintsFromSetPmaxMO($pmaxMO))) {
            throw new \InvalidArgumentException($pmaxMOChoiceErrorMessage, __LINE__);
        }
        if (is_null($pmaxMO) || (is_array($pmaxMO) && empty($pmaxMO))) {
            unset($this->PmaxMO);
        } else {
            $this->PmaxMO = $pmaxMO;
        }
        return $this;
    }
    /**
     * Get METER value
     * @return \StructType\METER[]|null
     */
    public function getMETER()
    {
        return isset($this->METER) ? $this->METER : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMETER method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMETER method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMETERForArrayConstraintsFromSetMETER(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oPMMETERItem) {
            // validation for constraint: itemType
            if (!$oPMMETERItem instanceof \StructType\METER) {
                $invalidValues[] = is_object($oPMMETERItem) ? get_class($oPMMETERItem) : sprintf('%s(%s)', gettype($oPMMETERItem), var_export($oPMMETERItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The METER property can only contain items of type \StructType\METER, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMETER method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMETER method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMETERForChoiceConstraintsFromSetMETER($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'SysServices',
            'Ereact',
            'MP',
            'Price',
            'DataMO',
            'PmaxMO',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property METER can\'t be set as the property %s is already set. Only one property must be set among these properties: METER, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set METER value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\METER[] $mETER
     * @return \StructType\OPM
     */
    public function setMETER(array $mETER = array())
    {
        // validation for constraint: array
        if ('' !== ($mETERArrayErrorMessage = self::validateMETERForArrayConstraintsFromSetMETER($mETER))) {
            throw new \InvalidArgumentException($mETERArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($mETERChoiceErrorMessage = self::validateMETERForChoiceConstraintsFromSetMETER($mETER))) {
            throw new \InvalidArgumentException($mETERChoiceErrorMessage, __LINE__);
        }
        if (is_null($mETER) || (is_array($mETER) && empty($mETER))) {
            unset($this->METER);
        } else {
            $this->METER = $mETER;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToMETER method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToMETER method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToMETER($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'SysServices',
            'Ereact',
            'MP',
            'Price',
            'DataMO',
            'PmaxMO',
            'PriceMO',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property METER can\'t be set as the property %s is already set. Only one property must be set among these properties: METER, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to METER value
     * @throws \InvalidArgumentException
     * @param \StructType\METER $item
     * @return \StructType\OPM
     */
    public function addToMETER(\StructType\METER $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\METER) {
            throw new \InvalidArgumentException(sprintf('The METER property can only contain items of type \StructType\METER, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToMETER($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->METER[] = $item;
        return $this;
    }
    /**
     * Get PriceMO value
     * @return \StructType\PriceMO[]|null
     */
    public function getPriceMO()
    {
        return isset($this->PriceMO) ? $this->PriceMO : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceMO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceMO method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceMOForArrayConstraintsFromSetPriceMO(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oPMPriceMOItem) {
            // validation for constraint: itemType
            if (!$oPMPriceMOItem instanceof \StructType\PriceMO) {
                $invalidValues[] = is_object($oPMPriceMOItem) ? get_class($oPMPriceMOItem) : sprintf('%s(%s)', gettype($oPMPriceMOItem), var_export($oPMPriceMOItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PriceMO property can only contain items of type \StructType\PriceMO, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPriceMO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceMO method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePriceMOForChoiceConstraintsFromSetPriceMO($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'SysServices',
            'Ereact',
            'MP',
            'Price',
            'DataMO',
            'PmaxMO',
            'METER',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PriceMO can\'t be set as the property %s is already set. Only one property must be set among these properties: PriceMO, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PriceMO value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\PriceMO[] $priceMO
     * @return \StructType\OPM
     */
    public function setPriceMO(array $priceMO = array())
    {
        // validation for constraint: array
        if ('' !== ($priceMOArrayErrorMessage = self::validatePriceMOForArrayConstraintsFromSetPriceMO($priceMO))) {
            throw new \InvalidArgumentException($priceMOArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($priceMOChoiceErrorMessage = self::validatePriceMOForChoiceConstraintsFromSetPriceMO($priceMO))) {
            throw new \InvalidArgumentException($priceMOChoiceErrorMessage, __LINE__);
        }
        if (is_null($priceMO) || (is_array($priceMO) && empty($priceMO))) {
            unset($this->PriceMO);
        } else {
            $this->PriceMO = $priceMO;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPriceMO method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPriceMO method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPriceMO($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Pmax',
            'PmaxNT',
            'ResCap',
            'SysServices',
            'Ereact',
            'MP',
            'Price',
            'DataMO',
            'PmaxMO',
            'METER',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PriceMO can\'t be set as the property %s is already set. Only one property must be set among these properties: PriceMO, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to PriceMO value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceMO $item
     * @return \StructType\OPM
     */
    public function addToPriceMO(\StructType\PriceMO $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceMO) {
            throw new \InvalidArgumentException(sprintf('The PriceMO property can only contain items of type \StructType\PriceMO, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Pmax, PmaxNT, ResCap, SysServices, Ereact, MP, Price, DataMO, PmaxMO, METER, PriceMO)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPriceMO($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->PriceMO[] = $item;
        return $this;
    }
    /**
     * Get inv_id value
     * @return string|null
     */
    public function getInv_id()
    {
        return $this->inv_id;
    }
    /**
     * Set inv_id value
     * @param string $inv_id
     * @return \StructType\OPM
     */
    public function setInv_id($inv_id = null)
    {
        // validation for constraint: string
        if (!is_null($inv_id) && !is_string($inv_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_id, true), gettype($inv_id)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($inv_id) && mb_strlen($inv_id) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($inv_id)), __LINE__);
        }
        $this->inv_id = $inv_id;
        return $this;
    }
    /**
     * Get qty value
     * @return string|null
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param string $qty
     * @return \StructType\OPM
     */
    public function setQty($qty = null)
    {
        // validation for constraint: string
        if (!is_null($qty) && !is_string($qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qty) && mb_strlen($qty) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qty)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($qty) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($qty, true)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
    /**
     * Get Qty_VT value
     * @return string|null
     */
    public function getQty_VT()
    {
        return $this->{'qty-VT'};
    }
    /**
     * Set Qty_VT value
     * @param string $qty_VT
     * @return \StructType\OPM
     */
    public function setQty_VT($qty_VT = null)
    {
        // validation for constraint: string
        if (!is_null($qty_VT) && !is_string($qty_VT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty_VT, true), gettype($qty_VT)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qty_VT) && mb_strlen($qty_VT) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qty_VT)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($qty_VT) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $qty_VT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($qty_VT, true)), __LINE__);
        }
        $this->qty_VT = $this->{'qty-VT'} = $qty_VT;
        return $this;
    }
    /**
     * Get Qty_NT value
     * @return string|null
     */
    public function getQty_NT()
    {
        return $this->{'qty-NT'};
    }
    /**
     * Set Qty_NT value
     * @param string $qty_NT
     * @return \StructType\OPM
     */
    public function setQty_NT($qty_NT = null)
    {
        // validation for constraint: string
        if (!is_null($qty_NT) && !is_string($qty_NT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty_NT, true), gettype($qty_NT)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($qty_NT) && mb_strlen($qty_NT) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($qty_NT)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($qty_NT) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $qty_NT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($qty_NT, true)), __LINE__);
        }
        $this->qty_NT = $this->{'qty-NT'} = $qty_NT;
        return $this;
    }
    /**
     * Get inv_per_to value
     * @return string|null
     */
    public function getInv_per_to()
    {
        return $this->{'inv-per-to'};
    }
    /**
     * Set inv_per_to value
     * @param string $inv_per_to
     * @return \StructType\OPM
     */
    public function setInv_per_to($inv_per_to = null)
    {
        // validation for constraint: string
        if (!is_null($inv_per_to) && !is_string($inv_per_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inv_per_to, true), gettype($inv_per_to)), __LINE__);
        }
        $this->inv_per_to = $this->{'inv-per-to'} = $inv_per_to;
        return $this;
    }
    /**
     * Get contract_type value
     * @return string|null
     */
    public function getContract_type()
    {
        return $this->{'contract-type'};
    }
    /**
     * Set contract_type value
     * @param string $contract_type
     * @return \StructType\OPM
     */
    public function setContract_type($contract_type = null)
    {
        // validation for constraint: string
        if (!is_null($contract_type) && !is_string($contract_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_type, true), gettype($contract_type)), __LINE__);
        }
        $this->contract_type = $this->{'contract-type'} = $contract_type;
        return $this;
    }
    /**
     * Get supplyDS_qty value
     * @return string|null
     */
    public function getSupplyDS_qty()
    {
        return $this->{'supplyDS-qty'};
    }
    /**
     * Set supplyDS_qty value
     * @param string $supplyDS_qty
     * @return \StructType\OPM
     */
    public function setSupplyDS_qty($supplyDS_qty = null)
    {
        // validation for constraint: string
        if (!is_null($supplyDS_qty) && !is_string($supplyDS_qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplyDS_qty, true), gettype($supplyDS_qty)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($supplyDS_qty) && mb_strlen($supplyDS_qty) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($supplyDS_qty)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($supplyDS_qty) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $supplyDS_qty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($supplyDS_qty, true)), __LINE__);
        }
        $this->supplyDS_qty = $this->{'supplyDS-qty'} = $supplyDS_qty;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\OPM
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\OPM
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get opm_main value
     * @return string|null
     */
    public function getOpm_main()
    {
        return $this->{'opm-main'};
    }
    /**
     * Set opm_main value
     * @param string $opm_main
     * @return \StructType\OPM
     */
    public function setOpm_main($opm_main = null)
    {
        // validation for constraint: string
        if (!is_null($opm_main) && !is_string($opm_main)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opm_main, true), gettype($opm_main)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($opm_main) && mb_strlen($opm_main) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($opm_main)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($opm_main) && !preg_match('/\\d+/', $opm_main)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($opm_main, true)), __LINE__);
        }
        $this->opm_main = $this->{'opm-main'} = $opm_main;
        return $this;
    }
    /**
     * Get date_from value
     * @return string|null
     */
    public function getDate_from()
    {
        return $this->{'date-from'};
    }
    /**
     * Set date_from value
     * @param string $date_from
     * @return \StructType\OPM
     */
    public function setDate_from($date_from = null)
    {
        // validation for constraint: string
        if (!is_null($date_from) && !is_string($date_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_from, true), gettype($date_from)), __LINE__);
        }
        $this->date_from = $this->{'date-from'} = $date_from;
        return $this;
    }
    /**
     * Get date_to value
     * @return string|null
     */
    public function getDate_to()
    {
        return $this->{'date-to'};
    }
    /**
     * Set date_to value
     * @param string $date_to
     * @return \StructType\OPM
     */
    public function setDate_to($date_to = null)
    {
        // validation for constraint: string
        if (!is_null($date_to) && !is_string($date_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_to, true), gettype($date_to)), __LINE__);
        }
        $this->date_to = $this->{'date-to'} = $date_to;
        return $this;
    }
    /**
     * Get anlart value
     * @return string|null
     */
    public function getAnlart()
    {
        return $this->anlart;
    }
    /**
     * Set anlart value
     * @param string $anlart
     * @return \StructType\OPM
     */
    public function setAnlart($anlart = null)
    {
        // validation for constraint: string
        if (!is_null($anlart) && !is_string($anlart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anlart, true), gettype($anlart)), __LINE__);
        }
        $this->anlart = $anlart;
        return $this;
    }
    /**
     * Get spebene value
     * @return string|null
     */
    public function getSpebene()
    {
        return $this->spebene;
    }
    /**
     * Set spebene value
     * @uses \EnumType\Voltage_level::valueIsValid()
     * @uses \EnumType\Voltage_level::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $spebene
     * @return \StructType\OPM
     */
    public function setSpebene($spebene = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Voltage_level::valueIsValid($spebene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Voltage_level', is_array($spebene) ? implode(', ', $spebene) : var_export($spebene, true), implode(', ', \EnumType\Voltage_level::getValidValues())), __LINE__);
        }
        $this->spebene = $spebene;
        return $this;
    }
    /**
     * Get island value
     * @return string|null
     */
    public function getIsland()
    {
        return $this->island;
    }
    /**
     * Set island value
     * @param string $island
     * @return \StructType\OPM
     */
    public function setIsland($island = 'CIR')
    {
        // validation for constraint: string
        if (!is_null($island) && !is_string($island)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($island, true), gettype($island)), __LINE__);
        }
        $this->island = $island;
        return $this;
    }
    /**
     * Get pps value
     * @return string|null
     */
    public function getPps()
    {
        return $this->pps;
    }
    /**
     * Set pps value
     * @param string $pps
     * @return \StructType\OPM
     */
    public function setPps($pps = null)
    {
        // validation for constraint: string
        if (!is_null($pps) && !is_string($pps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pps, true), gettype($pps)), __LINE__);
        }
        $this->pps = $pps;
        return $this;
    }
    /**
     * Get typm value
     * @return string|null
     */
    public function getTypm()
    {
        return $this->typm;
    }
    /**
     * Set typm value
     * @param string $typm
     * @return \StructType\OPM
     */
    public function setTypm($typm = null)
    {
        // validation for constraint: string
        if (!is_null($typm) && !is_string($typm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typm, true), gettype($typm)), __LINE__);
        }
        $this->typm = $typm;
        return $this;
    }
    /**
     * Get typ_pm value
     * @return string|null
     */
    public function getTyp_pm()
    {
        return $this->{'typ-pm'};
    }
    /**
     * Set typ_pm value
     * @param string $typ_pm
     * @return \StructType\OPM
     */
    public function setTyp_pm($typ_pm = null)
    {
        // validation for constraint: string
        if (!is_null($typ_pm) && !is_string($typ_pm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typ_pm, true), gettype($typ_pm)), __LINE__);
        }
        $this->typ_pm = $this->{'typ-pm'} = $typ_pm;
        return $this;
    }
    /**
     * Get typsrc value
     * @return string|null
     */
    public function getTypsrc()
    {
        return $this->typsrc;
    }
    /**
     * Set typsrc value
     * @param string $typsrc
     * @return \StructType\OPM
     */
    public function setTypsrc($typsrc = null)
    {
        // validation for constraint: string
        if (!is_null($typsrc) && !is_string($typsrc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typsrc, true), gettype($typsrc)), __LINE__);
        }
        $this->typsrc = $typsrc;
        return $this;
    }
    /**
     * Get power value
     * @return string|null
     */
    public function getPower()
    {
        return $this->power;
    }
    /**
     * Set power value
     * @param string $power
     * @return \StructType\OPM
     */
    public function setPower($power = null)
    {
        // validation for constraint: string
        if (!is_null($power) && !is_string($power)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($power, true), gettype($power)), __LINE__);
        }
        // validation for constraint: pattern(\d+(\.\d{1,7})?)
        if (!is_null($power) && !preg_match('/\\d+(\\.\\d{1,7})?/', $power)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+(\.\d{1,7})?', var_export($power, true)), __LINE__);
        }
        $this->power = $power;
        return $this;
    }
    /**
     * Get grid_id value
     * @return string|null
     */
    public function getGrid_id()
    {
        return $this->{'grid-id'};
    }
    /**
     * Set grid_id value
     * @param string $grid_id
     * @return \StructType\OPM
     */
    public function setGrid_id($grid_id = null)
    {
        // validation for constraint: string
        if (!is_null($grid_id) && !is_string($grid_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grid_id, true), gettype($grid_id)), __LINE__);
        }
        // validation for constraint: pattern(\d{1,10})
        if (!is_null($grid_id) && !preg_match('/\\d{1,10}/', $grid_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{1,10}', var_export($grid_id, true)), __LINE__);
        }
        $this->grid_id = $this->{'grid-id'} = $grid_id;
        return $this;
    }
    /**
     * Get partner value
     * @return string|null
     */
    public function getPartner()
    {
        return $this->partner;
    }
    /**
     * Set partner value
     * @param string $partner
     * @return \StructType\OPM
     */
    public function setPartner($partner = null)
    {
        // validation for constraint: string
        if (!is_null($partner) && !is_string($partner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partner, true), gettype($partner)), __LINE__);
        }
        // validation for constraint: pattern(\d{13}(\d{5})?)
        if (!is_null($partner) && !preg_match('/\\d{13}(\\d{5})?/', $partner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{13}(\d{5})?', var_export($partner, true)), __LINE__);
        }
        $this->partner = $partner;
        return $this;
    }
    /**
     * Get next_grid value
     * @return string|null
     */
    public function getNext_grid()
    {
        return $this->{'next-grid'};
    }
    /**
     * Set next_grid value
     * @param string $next_grid
     * @return \StructType\OPM
     */
    public function setNext_grid($next_grid = null)
    {
        // validation for constraint: string
        if (!is_null($next_grid) && !is_string($next_grid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($next_grid, true), gettype($next_grid)), __LINE__);
        }
        // validation for constraint: pattern(\d{1,10})
        if (!is_null($next_grid) && !preg_match('/\\d{1,10}/', $next_grid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{1,10}', var_export($next_grid, true)), __LINE__);
        }
        $this->next_grid = $this->{'next-grid'} = $next_grid;
        return $this;
    }
    /**
     * Get ps_pmd value
     * @return string|null
     */
    public function getPs_pmd()
    {
        return $this->{'ps-pmd'};
    }
    /**
     * Set ps_pmd value
     * @param string $ps_pmd
     * @return \StructType\OPM
     */
    public function setPs_pmd($ps_pmd = null)
    {
        // validation for constraint: string
        if (!is_null($ps_pmd) && !is_string($ps_pmd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ps_pmd, true), gettype($ps_pmd)), __LINE__);
        }
        // validation for constraint: length(13)
        if (!is_null($ps_pmd) && mb_strlen($ps_pmd) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 13', mb_strlen($ps_pmd)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($ps_pmd) && !preg_match('/\\d+/', $ps_pmd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($ps_pmd, true)), __LINE__);
        }
        $this->ps_pmd = $this->{'ps-pmd'} = $ps_pmd;
        return $this;
    }
    /**
     * Get ps_dod value
     * @return string|null
     */
    public function getPs_dod()
    {
        return $this->{'ps-dod'};
    }
    /**
     * Set ps_dod value
     * @param string $ps_dod
     * @return \StructType\OPM
     */
    public function setPs_dod($ps_dod = null)
    {
        // validation for constraint: string
        if (!is_null($ps_dod) && !is_string($ps_dod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ps_dod, true), gettype($ps_dod)), __LINE__);
        }
        // validation for constraint: length(13)
        if (!is_null($ps_dod) && mb_strlen($ps_dod) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 13', mb_strlen($ps_dod)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($ps_dod) && !preg_match('/\\d+/', $ps_dod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($ps_dod, true)), __LINE__);
        }
        $this->ps_dod = $this->{'ps-dod'} = $ps_dod;
        return $this;
    }
    /**
     * Get ps_pps value
     * @return string|null
     */
    public function getPs_pps()
    {
        return $this->{'ps-pps'};
    }
    /**
     * Set ps_pps value
     * @param string $ps_pps
     * @return \StructType\OPM
     */
    public function setPs_pps($ps_pps = null)
    {
        // validation for constraint: string
        if (!is_null($ps_pps) && !is_string($ps_pps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ps_pps, true), gettype($ps_pps)), __LINE__);
        }
        // validation for constraint: length(13)
        if (!is_null($ps_pps) && mb_strlen($ps_pps) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 13', mb_strlen($ps_pps)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($ps_pps) && !preg_match('/\\d+/', $ps_pps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($ps_pps, true)), __LINE__);
        }
        $this->ps_pps = $this->{'ps-pps'} = $ps_pps;
        return $this;
    }
    /**
     * Get ps_sz value
     * @return string|null
     */
    public function getPs_sz()
    {
        return $this->{'ps-sz'};
    }
    /**
     * Set ps_sz value
     * @param string $ps_sz
     * @return \StructType\OPM
     */
    public function setPs_sz($ps_sz = null)
    {
        // validation for constraint: string
        if (!is_null($ps_sz) && !is_string($ps_sz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ps_sz, true), gettype($ps_sz)), __LINE__);
        }
        // validation for constraint: length(13)
        if (!is_null($ps_sz) && mb_strlen($ps_sz) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 13', mb_strlen($ps_sz)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($ps_sz) && !preg_match('/\\d+/', $ps_sz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($ps_sz, true)), __LINE__);
        }
        $this->ps_sz = $this->{'ps-sz'} = $ps_sz;
        return $this;
    }
    /**
     * Get ps_poz value
     * @return string|null
     */
    public function getPs_poz()
    {
        return $this->{'ps-poz'};
    }
    /**
     * Set ps_poz value
     * @param string $ps_poz
     * @return \StructType\OPM
     */
    public function setPs_poz($ps_poz = null)
    {
        // validation for constraint: string
        if (!is_null($ps_poz) && !is_string($ps_poz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ps_poz, true), gettype($ps_poz)), __LINE__);
        }
        // validation for constraint: length(13)
        if (!is_null($ps_poz) && mb_strlen($ps_poz) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 13', mb_strlen($ps_poz)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($ps_poz) && !preg_match('/\\d+/', $ps_poz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($ps_poz, true)), __LINE__);
        }
        $this->ps_poz = $this->{'ps-poz'} = $ps_poz;
        return $this;
    }
    /**
     * Get sopm value
     * @return string|null
     */
    public function getSopm()
    {
        return $this->sopm;
    }
    /**
     * Set sopm value
     * @param string $sopm
     * @return \StructType\OPM
     */
    public function setSopm($sopm = null)
    {
        // validation for constraint: string
        if (!is_null($sopm) && !is_string($sopm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sopm, true), gettype($sopm)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($sopm) && mb_strlen($sopm) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($sopm)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($sopm) && !preg_match('/\\d+/', $sopm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($sopm, true)), __LINE__);
        }
        $this->sopm = $sopm;
        return $this;
    }
    /**
     * Get uob value
     * @return string|null
     */
    public function getUob()
    {
        return $this->uob;
    }
    /**
     * Set uob value
     * @param string $uob
     * @return \StructType\OPM
     */
    public function setUob($uob = null)
    {
        // validation for constraint: string
        if (!is_null($uob) && !is_string($uob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uob, true), gettype($uob)), __LINE__);
        }
        $this->uob = $uob;
        return $this;
    }
    /**
     * Get est_cons value
     * @return string|null
     */
    public function getEst_cons()
    {
        return $this->{'est-cons'};
    }
    /**
     * Set est_cons value
     * @param string $est_cons
     * @return \StructType\OPM
     */
    public function setEst_cons($est_cons = null)
    {
        // validation for constraint: string
        if (!is_null($est_cons) && !is_string($est_cons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($est_cons, true), gettype($est_cons)), __LINE__);
        }
        $this->est_cons = $this->{'est-cons'} = $est_cons;
        return $this;
    }
    /**
     * Get temp_area value
     * @return string|null
     */
    public function getTemp_area()
    {
        return $this->{'temp-area'};
    }
    /**
     * Set temp_area value
     * @param string $temp_area
     * @return \StructType\OPM
     */
    public function setTemp_area($temp_area = null)
    {
        // validation for constraint: string
        if (!is_null($temp_area) && !is_string($temp_area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temp_area, true), gettype($temp_area)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($temp_area) && mb_strlen($temp_area) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($temp_area)), __LINE__);
        }
        $this->temp_area = $this->{'temp-area'} = $temp_area;
        return $this;
    }
    /**
     * Get tdd_class value
     * @return string|null
     */
    public function getTdd_class()
    {
        return $this->{'tdd-class'};
    }
    /**
     * Set tdd_class value
     * @param string $tdd_class
     * @return \StructType\OPM
     */
    public function setTdd_class($tdd_class = null)
    {
        // validation for constraint: string
        if (!is_null($tdd_class) && !is_string($tdd_class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tdd_class, true), gettype($tdd_class)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($tdd_class) && mb_strlen($tdd_class) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($tdd_class)), __LINE__);
        }
        $this->tdd_class = $this->{'tdd-class'} = $tdd_class;
        return $this;
    }
    /**
     * Get foreign value
     * @return bool|null
     */
    public function getForeign()
    {
        return $this->foreign;
    }
    /**
     * Set foreign value
     * @param bool $foreign
     * @return \StructType\OPM
     */
    public function setForeign($foreign = null)
    {
        // validation for constraint: boolean
        if (!is_null($foreign) && !is_bool($foreign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($foreign, true), gettype($foreign)), __LINE__);
        }
        $this->foreign = $foreign;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\OPM
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($city) && mb_strlen($city) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get post_code value
     * @return string|null
     */
    public function getPost_code()
    {
        return $this->{'post-code'};
    }
    /**
     * Set post_code value
     * @param string $post_code
     * @return \StructType\OPM
     */
    public function setPost_code($post_code = null)
    {
        // validation for constraint: string
        if (!is_null($post_code) && !is_string($post_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($post_code, true), gettype($post_code)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($post_code) && mb_strlen($post_code) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($post_code)), __LINE__);
        }
        $this->post_code = $this->{'post-code'} = $post_code;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\OPM
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($street) && mb_strlen($street) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get house_num value
     * @return string|null
     */
    public function getHouse_num()
    {
        return $this->{'house-num'};
    }
    /**
     * Set house_num value
     * @param string $house_num
     * @return \StructType\OPM
     */
    public function setHouse_num($house_num = null)
    {
        // validation for constraint: string
        if (!is_null($house_num) && !is_string($house_num)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($house_num, true), gettype($house_num)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($house_num) && mb_strlen($house_num) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($house_num)), __LINE__);
        }
        $this->house_num = $this->{'house-num'} = $house_num;
        return $this;
    }
    /**
     * Get renew_share value
     * @return string|null
     */
    public function getRenew_share()
    {
        return $this->{'renew-share'};
    }
    /**
     * Set renew_share value
     * @param string $renew_share
     * @return \StructType\OPM
     */
    public function setRenew_share($renew_share = null)
    {
        // validation for constraint: string
        if (!is_null($renew_share) && !is_string($renew_share)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renew_share, true), gettype($renew_share)), __LINE__);
        }
        $this->renew_share = $this->{'renew-share'} = $renew_share;
        return $this;
    }
    /**
     * Get combs_share value
     * @return string|null
     */
    public function getCombs_share()
    {
        return $this->{'combs-share'};
    }
    /**
     * Set combs_share value
     * @param string $combs_share
     * @return \StructType\OPM
     */
    public function setCombs_share($combs_share = null)
    {
        // validation for constraint: string
        if (!is_null($combs_share) && !is_string($combs_share)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($combs_share, true), gettype($combs_share)), __LINE__);
        }
        $this->combs_share = $this->{'combs-share'} = $combs_share;
        return $this;
    }
    /**
     * Get mrsend_susp value
     * @return string|null
     */
    public function getMrsend_susp()
    {
        return $this->{'mrsend-susp'};
    }
    /**
     * Set mrsend_susp value
     * @param string $mrsend_susp
     * @return \StructType\OPM
     */
    public function setMrsend_susp($mrsend_susp = null)
    {
        // validation for constraint: string
        if (!is_null($mrsend_susp) && !is_string($mrsend_susp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mrsend_susp, true), gettype($mrsend_susp)), __LINE__);
        }
        $this->mrsend_susp = $this->{'mrsend-susp'} = $mrsend_susp;
        return $this;
    }
    /**
     * Get dpi_active value
     * @return bool|null
     */
    public function getDpi_active()
    {
        return $this->{'dpi-active'};
    }
    /**
     * Set dpi_active value
     * @param bool $dpi_active
     * @return \StructType\OPM
     */
    public function setDpi_active($dpi_active = null)
    {
        // validation for constraint: boolean
        if (!is_null($dpi_active) && !is_bool($dpi_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dpi_active, true), gettype($dpi_active)), __LINE__);
        }
        $this->dpi_active = $this->{'dpi-active'} = $dpi_active;
        return $this;
    }
    /**
     * Get info_text value
     * @return string|null
     */
    public function getInfo_text()
    {
        return $this->{'info-text'};
    }
    /**
     * Set info_text value
     * @param string $info_text
     * @return \StructType\OPM
     */
    public function setInfo_text($info_text = null)
    {
        // validation for constraint: string
        if (!is_null($info_text) && !is_string($info_text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info_text, true), gettype($info_text)), __LINE__);
        }
        // validation for constraint: maxLength(512)
        if (!is_null($info_text) && mb_strlen($info_text) > 512) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 512', mb_strlen($info_text)), __LINE__);
        }
        $this->info_text = $this->{'info-text'} = $info_text;
        return $this;
    }
    /**
     * Get duf_type value
     * @return string|null
     */
    public function getDuf_type()
    {
        return $this->{'duf-type'};
    }
    /**
     * Set duf_type value
     * @param string $duf_type
     * @return \StructType\OPM
     */
    public function setDuf_type($duf_type = null)
    {
        // validation for constraint: string
        if (!is_null($duf_type) && !is_string($duf_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duf_type, true), gettype($duf_type)), __LINE__);
        }
        $this->duf_type = $this->{'duf-type'} = $duf_type;
        return $this;
    }
    /**
     * Get duf_freq value
     * @return string|null
     */
    public function getDuf_freq()
    {
        return $this->{'duf-freq'};
    }
    /**
     * Set duf_freq value
     * @param string $duf_freq
     * @return \StructType\OPM
     */
    public function setDuf_freq($duf_freq = null)
    {
        // validation for constraint: string
        if (!is_null($duf_freq) && !is_string($duf_freq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duf_freq, true), gettype($duf_freq)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($duf_freq) && mb_strlen($duf_freq) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($duf_freq)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($duf_freq) && mb_strlen($duf_freq) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($duf_freq)), __LINE__);
        }
        $this->duf_freq = $this->{'duf-freq'} = $duf_freq;
        return $this;
    }
    /**
     * Get mr_first value
     * @return string|null
     */
    public function getMr_first()
    {
        return $this->{'mr-first'};
    }
    /**
     * Set mr_first value
     * @param string $mr_first
     * @return \StructType\OPM
     */
    public function setMr_first($mr_first = null)
    {
        // validation for constraint: string
        if (!is_null($mr_first) && !is_string($mr_first)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mr_first, true), gettype($mr_first)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($mr_first) && mb_strlen($mr_first) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($mr_first)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($mr_first) && mb_strlen($mr_first) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($mr_first)), __LINE__);
        }
        $this->mr_first = $this->{'mr-first'} = $mr_first;
        return $this;
    }
    /**
     * Get disc_reason value
     * @return string|null
     */
    public function getDisc_reason()
    {
        return $this->{'disc-reason'};
    }
    /**
     * Set disc_reason value
     * @param string $disc_reason
     * @return \StructType\OPM
     */
    public function setDisc_reason($disc_reason = null)
    {
        // validation for constraint: string
        if (!is_null($disc_reason) && !is_string($disc_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disc_reason, true), gettype($disc_reason)), __LINE__);
        }
        $this->disc_reason = $this->{'disc-reason'} = $disc_reason;
        return $this;
    }
    /**
     * Get Qty_VT value
     * @return string|null
     */
    public function getQty_VT_1()
    {
        return $this->{'Qty-VT'};
    }
    /**
     * Set Qty_VT value
     * @param string $qty_VT
     * @return \StructType\OPM
     */
    public function setQty_VT_1($qty_VT_1 = null)
    {
        // validation for constraint: string
        if (!is_null($qty_VT_1) && !is_string($qty_VT_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty_VT_1, true), gettype($qty_VT_1)), __LINE__);
        }
        $this->Qty_VT = $this->{'Qty-VT'} = $qty_VT_1;
        return $this;
    }
    /**
     * Get Qty_NT value
     * @return string|null
     */
    public function getQty_NT_1()
    {
        return $this->{'Qty-NT'};
    }
    /**
     * Set Qty_NT value
     * @param string $qty_NT
     * @return \StructType\OPM
     */
    public function setQty_NT_1($qty_NT_1 = null)
    {
        // validation for constraint: string
        if (!is_null($qty_NT_1) && !is_string($qty_NT_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qty_NT_1, true), gettype($qty_NT_1)), __LINE__);
        }
        $this->Qty_NT = $this->{'Qty-NT'} = $qty_NT_1;
        return $this;
    }
    /**
     * Get opm_sum value
     * @return string|null
     */
    public function getOpm_sum()
    {
        return $this->{'opm-sum'};
    }
    /**
     * Set opm_sum value
     * @param string $opm_sum
     * @return \StructType\OPM
     */
    public function setOpm_sum($opm_sum = null)
    {
        // validation for constraint: string
        if (!is_null($opm_sum) && !is_string($opm_sum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opm_sum, true), gettype($opm_sum)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($opm_sum) && mb_strlen($opm_sum) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($opm_sum)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($opm_sum) && !preg_match('/\\d+/', $opm_sum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($opm_sum, true)), __LINE__);
        }
        $this->opm_sum = $this->{'opm-sum'} = $opm_sum;
        return $this;
    }
    /**
     * Get change_to_past value
     * @return string|null
     */
    public function getChange_to_past()
    {
        return $this->{'change-to-past'};
    }
    /**
     * Set change_to_past value
     * @param string $change_to_past
     * @return \StructType\OPM
     */
    public function setChange_to_past($change_to_past = null)
    {
        // validation for constraint: string
        if (!is_null($change_to_past) && !is_string($change_to_past)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($change_to_past, true), gettype($change_to_past)), __LINE__);
        }
        $this->change_to_past = $this->{'change-to-past'} = $change_to_past;
        return $this;
    }
    /**
     * Get comp_serv value
     * @return string|null
     */
    public function getComp_serv()
    {
        return $this->{'comp-serv'};
    }
    /**
     * Set comp_serv value
     * @param string $comp_serv
     * @return \StructType\OPM
     */
    public function setComp_serv($comp_serv = null)
    {
        // validation for constraint: string
        if (!is_null($comp_serv) && !is_string($comp_serv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comp_serv, true), gettype($comp_serv)), __LINE__);
        }
        $this->comp_serv = $this->{'comp-serv'} = $comp_serv;
        return $this;
    }
    /**
     * Get aggr_inv value
     * @return string|null
     */
    public function getAggr_inv()
    {
        return $this->{'aggr-inv'};
    }
    /**
     * Set aggr_inv value
     * @param string $aggr_inv
     * @return \StructType\OPM
     */
    public function setAggr_inv($aggr_inv = null)
    {
        // validation for constraint: string
        if (!is_null($aggr_inv) && !is_string($aggr_inv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggr_inv, true), gettype($aggr_inv)), __LINE__);
        }
        $this->aggr_inv = $this->{'aggr-inv'} = $aggr_inv;
        return $this;
    }
    /**
     * Get sz_implicit value
     * @return bool|null
     */
    public function getSz_implicit()
    {
        return $this->{'sz-implicit'};
    }
    /**
     * Set sz_implicit value
     * @param bool $sz_implicit
     * @return \StructType\OPM
     */
    public function setSz_implicit($sz_implicit = null)
    {
        // validation for constraint: boolean
        if (!is_null($sz_implicit) && !is_bool($sz_implicit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sz_implicit, true), gettype($sz_implicit)), __LINE__);
        }
        $this->sz_implicit = $this->{'sz-implicit'} = $sz_implicit;
        return $this;
    }
    /**
     * Get res_power value
     * @return float|null
     */
    public function getRes_power()
    {
        return $this->{'res-power'};
    }
    /**
     * Set res_power value
     * @param float $res_power
     * @return \StructType\OPM
     */
    public function setRes_power($res_power = null)
    {
        // validation for constraint: float
        if (!is_null($res_power) && !(is_float($res_power) || is_numeric($res_power))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($res_power, true), gettype($res_power)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($res_power) && mb_strlen(mb_substr($res_power, false !== mb_strpos($res_power, '.') ? mb_strpos($res_power, '.') + 1 : mb_strlen($res_power))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($res_power, true), mb_strlen(mb_substr($res_power, mb_strpos($res_power, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($res_power) && mb_strlen(preg_replace('/(\D)/', '', $res_power)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($res_power, true), mb_strlen(preg_replace('/(\D)/', '', $res_power))), __LINE__);
        }
        $this->res_power = $this->{'res-power'} = $res_power;
        return $this;
    }
    /**
     * Get supp_block_power value
     * @return string|null
     */
    public function getSupp_block_power()
    {
        return $this->{'supp-block-power'};
    }
    /**
     * Set supp_block_power value
     * @param string $supp_block_power
     * @return \StructType\OPM
     */
    public function setSupp_block_power($supp_block_power = null)
    {
        // validation for constraint: string
        if (!is_null($supp_block_power) && !is_string($supp_block_power)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supp_block_power, true), gettype($supp_block_power)), __LINE__);
        }
        // validation for constraint: pattern(\d+(\.\d{1,7})?)
        if (!is_null($supp_block_power) && !preg_match('/\\d+(\\.\\d{1,7})?/', $supp_block_power)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+(\.\d{1,7})?', var_export($supp_block_power, true)), __LINE__);
        }
        $this->supp_block_power = $this->{'supp-block-power'} = $supp_block_power;
        return $this;
    }
    /**
     * Get supp_blocks value
     * @return string|null
     */
    public function getSupp_blocks()
    {
        return $this->{'supp-blocks'};
    }
    /**
     * Set supp_blocks value
     * @param string $supp_blocks
     * @return \StructType\OPM
     */
    public function setSupp_blocks($supp_blocks = null)
    {
        // validation for constraint: string
        if (!is_null($supp_blocks) && !is_string($supp_blocks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supp_blocks, true), gettype($supp_blocks)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($supp_blocks) && mb_strlen($supp_blocks) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($supp_blocks)), __LINE__);
        }
        // validation for constraint: pattern(\d+)
        if (!is_null($supp_blocks) && !preg_match('/\\d+/', $supp_blocks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d+', var_export($supp_blocks, true)), __LINE__);
        }
        $this->supp_blocks = $this->{'supp-blocks'} = $supp_blocks;
        return $this;
    }
    /**
     * Get num_phase value
     * @return string|null
     */
    public function getNum_phase()
    {
        return $this->{'num-phase'};
    }
    /**
     * Set num_phase value
     * @param string $num_phase
     * @return \StructType\OPM
     */
    public function setNum_phase($num_phase = null)
    {
        // validation for constraint: string
        if (!is_null($num_phase) && !is_string($num_phase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($num_phase, true), gettype($num_phase)), __LINE__);
        }
        $this->num_phase = $this->{'num-phase'} = $num_phase;
        return $this;
    }
    /**
     * Get cir_breaker value
     * @return float|null
     */
    public function getCir_breaker()
    {
        return $this->{'cir-breaker'};
    }
    /**
     * Set cir_breaker value
     * @param float $cir_breaker
     * @return \StructType\OPM
     */
    public function setCir_breaker($cir_breaker = null)
    {
        // validation for constraint: float
        if (!is_null($cir_breaker) && !(is_float($cir_breaker) || is_numeric($cir_breaker))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cir_breaker, true), gettype($cir_breaker)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($cir_breaker) && mb_strlen(mb_substr($cir_breaker, false !== mb_strpos($cir_breaker, '.') ? mb_strpos($cir_breaker, '.') + 1 : mb_strlen($cir_breaker))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($cir_breaker, true), mb_strlen(mb_substr($cir_breaker, mb_strpos($cir_breaker, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cir_breaker) && $cir_breaker < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cir_breaker, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($cir_breaker) && mb_strlen(preg_replace('/(\D)/', '', $cir_breaker)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($cir_breaker, true), mb_strlen(preg_replace('/(\D)/', '', $cir_breaker))), __LINE__);
        }
        $this->cir_breaker = $this->{'cir-breaker'} = $cir_breaker;
        return $this;
    }
    /**
     * Get monitor_code value
     * @return string|null
     */
    public function getMonitor_code()
    {
        return $this->{'monitor-code'};
    }
    /**
     * Set monitor_code value
     * @param string $monitor_code
     * @return \StructType\OPM
     */
    public function setMonitor_code($monitor_code = null)
    {
        // validation for constraint: string
        if (!is_null($monitor_code) && !is_string($monitor_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monitor_code, true), gettype($monitor_code)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($monitor_code) && mb_strlen($monitor_code) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($monitor_code)), __LINE__);
        }
        $this->monitor_code = $this->{'monitor-code'} = $monitor_code;
        return $this;
    }
    /**
     * Get monitor_to value
     * @return string|null
     */
    public function getMonitor_to()
    {
        return $this->{'monitor-to'};
    }
    /**
     * Set monitor_to value
     * @param string $monitor_to
     * @return \StructType\OPM
     */
    public function setMonitor_to($monitor_to = null)
    {
        // validation for constraint: string
        if (!is_null($monitor_to) && !is_string($monitor_to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monitor_to, true), gettype($monitor_to)), __LINE__);
        }
        $this->monitor_to = $this->{'monitor-to'} = $monitor_to;
        return $this;
    }
    /**
     * Get monitor_from value
     * @return string|null
     */
    public function getMonitor_from()
    {
        return $this->{'monitor-from'};
    }
    /**
     * Set monitor_from value
     * @param string $monitor_from
     * @return \StructType\OPM
     */
    public function setMonitor_from($monitor_from = null)
    {
        // validation for constraint: string
        if (!is_null($monitor_from) && !is_string($monitor_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($monitor_from, true), gettype($monitor_from)), __LINE__);
        }
        $this->monitor_from = $this->{'monitor-from'} = $monitor_from;
        return $this;
    }
    /**
     * Get dist_rate_type value
     * @return string|null
     */
    public function getDist_rate_type()
    {
        return $this->{'dist-rate-type'};
    }
    /**
     * Set dist_rate_type value
     * @param string $dist_rate_type
     * @return \StructType\OPM
     */
    public function setDist_rate_type($dist_rate_type = null)
    {
        // validation for constraint: string
        if (!is_null($dist_rate_type) && !is_string($dist_rate_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dist_rate_type, true), gettype($dist_rate_type)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($dist_rate_type) && mb_strlen($dist_rate_type) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($dist_rate_type)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($dist_rate_type) && mb_strlen($dist_rate_type) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($dist_rate_type)), __LINE__);
        }
        $this->dist_rate_type = $this->{'dist-rate-type'} = $dist_rate_type;
        return $this;
    }
    /**
     * Get micro_source value
     * @return bool|null
     */
    public function getMicro_source()
    {
        return $this->{'micro-source'};
    }
    /**
     * Set micro_source value
     * @param bool $micro_source
     * @return \StructType\OPM
     */
    public function setMicro_source($micro_source = null)
    {
        // validation for constraint: boolean
        if (!is_null($micro_source) && !is_bool($micro_source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($micro_source, true), gettype($micro_source)), __LINE__);
        }
        $this->micro_source = $this->{'micro-source'} = $micro_source;
        return $this;
    }
    /**
     * Get planned value
     * @return bool|null
     */
    public function getPlanned()
    {
        return $this->planned;
    }
    /**
     * Set planned value
     * @param bool $planned
     * @return \StructType\OPM
     */
    public function setPlanned($planned = null)
    {
        // validation for constraint: boolean
        if (!is_null($planned) && !is_bool($planned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($planned, true), gettype($planned)), __LINE__);
        }
        $this->planned = $planned;
        return $this;
    }
    /**
     * Get cons_categ value
     * @return string|null
     */
    public function getCons_categ()
    {
        return $this->{'cons-categ'};
    }
    /**
     * Set cons_categ value
     * @param string $cons_categ
     * @return \StructType\OPM
     */
    public function setCons_categ($cons_categ = null)
    {
        // validation for constraint: string
        if (!is_null($cons_categ) && !is_string($cons_categ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cons_categ, true), gettype($cons_categ)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($cons_categ) && mb_strlen($cons_categ) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($cons_categ)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cons_categ) && mb_strlen($cons_categ) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cons_categ)), __LINE__);
        }
        $this->cons_categ = $this->{'cons-categ'} = $cons_categ;
        return $this;
    }
}
