<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact StructType
 * Meta information extracted from the WSDL
 * - documentation: Contact | Kontaktní osoba
 * @subpackage Structs
 */
class Contact extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The tel_num
     * @var string
     */
    public $tel_num;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The function
     * @var string
     */
    public $function;
    /**
     * The fax
     * @var string
     */
    public $fax;
    /**
     * Constructor method for Contact
     * @uses Contact::setName()
     * @uses Contact::setTel_num()
     * @uses Contact::setEmail()
     * @uses Contact::setFunction()
     * @uses Contact::setFax()
     * @param string $name
     * @param string $tel_num
     * @param string $email
     * @param string $function
     * @param string $fax
     */
    public function __construct($name = null, $tel_num = null, $email = null, $function = null, $fax = null)
    {
        $this
            ->setName($name)
            ->setTel_num($tel_num)
            ->setEmail($email)
            ->setFunction($function)
            ->setFax($fax);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Contact
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get tel_num value
     * @return string|null
     */
    public function getTel_num()
    {
        return $this->{'tel-num'};
    }
    /**
     * Set tel_num value
     * @param string $tel_num
     * @return \StructType\Contact
     */
    public function setTel_num($tel_num = null)
    {
        // validation for constraint: string
        if (!is_null($tel_num) && !is_string($tel_num)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tel_num, true), gettype($tel_num)), __LINE__);
        }
        $this->tel_num = $this->{'tel-num'} = $tel_num;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Contact
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get function value
     * @return string|null
     */
    public function getFunction()
    {
        return $this->function;
    }
    /**
     * Set function value
     * @param string $function
     * @return \StructType\Contact
     */
    public function setFunction($function = null)
    {
        // validation for constraint: string
        if (!is_null($function) && !is_string($function)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($function, true), gettype($function)), __LINE__);
        }
        $this->function = $function;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Contact
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
}
