<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingItem StructType
 * @subpackage Structs
 */
class BillingItem extends AbstractStructBase
{
    /**
     * The item_type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $item_type;
    /**
     * The BaseItemDetail
     * @var \StructType\BaseItemDetail
     */
    public $BaseItemDetail;
    /**
     * The PricingDetail
     * @var \StructType\PricingDetail
     */
    public $PricingDetail;
    /**
     * The ItemDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemDates
     */
    public $ItemDates;
    /**
     * Constructor method for BillingItem
     * @uses BillingItem::setItem_type()
     * @uses BillingItem::setBaseItemDetail()
     * @uses BillingItem::setPricingDetail()
     * @uses BillingItem::setItemDates()
     * @param string $item_type
     * @param \StructType\BaseItemDetail $baseItemDetail
     * @param \StructType\PricingDetail $pricingDetail
     * @param \StructType\ItemDates $itemDates
     */
    public function __construct($item_type = null, \StructType\BaseItemDetail $baseItemDetail = null, \StructType\PricingDetail $pricingDetail = null, \StructType\ItemDates $itemDates = null)
    {
        $this
            ->setItem_type($item_type)
            ->setBaseItemDetail($baseItemDetail)
            ->setPricingDetail($pricingDetail)
            ->setItemDates($itemDates);
    }
    /**
     * Get item_type value
     * @return string
     */
    public function getItem_type()
    {
        return $this->{'item-type'};
    }
    /**
     * Set item_type value
     * @param string $item_type
     * @return \StructType\BillingItem
     */
    public function setItem_type($item_type = null)
    {
        // validation for constraint: string
        if (!is_null($item_type) && !is_string($item_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_type, true), gettype($item_type)), __LINE__);
        }
        $this->item_type = $this->{'item-type'} = $item_type;
        return $this;
    }
    /**
     * Get BaseItemDetail value
     * @return \StructType\BaseItemDetail|null
     */
    public function getBaseItemDetail()
    {
        return $this->BaseItemDetail;
    }
    /**
     * Set BaseItemDetail value
     * @param \StructType\BaseItemDetail $baseItemDetail
     * @return \StructType\BillingItem
     */
    public function setBaseItemDetail(\StructType\BaseItemDetail $baseItemDetail = null)
    {
        $this->BaseItemDetail = $baseItemDetail;
        return $this;
    }
    /**
     * Get PricingDetail value
     * @return \StructType\PricingDetail|null
     */
    public function getPricingDetail()
    {
        return $this->PricingDetail;
    }
    /**
     * Set PricingDetail value
     * @param \StructType\PricingDetail $pricingDetail
     * @return \StructType\BillingItem
     */
    public function setPricingDetail(\StructType\PricingDetail $pricingDetail = null)
    {
        $this->PricingDetail = $pricingDetail;
        return $this;
    }
    /**
     * Get ItemDates value
     * @return \StructType\ItemDates|null
     */
    public function getItemDates()
    {
        return $this->ItemDates;
    }
    /**
     * Set ItemDates value
     * @param \StructType\ItemDates $itemDates
     * @return \StructType\BillingItem
     */
    public function setItemDates(\StructType\ItemDates $itemDates = null)
    {
        $this->ItemDates = $itemDates;
        return $this;
    }
}
