<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attachment StructType
 * Meta information extracted from the WSDL
 * - documentation: Attachment | Příloha | Attachment. The content of the attachemtn will be included in this tag. The content must be Base64 encrypted. | Příloha. Obsah přílohy je uvedem v tomto tagu, musí být kódováno Base64.
 * @subpackage Structs
 */
class Attachment extends AbstractStructBase
{
    /**
     * The file_name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $file_name;
    /**
     * The content_type
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $content_type;
    /**
     * The AttachmentHeader
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AttachmentHeader[]
     */
    public $AttachmentHeader;
    /**
     * The AttachmentSum
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * @var \StructType\AttachmentSum[]
     */
    public $AttachmentSum;
    /**
     * Constructor method for Attachment
     * @uses Attachment::setFile_name()
     * @uses Attachment::setContent_type()
     * @uses Attachment::setAttachmentHeader()
     * @uses Attachment::setAttachmentSum()
     * @param string $file_name
     * @param string $content_type
     * @param \StructType\AttachmentHeader[] $attachmentHeader
     * @param \StructType\AttachmentSum[] $attachmentSum
     */
    public function __construct($file_name = null, $content_type = null, array $attachmentHeader = array(), array $attachmentSum = array())
    {
        $this
            ->setFile_name($file_name)
            ->setContent_type($content_type)
            ->setAttachmentHeader($attachmentHeader)
            ->setAttachmentSum($attachmentSum);
    }
    /**
     * Get file_name value
     * @return string
     */
    public function getFile_name()
    {
        return $this->{'file-name'};
    }
    /**
     * Set file_name value
     * @param string $file_name
     * @return \StructType\Attachment
     */
    public function setFile_name($file_name = null)
    {
        // validation for constraint: string
        if (!is_null($file_name) && !is_string($file_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file_name, true), gettype($file_name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($file_name) && mb_strlen($file_name) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($file_name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($file_name) && mb_strlen($file_name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($file_name)), __LINE__);
        }
        $this->file_name = $this->{'file-name'} = $file_name;
        return $this;
    }
    /**
     * Get content_type value
     * @return string
     */
    public function getContent_type()
    {
        return $this->{'content-type'};
    }
    /**
     * Set content_type value
     * @param string $content_type
     * @return \StructType\Attachment
     */
    public function setContent_type($content_type = null)
    {
        // validation for constraint: string
        if (!is_null($content_type) && !is_string($content_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content_type, true), gettype($content_type)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($content_type) && mb_strlen($content_type) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($content_type)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($content_type) && mb_strlen($content_type) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($content_type)), __LINE__);
        }
        $this->content_type = $this->{'content-type'} = $content_type;
        return $this;
    }
    /**
     * Get AttachmentHeader value
     * @return \StructType\AttachmentHeader[]|null
     */
    public function getAttachmentHeader()
    {
        return $this->AttachmentHeader;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachmentHeader method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachmentHeader method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentHeaderForArrayConstraintsFromSetAttachmentHeader(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attachmentAttachmentHeaderItem) {
            // validation for constraint: itemType
            if (!$attachmentAttachmentHeaderItem instanceof \StructType\AttachmentHeader) {
                $invalidValues[] = is_object($attachmentAttachmentHeaderItem) ? get_class($attachmentAttachmentHeaderItem) : sprintf('%s(%s)', gettype($attachmentAttachmentHeaderItem), var_export($attachmentAttachmentHeaderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AttachmentHeader property can only contain items of type \StructType\AttachmentHeader, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AttachmentHeader value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentHeader[] $attachmentHeader
     * @return \StructType\Attachment
     */
    public function setAttachmentHeader(array $attachmentHeader = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentHeaderArrayErrorMessage = self::validateAttachmentHeaderForArrayConstraintsFromSetAttachmentHeader($attachmentHeader))) {
            throw new \InvalidArgumentException($attachmentHeaderArrayErrorMessage, __LINE__);
        }
        $this->AttachmentHeader = $attachmentHeader;
        return $this;
    }
    /**
     * Add item to AttachmentHeader value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentHeader $item
     * @return \StructType\Attachment
     */
    public function addToAttachmentHeader(\StructType\AttachmentHeader $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttachmentHeader) {
            throw new \InvalidArgumentException(sprintf('The AttachmentHeader property can only contain items of type \StructType\AttachmentHeader, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AttachmentHeader[] = $item;
        return $this;
    }
    /**
     * Get AttachmentSum value
     * @return \StructType\AttachmentSum[]|null
     */
    public function getAttachmentSum()
    {
        return $this->AttachmentSum;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachmentSum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachmentSum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentSumForArrayConstraintsFromSetAttachmentSum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attachmentAttachmentSumItem) {
            // validation for constraint: itemType
            if (!$attachmentAttachmentSumItem instanceof \StructType\AttachmentSum) {
                $invalidValues[] = is_object($attachmentAttachmentSumItem) ? get_class($attachmentAttachmentSumItem) : sprintf('%s(%s)', gettype($attachmentAttachmentSumItem), var_export($attachmentAttachmentSumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AttachmentSum property can only contain items of type \StructType\AttachmentSum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AttachmentSum value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentSum[] $attachmentSum
     * @return \StructType\Attachment
     */
    public function setAttachmentSum(array $attachmentSum = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentSumArrayErrorMessage = self::validateAttachmentSumForArrayConstraintsFromSetAttachmentSum($attachmentSum))) {
            throw new \InvalidArgumentException($attachmentSumArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($attachmentSum) && count($attachmentSum) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($attachmentSum)), __LINE__);
        }
        $this->AttachmentSum = $attachmentSum;
        return $this;
    }
    /**
     * Add item to AttachmentSum value
     * @throws \InvalidArgumentException
     * @param \StructType\AttachmentSum $item
     * @return \StructType\Attachment
     */
    public function addToAttachmentSum(\StructType\AttachmentSum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttachmentSum) {
            throw new \InvalidArgumentException(sprintf('The AttachmentSum property can only contain items of type \StructType\AttachmentSum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->AttachmentSum) && count($this->AttachmentSum) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->AttachmentSum)), __LINE__);
        }
        $this->AttachmentSum[] = $item;
        return $this;
    }
}
