<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activity StructType
 * Meta information extracted from the WSDL
 * - documentation: Akce v rámci procesu změny dodavatele
 * @subpackage Structs
 */
class Activity extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The party
     * Meta information extracted from the WSDL
     * - documentation: RUT ID odesílatele (doplňuje OTE) | Typ pro pseudo-EIC kód | EIC code type
     * - base: xsd:string
     * - maxLength: 16
     * - minLength: 13
     * - pattern: \c{16}
     * @var string
     */
    public $party;
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Datum a čas zprávy (doplňuje OTE)
     * @var string
     */
    public $date_time;
    /**
     * The comment
     * @var string
     */
    public $comment;
    /**
     * The reason
     * @var string
     */
    public $reason;
    /**
     * Constructor method for Activity
     * @uses Activity::setType()
     * @uses Activity::setParty()
     * @uses Activity::setDate_time()
     * @uses Activity::setComment()
     * @uses Activity::setReason()
     * @param string $type
     * @param string $party
     * @param string $date_time
     * @param string $comment
     * @param string $reason
     */
    public function __construct($type = null, $party = null, $date_time = null, $comment = null, $reason = null)
    {
        $this
            ->setType($type)
            ->setParty($party)
            ->setDate_time($date_time)
            ->setComment($comment)
            ->setReason($reason);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Activity
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get party value
     * @return string|null
     */
    public function getParty()
    {
        return $this->party;
    }
    /**
     * Set party value
     * @param string $party
     * @return \StructType\Activity
     */
    public function setParty($party = null)
    {
        // validation for constraint: string
        if (!is_null($party) && !is_string($party)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($party, true), gettype($party)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($party) && mb_strlen($party) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($party)), __LINE__);
        }
        // validation for constraint: minLength(13)
        if (!is_null($party) && mb_strlen($party) < 13) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 13', mb_strlen($party)), __LINE__);
        }
        // validation for constraint: pattern(\c{16})
        if (!is_null($party) && !preg_match('/\\c{16}/', $party)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \c{16}', var_export($party, true)), __LINE__);
        }
        $this->party = $party;
        return $this;
    }
    /**
     * Get date_time value
     * @return string|null
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\Activity
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\Activity
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\Activity
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
}
