<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TDD StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element containing basic message data | Rootovský element obsahující základní údaje o zprávě
 * @subpackage Structs
 */
class TDD extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Unique message identification | Jednoznačný identifikátor zprávy | Typ pro číslo zprávy | Message number type
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The message_code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $message_code;
    /**
     * The date_time
     * Meta information extracted from the WSDL
     * - documentation: Date and time of message | Datum a čas zprávy
     * - use: required
     * @var string
     */
    public $date_time;
    /**
     * The answer_required
     * Meta information extracted from the WSDL
     * - documentation: Indication of request for response | Indikace požadavku na odpověď
     * - use: required
     * @var bool
     */
    public $answer_required;
    /**
     * The SenderIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message sender identification | Identifikace odesílatele zprávy
     * @var \StructType\SenderIdentificationType
     */
    public $SenderIdentification;
    /**
     * The ReceiverIdentification
     * Meta information extracted from the WSDL
     * - documentation: Message receiver identification | Identifikace příjemce zprávy
     * @var \StructType\ReceiverIdentificationType
     */
    public $ReceiverIdentification;
    /**
     * The TddProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TddProfile[]
     */
    public $TddProfile;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \StructType\SignatureType
     */
    public $Signature;
    /**
     * Constructor method for TDD
     * @uses TDD::setId()
     * @uses TDD::setMessage_code()
     * @uses TDD::setDate_time()
     * @uses TDD::setAnswer_required()
     * @uses TDD::setSenderIdentification()
     * @uses TDD::setReceiverIdentification()
     * @uses TDD::setTddProfile()
     * @uses TDD::setSignature()
     * @param string $id
     * @param string $message_code
     * @param string $date_time
     * @param bool $answer_required
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @param \StructType\TddProfile[] $tddProfile
     * @param \StructType\SignatureType $signature
     */
    public function __construct($id = null, $message_code = null, $date_time = null, $answer_required = null, \StructType\SenderIdentificationType $senderIdentification = null, \StructType\ReceiverIdentificationType $receiverIdentification = null, array $tddProfile = array(), \StructType\SignatureType $signature = null)
    {
        $this
            ->setId($id)
            ->setMessage_code($message_code)
            ->setDate_time($date_time)
            ->setAnswer_required($answer_required)
            ->setSenderIdentification($senderIdentification)
            ->setReceiverIdentification($receiverIdentification)
            ->setTddProfile($tddProfile)
            ->setSignature($signature);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\TDD
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($id) && mb_strlen($id) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($id) && mb_strlen($id) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get message_code value
     * @return string
     */
    public function getMessage_code()
    {
        return $this->{'message-code'};
    }
    /**
     * Set message_code value
     * @param string $message_code
     * @return \StructType\TDD
     */
    public function setMessage_code($message_code = null)
    {
        // validation for constraint: string
        if (!is_null($message_code) && !is_string($message_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message_code, true), gettype($message_code)), __LINE__);
        }
        $this->message_code = $this->{'message-code'} = $message_code;
        return $this;
    }
    /**
     * Get date_time value
     * @return string
     */
    public function getDate_time()
    {
        return $this->{'date-time'};
    }
    /**
     * Set date_time value
     * @param string $date_time
     * @return \StructType\TDD
     */
    public function setDate_time($date_time = null)
    {
        // validation for constraint: string
        if (!is_null($date_time) && !is_string($date_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_time, true), gettype($date_time)), __LINE__);
        }
        $this->date_time = $this->{'date-time'} = $date_time;
        return $this;
    }
    /**
     * Get answer_required value
     * @return bool
     */
    public function getAnswer_required()
    {
        return $this->{'answer-required'};
    }
    /**
     * Set answer_required value
     * @param bool $answer_required
     * @return \StructType\TDD
     */
    public function setAnswer_required($answer_required = null)
    {
        // validation for constraint: boolean
        if (!is_null($answer_required) && !is_bool($answer_required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($answer_required, true), gettype($answer_required)), __LINE__);
        }
        $this->answer_required = $this->{'answer-required'} = $answer_required;
        return $this;
    }
    /**
     * Get SenderIdentification value
     * @return \StructType\SenderIdentificationType|null
     */
    public function getSenderIdentification()
    {
        return $this->SenderIdentification;
    }
    /**
     * Set SenderIdentification value
     * @param \StructType\SenderIdentificationType $senderIdentification
     * @return \StructType\TDD
     */
    public function setSenderIdentification(\StructType\SenderIdentificationType $senderIdentification = null)
    {
        $this->SenderIdentification = $senderIdentification;
        return $this;
    }
    /**
     * Get ReceiverIdentification value
     * @return \StructType\ReceiverIdentificationType|null
     */
    public function getReceiverIdentification()
    {
        return $this->ReceiverIdentification;
    }
    /**
     * Set ReceiverIdentification value
     * @param \StructType\ReceiverIdentificationType $receiverIdentification
     * @return \StructType\TDD
     */
    public function setReceiverIdentification(\StructType\ReceiverIdentificationType $receiverIdentification = null)
    {
        $this->ReceiverIdentification = $receiverIdentification;
        return $this;
    }
    /**
     * Get TddProfile value
     * @return \StructType\TddProfile[]|null
     */
    public function getTddProfile()
    {
        return $this->TddProfile;
    }
    /**
     * This method is responsible for validating the values passed to the setTddProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTddProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTddProfileForArrayConstraintsFromSetTddProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tDDTddProfileItem) {
            // validation for constraint: itemType
            if (!$tDDTddProfileItem instanceof \StructType\TddProfile) {
                $invalidValues[] = is_object($tDDTddProfileItem) ? get_class($tDDTddProfileItem) : sprintf('%s(%s)', gettype($tDDTddProfileItem), var_export($tDDTddProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TddProfile property can only contain items of type \StructType\TddProfile, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TddProfile value
     * @throws \InvalidArgumentException
     * @param \StructType\TddProfile[] $tddProfile
     * @return \StructType\TDD
     */
    public function setTddProfile(array $tddProfile = array())
    {
        // validation for constraint: array
        if ('' !== ($tddProfileArrayErrorMessage = self::validateTddProfileForArrayConstraintsFromSetTddProfile($tddProfile))) {
            throw new \InvalidArgumentException($tddProfileArrayErrorMessage, __LINE__);
        }
        $this->TddProfile = $tddProfile;
        return $this;
    }
    /**
     * Add item to TddProfile value
     * @throws \InvalidArgumentException
     * @param \StructType\TddProfile $item
     * @return \StructType\TDD
     */
    public function addToTddProfile(\StructType\TddProfile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TddProfile) {
            throw new \InvalidArgumentException(sprintf('The TddProfile property can only contain items of type \StructType\TddProfile, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TddProfile[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \StructType\SignatureType|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param \StructType\SignatureType $signature
     * @return \StructType\TDD
     */
    public function setSignature(\StructType\SignatureType $signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
}
