<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SumItem StructType
 * Meta information extracted from the WSDL
 * - documentation: Document summary item | Sumární položka dokladu
 * @subpackage Structs
 */
class SumItem extends AbstractStructBase
{
    /**
     * The item_type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $item_type;
    /**
     * The BaseItemDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BaseItemDetail
     */
    public $BaseItemDetail;
    /**
     * The SumItemPrice
     * @var \StructType\SumItemPrice
     */
    public $SumItemPrice;
    /**
     * The doc_number
     * @var string
     */
    public $doc_number;
    /**
     * Constructor method for SumItem
     * @uses SumItem::setItem_type()
     * @uses SumItem::setBaseItemDetail()
     * @uses SumItem::setSumItemPrice()
     * @uses SumItem::setDoc_number()
     * @param string $item_type
     * @param \StructType\BaseItemDetail $baseItemDetail
     * @param \StructType\SumItemPrice $sumItemPrice
     * @param string $doc_number
     */
    public function __construct($item_type = null, \StructType\BaseItemDetail $baseItemDetail = null, \StructType\SumItemPrice $sumItemPrice = null, $doc_number = null)
    {
        $this
            ->setItem_type($item_type)
            ->setBaseItemDetail($baseItemDetail)
            ->setSumItemPrice($sumItemPrice)
            ->setDoc_number($doc_number);
    }
    /**
     * Get item_type value
     * @return string
     */
    public function getItem_type()
    {
        return $this->{'item-type'};
    }
    /**
     * Set item_type value
     * @param string $item_type
     * @return \StructType\SumItem
     */
    public function setItem_type($item_type = null)
    {
        // validation for constraint: string
        if (!is_null($item_type) && !is_string($item_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_type, true), gettype($item_type)), __LINE__);
        }
        $this->item_type = $this->{'item-type'} = $item_type;
        return $this;
    }
    /**
     * Get BaseItemDetail value
     * @return \StructType\BaseItemDetail|null
     */
    public function getBaseItemDetail()
    {
        return $this->BaseItemDetail;
    }
    /**
     * Set BaseItemDetail value
     * @param \StructType\BaseItemDetail $baseItemDetail
     * @return \StructType\SumItem
     */
    public function setBaseItemDetail(\StructType\BaseItemDetail $baseItemDetail = null)
    {
        $this->BaseItemDetail = $baseItemDetail;
        return $this;
    }
    /**
     * Get SumItemPrice value
     * @return \StructType\SumItemPrice|null
     */
    public function getSumItemPrice()
    {
        return $this->SumItemPrice;
    }
    /**
     * Set SumItemPrice value
     * @param \StructType\SumItemPrice $sumItemPrice
     * @return \StructType\SumItem
     */
    public function setSumItemPrice(\StructType\SumItemPrice $sumItemPrice = null)
    {
        $this->SumItemPrice = $sumItemPrice;
        return $this;
    }
    /**
     * Get doc_number value
     * @return string|null
     */
    public function getDoc_number()
    {
        return $this->{'doc-number'};
    }
    /**
     * Set doc_number value
     * @param string $doc_number
     * @return \StructType\SumItem
     */
    public function setDoc_number($doc_number = null)
    {
        // validation for constraint: string
        if (!is_null($doc_number) && !is_string($doc_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_number, true), gettype($doc_number)), __LINE__);
        }
        $this->doc_number = $this->{'doc-number'} = $doc_number;
        return $this;
    }
}
