<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResCap StructType
 * Meta information extracted from the WSDL
 * - documentation: Reserved capacity | Rezervovaná kapacita
 * @subpackage Structs
 */
class ResCap extends AbstractStructBase
{
    /**
     * The rescap_month
     * Meta information extracted from the WSDL
     * - documentation: Decimal number - max. 2 decimal places (not an exponential form) | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar)
     * - base: qty_type_2
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $rescap_month;
    /**
     * The rescap_year
     * Meta information extracted from the WSDL
     * - documentation: Reserved capacity - year | Rezervovaná kapacita - roční | Desetinné číslo na max. 2 des. místa (ne exponenciální tvar) | Decimal number - max. 2 decimal places (not an exponential form)
     * - base: xsd:string
     * - maxLength: 16
     * - pattern: -?\d+(\.\d{1,2})?
     * - use: optional
     * @var string
     */
    public $rescap_year;
    /**
     * Constructor method for ResCap
     * @uses ResCap::setRescap_month()
     * @uses ResCap::setRescap_year()
     * @param string $rescap_month
     * @param string $rescap_year
     */
    public function __construct($rescap_month = null, $rescap_year = null)
    {
        $this
            ->setRescap_month($rescap_month)
            ->setRescap_year($rescap_year);
    }
    /**
     * Get rescap_month value
     * @return string|null
     */
    public function getRescap_month()
    {
        return $this->{'rescap-month'};
    }
    /**
     * Set rescap_month value
     * @param string $rescap_month
     * @return \StructType\ResCap
     */
    public function setRescap_month($rescap_month = null)
    {
        // validation for constraint: string
        if (!is_null($rescap_month) && !is_string($rescap_month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rescap_month, true), gettype($rescap_month)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($rescap_month) && mb_strlen($rescap_month) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($rescap_month)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($rescap_month) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $rescap_month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($rescap_month, true)), __LINE__);
        }
        $this->rescap_month = $this->{'rescap-month'} = $rescap_month;
        return $this;
    }
    /**
     * Get rescap_year value
     * @return string|null
     */
    public function getRescap_year()
    {
        return $this->{'rescap-year'};
    }
    /**
     * Set rescap_year value
     * @param string $rescap_year
     * @return \StructType\ResCap
     */
    public function setRescap_year($rescap_year = null)
    {
        // validation for constraint: string
        if (!is_null($rescap_year) && !is_string($rescap_year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rescap_year, true), gettype($rescap_year)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($rescap_year) && mb_strlen($rescap_year) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($rescap_year)), __LINE__);
        }
        // validation for constraint: pattern(-?\d+(\.\d{1,2})?)
        if (!is_null($rescap_year) && !preg_match('/-?\\d+(\\.\\d{1,2})?/', $rescap_year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression -?\d+(\.\d{1,2})?', var_export($rescap_year, true)), __LINE__);
        }
        $this->rescap_year = $this->{'rescap-year'} = $rescap_year;
        return $this;
    }
}
