<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefDocument StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference to previous document | Reference na předchozí doklad
 * @subpackage Structs
 */
class RefDocument extends AbstractStructBase
{
    /**
     * The doc_category
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $doc_category;
    /**
     * The doc_id
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $doc_id;
    /**
     * The doc_item_id
     * @var string
     */
    public $doc_item_id;
    /**
     * Constructor method for RefDocument
     * @uses RefDocument::setDoc_category()
     * @uses RefDocument::setDoc_id()
     * @uses RefDocument::setDoc_item_id()
     * @param string $doc_category
     * @param string $doc_id
     * @param string $doc_item_id
     */
    public function __construct($doc_category = null, $doc_id = null, $doc_item_id = null)
    {
        $this
            ->setDoc_category($doc_category)
            ->setDoc_id($doc_id)
            ->setDoc_item_id($doc_item_id);
    }
    /**
     * Get doc_category value
     * @return string
     */
    public function getDoc_category()
    {
        return $this->{'doc-category'};
    }
    /**
     * Set doc_category value
     * @param string $doc_category
     * @return \StructType\RefDocument
     */
    public function setDoc_category($doc_category = null)
    {
        // validation for constraint: string
        if (!is_null($doc_category) && !is_string($doc_category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_category, true), gettype($doc_category)), __LINE__);
        }
        $this->doc_category = $this->{'doc-category'} = $doc_category;
        return $this;
    }
    /**
     * Get doc_id value
     * @return string
     */
    public function getDoc_id()
    {
        return $this->{'doc-id'};
    }
    /**
     * Set doc_id value
     * @param string $doc_id
     * @return \StructType\RefDocument
     */
    public function setDoc_id($doc_id = null)
    {
        // validation for constraint: string
        if (!is_null($doc_id) && !is_string($doc_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_id, true), gettype($doc_id)), __LINE__);
        }
        $this->doc_id = $this->{'doc-id'} = $doc_id;
        return $this;
    }
    /**
     * Get doc_item_id value
     * @return string|null
     */
    public function getDoc_item_id()
    {
        return $this->{'doc-item-id'};
    }
    /**
     * Set doc_item_id value
     * @param string $doc_item_id
     * @return \StructType\RefDocument
     */
    public function setDoc_item_id($doc_item_id = null)
    {
        // validation for constraint: string
        if (!is_null($doc_item_id) && !is_string($doc_item_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doc_item_id, true), gettype($doc_item_id)), __LINE__);
        }
        $this->doc_item_id = $this->{'doc-item-id'} = $doc_item_id;
        return $this;
    }
}
