<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSAKeyValueType StructType
 * @subpackage Structs
 */
class RSAKeyValueType extends AbstractStructBase
{
    /**
     * The Modulus
     * Meta information extracted from the WSDL
     * - base: base64Binary
     * @var string
     */
    public $Modulus;
    /**
     * The Exponent
     * Meta information extracted from the WSDL
     * - base: base64Binary
     * @var string
     */
    public $Exponent;
    /**
     * Constructor method for RSAKeyValueType
     * @uses RSAKeyValueType::setModulus()
     * @uses RSAKeyValueType::setExponent()
     * @param string $modulus
     * @param string $exponent
     */
    public function __construct($modulus = null, $exponent = null)
    {
        $this
            ->setModulus($modulus)
            ->setExponent($exponent);
    }
    /**
     * Get Modulus value
     * @return string|null
     */
    public function getModulus()
    {
        return $this->Modulus;
    }
    /**
     * Set Modulus value
     * @param string $modulus
     * @return \StructType\RSAKeyValueType
     */
    public function setModulus($modulus = null)
    {
        // validation for constraint: string
        if (!is_null($modulus) && !is_string($modulus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modulus, true), gettype($modulus)), __LINE__);
        }
        $this->Modulus = $modulus;
        return $this;
    }
    /**
     * Get Exponent value
     * @return string|null
     */
    public function getExponent()
    {
        return $this->Exponent;
    }
    /**
     * Set Exponent value
     * @param string $exponent
     * @return \StructType\RSAKeyValueType
     */
    public function setExponent($exponent = null)
    {
        // validation for constraint: string
        if (!is_null($exponent) && !is_string($exponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exponent, true), gettype($exponent)), __LINE__);
        }
        $this->Exponent = $exponent;
        return $this;
    }
}
