<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Price_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Typ pro element ceny
 * @subpackage Structs
 */
class Price_Type extends AbstractStructBase
{
    /**
     * The value
     * Meta information extracted from the WSDL
     * - documentation: Value | Hodnota | Typ pro hodnotu ceny
     * - base: xsd:decimal
     * - fractionDigits: 14
     * - totalDigits: 31
     * - use: required
     * @var float
     */
    public $value;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $currency;
    /**
     * Constructor method for Price_Type
     * @uses Price_Type::setValue()
     * @uses Price_Type::setCurrency()
     * @param float $value
     * @param string $currency
     */
    public function __construct($value = null, $currency = null)
    {
        $this
            ->setValue($value)
            ->setCurrency($currency);
    }
    /**
     * Get value value
     * @return float
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\Price_Type
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: fractionDigits(14)
        if (!is_null($value) && mb_strlen(mb_substr($value, false !== mb_strpos($value, '.') ? mb_strpos($value, '.') + 1 : mb_strlen($value))) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 14 fraction digits, %d given', var_export($value, true), mb_strlen(mb_substr($value, mb_strpos($value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(31)
        if (!is_null($value) && mb_strlen(preg_replace('/(\D)/', '', $value)) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 31 digits, "%d" given', var_export($value, true), mb_strlen(preg_replace('/(\D)/', '', $value))), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\Price_Type
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
}
