<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentSummary StructType
 * @subpackage Structs
 */
class PaymentSummary extends AbstractStructBase
{
    /**
     * The TotalInvoicedValue
     * Meta information extracted from the WSDL
     * - documentation: Total invoiced amount | Celková fakturovaná částka
     * @var \StructType\Price_Type
     */
    public $TotalInvoicedValue;
    /**
     * The PrepaidAmount
     * Meta information extracted from the WSDL
     * - documentation: Total prepaid amout - budget billing | Celkové zaplacené platby
     * - minOccurs: 0
     * @var \StructType\Price_Type
     */
    public $PrepaidAmount;
    /**
     * The Rounding
     * Meta information extracted from the WSDL
     * - documentation: Rounding | Haléřové vyrovnání
     * - minOccurs: 0
     * @var \StructType\Price_Type
     */
    public $Rounding;
    /**
     * The TotalAmountPayable
     * Meta information extracted from the WSDL
     * - documentation: Total payable amount | Celkem k zaplacení
     * - minOccurs: 0
     * @var \StructType\Price_Type
     */
    public $TotalAmountPayable;
    /**
     * Constructor method for PaymentSummary
     * @uses PaymentSummary::setTotalInvoicedValue()
     * @uses PaymentSummary::setPrepaidAmount()
     * @uses PaymentSummary::setRounding()
     * @uses PaymentSummary::setTotalAmountPayable()
     * @param \StructType\Price_Type $totalInvoicedValue
     * @param \StructType\Price_Type $prepaidAmount
     * @param \StructType\Price_Type $rounding
     * @param \StructType\Price_Type $totalAmountPayable
     */
    public function __construct(\StructType\Price_Type $totalInvoicedValue = null, \StructType\Price_Type $prepaidAmount = null, \StructType\Price_Type $rounding = null, \StructType\Price_Type $totalAmountPayable = null)
    {
        $this
            ->setTotalInvoicedValue($totalInvoicedValue)
            ->setPrepaidAmount($prepaidAmount)
            ->setRounding($rounding)
            ->setTotalAmountPayable($totalAmountPayable);
    }
    /**
     * Get TotalInvoicedValue value
     * @return \StructType\Price_Type|null
     */
    public function getTotalInvoicedValue()
    {
        return $this->TotalInvoicedValue;
    }
    /**
     * Set TotalInvoicedValue value
     * @param \StructType\Price_Type $totalInvoicedValue
     * @return \StructType\PaymentSummary
     */
    public function setTotalInvoicedValue(\StructType\Price_Type $totalInvoicedValue = null)
    {
        $this->TotalInvoicedValue = $totalInvoicedValue;
        return $this;
    }
    /**
     * Get PrepaidAmount value
     * @return \StructType\Price_Type|null
     */
    public function getPrepaidAmount()
    {
        return $this->PrepaidAmount;
    }
    /**
     * Set PrepaidAmount value
     * @param \StructType\Price_Type $prepaidAmount
     * @return \StructType\PaymentSummary
     */
    public function setPrepaidAmount(\StructType\Price_Type $prepaidAmount = null)
    {
        $this->PrepaidAmount = $prepaidAmount;
        return $this;
    }
    /**
     * Get Rounding value
     * @return \StructType\Price_Type|null
     */
    public function getRounding()
    {
        return $this->Rounding;
    }
    /**
     * Set Rounding value
     * @param \StructType\Price_Type $rounding
     * @return \StructType\PaymentSummary
     */
    public function setRounding(\StructType\Price_Type $rounding = null)
    {
        $this->Rounding = $rounding;
        return $this;
    }
    /**
     * Get TotalAmountPayable value
     * @return \StructType\Price_Type|null
     */
    public function getTotalAmountPayable()
    {
        return $this->TotalAmountPayable;
    }
    /**
     * Set TotalAmountPayable value
     * @param \StructType\Price_Type $totalAmountPayable
     * @return \StructType\PaymentSummary
     */
    public function setTotalAmountPayable(\StructType\Price_Type $totalAmountPayable = null)
    {
        $this->TotalAmountPayable = $totalAmountPayable;
        return $this;
    }
}
